/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.vacuum_chamber;

import com.google.gson.JsonObject;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import dev.bluephs.createvintageneoforged.content.kinetics.vacuum_chamber.VacuumChamberBlockEntity;
import dev.bluephs.createvintageneoforged.registry.VintageBlocks;
import dev.bluephs.createvintageneoforged.registry.VintageLang;
import dev.bluephs.createvintageneoforged.registry.VintageRecipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;

public class VacuumizingRecipe
extends BasinRecipe
implements IAssemblyRecipe {
    int secondaryFluidResults = -1;
    int secondaryFluidInputs = -1;

    public VacuumizingRecipe(ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)VintageRecipes.VACUUMIZING, params);
        this.processingDuration = 200;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getDescriptionForAssembly() {
        int startNum;
        FluidStack[] fluids;
        MutableComponent result = VintageLang.translateDirect("recipe.assembly.vacuumizing", new Object[0]);
        if (this.ingredients.size() <= 1 && this.fluidIngredients.isEmpty()) {
            return result;
        }
        result.append(" ").append((Component)VintageLang.translateDirect("recipe.assembly.with", new Object[0])).append(" ");
        if (this.ingredients.size() > 1) {
            if (((Ingredient)this.ingredients.get(1)).getItems().length > 0) {
                result.append(((Ingredient)this.ingredients.get(1)).getItems()[0].getItem().getDescription());
            }
        } else if (!this.fluidIngredients.isEmpty() && (fluids = ((SizedFluidIngredient)this.fluidIngredients.get(0)).getFluids()).length > 0) {
            result.append(String.valueOf(fluids[0]));
        }
        if (this.ingredients.size() > 2) {
            for (int i = 2; i < this.ingredients.size() - 1; ++i) {
                if (((Ingredient)this.ingredients.get(i)).getItems().length <= 0) continue;
                result.append(", ").append(((Ingredient)this.ingredients.get(i)).getItems()[0].getItem().getDescription());
            }
            if (((Ingredient)this.ingredients.get(this.ingredients.size() - 1)).getItems().length > 0) {
                if (this.fluidIngredients.isEmpty()) {
                    result.append(" ").append((Component)VintageLang.translateDirect("recipe.assembly.and", new Object[0]).append(" ").append(((Ingredient)this.ingredients.get(this.ingredients.size() - 1)).getItems()[0].getItem().getDescription()));
                } else {
                    result.append(", ").append(((Ingredient)this.ingredients.get(this.ingredients.size() - 1)).getItems()[0].getItem().getDescription());
                }
            }
        }
        int n = startNum = this.ingredients.size() > 1 ? 0 : 1;
        if (this.fluidIngredients.size() > startNum) {
            FluidStack[] lastFluids;
            FluidStack[] fluids2 = null;
            for (int i = startNum; i < this.fluidIngredients.size() - 1; ++i) {
                fluids2 = ((SizedFluidIngredient)this.fluidIngredients.get(i)).getFluids();
            }
            if (fluids2.length > 0) {
                result.append(", ").append(String.valueOf(fluids2[0]));
            }
            if ((lastFluids = ((SizedFluidIngredient)this.fluidIngredients.get(this.fluidIngredients.size() - 1)).getFluids()).length > 0) {
                result.append(" ").append((Component)VintageLang.translateDirect("recipe.assembly.and", new Object[0]).append(" ").append(String.valueOf(lastFluids[0])));
            }
        }
        return result;
    }

    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)VintageBlocks.VACUUM_CHAMBER.get());
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return null;
    }

    public static boolean match(BasinBlockEntity basin, Recipe<?> recipe, VacuumChamberBlockEntity be) {
        return VacuumizingRecipe.apply(basin, recipe, be, true);
    }

    public static boolean apply(BasinBlockEntity basin, Recipe<?> recipe, VacuumChamberBlockEntity be) {
        return VacuumizingRecipe.apply(basin, recipe, be, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean apply(BasinBlockEntity basin, Recipe<?> recipe, VacuumChamberBlockEntity be, boolean test) {
        boolean isBasinRecipe = recipe instanceof BasinRecipe;
        IItemHandler availableItems = (IItemHandler)basin.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, basin.getBlockPos(), null);
        IFluidHandler availableFluids = (IFluidHandler)basin.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, basin.getBlockPos(), null);
        IFluidHandler availableSecondaryFluids = (IFluidHandler)basin.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, basin.getBlockPos(), null);
        if (availableItems == null || availableFluids == null || availableSecondaryFluids == null) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = BasinBlockEntity.getHeatLevelOf((BlockState)basin.getLevel().getBlockState(basin.getBlockPos().below(1)));
        if (isBasinRecipe && !((BasinRecipe)recipe).getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        ArrayList<FluidStack> recipeSecondaryOutputFluids = new ArrayList<FluidStack>();
        LinkedList ingredients = new LinkedList(recipe.getIngredients());
        NonNullList fluidIngredients = isBasinRecipe ? ((BasinRecipe)recipe).getFluidIngredients() : Collections.emptyList();
        boolean[] blArray = Iterate.trueAndFalse;
        int n = blArray.length;
        int n2 = 0;
        while (true) {
            boolean simulate;
            block26: {
                NonNullList fss;
                if (n2 >= n) {
                    return true;
                }
                simulate = blArray[n2];
                if (!simulate && test) {
                    return true;
                }
                int[] extractedItemsFromSlot = new int[availableItems.getSlots()];
                int[] extractedFluidsFromTank = new int[availableFluids.getTanks()];
                int[] extractedSecondaryFluidsFromTank = new int[availableSecondaryFluids.getTanks()];
                int i = 0;
                block1: while (true) {
                    if (i >= ingredients.size()) break;
                    Ingredient ingredient = (Ingredient)ingredients.get(i);
                    int slot = 0;
                    while (true) {
                        ItemStack extracted;
                        if (slot >= availableItems.getSlots()) {
                            return false;
                        }
                        if ((!simulate || availableItems.getStackInSlot(slot).getCount() > extractedItemsFromSlot[slot]) && ingredient.test(extracted = availableItems.extractItem(slot, 1, true))) {
                            if (!simulate) {
                                availableItems.extractItem(slot, 1, false);
                            }
                            int n3 = slot;
                            extractedItemsFromSlot[n3] = extractedItemsFromSlot[n3] + 1;
                            ++i;
                            continue block1;
                        }
                        ++slot;
                    }
                    break;
                }
                boolean fluidsAffected = false;
                int i2 = 0;
                while (true) {
                    block27: {
                        int drainedAmount;
                        FluidStack fluidStack;
                        int tank;
                        int amountRequired;
                        FluidIngredient fluidIngredient;
                        block29: {
                            block30: {
                                block28: {
                                    if (i2 >= fluidIngredients.size()) break block28;
                                    SizedFluidIngredient sized = (SizedFluidIngredient)fluidIngredients.get(i2);
                                    fluidIngredient = sized.ingredient();
                                    amountRequired = sized.amount();
                                    if (!(recipe instanceof VacuumizingRecipe)) break block29;
                                    VacuumizingRecipe basinRecipe = (VacuumizingRecipe)recipe;
                                    if (basinRecipe.secondaryFluidInputs != i2) break block29;
                                    break block30;
                                }
                                if (fluidsAffected) {
                                    ((SmartFluidTankBehaviour)basin.getBehaviour(SmartFluidTankBehaviour.INPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                                    ((SmartFluidTankBehaviour)basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                                    ((SmartFluidTankBehaviour)be.getBehaviour(SmartFluidTankBehaviour.INPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                                    ((SmartFluidTankBehaviour)be.getBehaviour(SmartFluidTankBehaviour.OUTPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                                }
                                if (simulate && recipe instanceof VacuumizingRecipe) {
                                    break;
                                }
                                break block26;
                            }
                            for (tank = 0; tank < availableSecondaryFluids.getTanks(); ++tank) {
                                fluidStack = availableSecondaryFluids.getFluidInTank(tank);
                                if (simulate && fluidStack.getAmount() <= extractedSecondaryFluidsFromTank[tank] || !fluidIngredient.test(fluidStack)) continue;
                                drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                                if (!simulate) {
                                    fluidStack.shrink(drainedAmount);
                                    fluidsAffected = true;
                                }
                                if ((amountRequired -= drainedAmount) != 0) continue;
                                int n4 = tank;
                                extractedSecondaryFluidsFromTank[n4] = extractedSecondaryFluidsFromTank[n4] + drainedAmount;
                                break block27;
                            }
                            return false;
                        }
                        for (tank = 0; tank < availableFluids.getTanks(); ++tank) {
                            fluidStack = availableFluids.getFluidInTank(tank);
                            if (simulate && fluidStack.getAmount() <= extractedFluidsFromTank[tank] || !fluidIngredient.test(fluidStack)) continue;
                            drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                            if (!simulate) {
                                fluidStack.shrink(drainedAmount);
                                fluidsAffected = true;
                            }
                            if ((amountRequired -= drainedAmount) != 0) continue;
                            int n5 = tank;
                            extractedFluidsFromTank[n5] = extractedFluidsFromTank[n5] + drainedAmount;
                            break block27;
                        }
                        return false;
                    }
                    ++i2;
                }
                VacuumizingRecipe basinRecipe = (VacuumizingRecipe)recipe;
                recipeOutputItems.addAll(basinRecipe.rollResults(basin.getLevel().random));
                Iterator sized = basinRecipe.getIngredients().iterator();
                block6: while (true) {
                    if (!sized.hasNext()) {
                        fss = basinRecipe.getFluidResults();
                        if (basinRecipe.secondaryFluidResults >= 0 && basinRecipe.secondaryFluidResults + 1 <= fss.size()) {
                            recipeSecondaryOutputFluids.add((FluidStack)fss.get(basinRecipe.secondaryFluidResults));
                        }
                        break;
                    }
                    Ingredient ing = (Ingredient)sized.next();
                    ItemStack[] itemStackArray = ing.getItems();
                    int n6 = itemStackArray.length;
                    int n7 = 0;
                    while (true) {
                        ItemStack rem;
                        if (n7 >= n6) continue block6;
                        ItemStack stack = itemStackArray[n7];
                        if (!stack.isEmpty() && !(rem = stack.getCraftingRemainingItem()).isEmpty()) {
                            recipeOutputItems.add(rem.copy());
                        }
                        ++n7;
                    }
                    break;
                }
                for (int i3 = 0; i3 < fss.size(); ++i3) {
                    if (i3 == basinRecipe.secondaryFluidResults) continue;
                    recipeOutputFluids.add((FluidStack)fss.get(i3));
                }
            }
            if (!basin.acceptOutputs(recipeOutputItems, recipeOutputFluids, simulate)) {
                return false;
            }
            if (recipe instanceof VacuumizingRecipe) {
                VacuumizingRecipe basinRecipe = (VacuumizingRecipe)recipe;
                if (basinRecipe.secondaryFluidResults >= 0 && !be.acceptOutputs(recipeSecondaryOutputFluids, simulate)) {
                    return false;
                }
            }
            ++n2;
        }
    }

    public void readAdditional(JsonObject json) {
        if (json.has("secondaryFluidOutput")) {
            this.secondaryFluidResults = json.get("secondaryFluidOutput").getAsInt();
        }
        if (json.has("secondaryFluidInput")) {
            this.secondaryFluidInputs = json.get("secondaryFluidInput").getAsInt();
        }
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        this.secondaryFluidResults = buffer.readInt();
        this.secondaryFluidInputs = buffer.readInt();
    }

    public void writeAdditional(JsonObject json) {
        json.addProperty("secondaryFluidOutput", (Number)this.secondaryFluidResults);
        json.addProperty("secondaryFluidInput", (Number)this.secondaryFluidInputs);
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        buffer.writeInt(this.secondaryFluidResults);
        buffer.writeInt(this.secondaryFluidInputs);
    }

    public int getSecondaryFluidResults() {
        return this.secondaryFluidResults;
    }

    public int getSecondaryFluidInputs() {
        return this.secondaryFluidInputs;
    }

    public int getProcessingDuration() {
        return this.processingDuration;
    }
}

