/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.vibration;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import dev.bluephs.createvintageneoforged.registry.VintageBlocks;
import dev.bluephs.createvintageneoforged.registry.VintageLang;
import dev.bluephs.createvintageneoforged.registry.VintageRecipes;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
public class VibratingRecipe
extends StandardProcessingRecipe<RecipeWrapper>
implements IAssemblyRecipe {
    public VibratingRecipe(ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)VintageRecipes.VIBRATING, params);
    }

    public static void apply() {
    }

    protected ItemStack readOutput(JsonObject json) {
        String key;
        JsonObject resultObject;
        JsonObject jsonObject = resultObject = json.has("result") ? json.getAsJsonObject("result") : json;
        String string = resultObject.has("item") ? "item" : (key = resultObject.has("id") ? "id" : null);
        if (key == null) {
            throw new JsonSyntaxException("Missing 'item' or 'id' in vibrating recipe result: " + String.valueOf(json));
        }
        String idStr = resultObject.get(key).getAsString();
        ResourceLocation itemId = ResourceLocation.tryParse((String)idStr);
        if (itemId == null) {
            throw new JsonSyntaxException("Invalid resource location: " + idStr);
        }
        int count = resultObject.has("count") ? resultObject.get("count").getAsInt() : 1;
        Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
        if (item == null || item == Items.AIR) {
            throw new JsonSyntaxException("Unknown item id '" + String.valueOf(itemId) + "' in vibrating recipe result.");
        }
        return new ItemStack((ItemLike)item, count);
    }

    public boolean matches(RecipeWrapper inv, Level worldIn) {
        if (inv.isEmpty()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(inv.getItem(0));
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getDescriptionForAssembly() {
        return VintageLang.translateDirect("recipe.assembly.vibrating", new Object[0]);
    }

    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)VintageBlocks.VIBRATING_TABLE.get());
    }
}

