/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.content.kinetics.centrifuge;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import dev.bluephs.vintage.VintageBlockEntity;
import dev.bluephs.vintage.VintageBlocks;
import dev.bluephs.vintage.VintageItems;
import dev.bluephs.vintage.VintageShapes;
import dev.bluephs.vintage.content.kinetics.centrifuge.CentrifugeBlockEntity;
import dev.bluephs.vintage.content.kinetics.centrifuge.CentrifugeStructuralBlock;
import dev.bluephs.vintage.foundation.advancement.VintageAdvancementBehaviour;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CentrifugeBlock
extends KineticBlock
implements IBE<CentrifugeBlockEntity> {
    public static final VoxelShaper CENTRIFUGE_SHAPE = VintageShapes.shape(0.0, 0.0, 0.0, 16.0, 14.0, 16.0).forDirectional();

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        VintageAdvancementBehaviour.setPlacedBy(level, pos, placer);
        super.m_6402_(level, pos, state, placer, stack);
    }

    public CentrifugeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return CENTRIFUGE_SHAPE.get(Direction.UP);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        return this.onBlockEntityUse((BlockGetter)worldIn, pos, be -> {
            if (!heldItem.m_41619_()) {
                if (player.m_21120_(handIn).m_41720_() == AllBlocks.BASIN.m_5456_()) {
                    if (be.addBasin(player.m_21120_(handIn))) {
                        if (!player.m_7500_()) {
                            player.m_21120_(handIn).m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
                if (player.m_21120_(handIn).m_41720_() == VintageItems.REDSTONE_MODULE.get() && be.getBasins() == 4) {
                    if (be.addRedstoneApp(player.m_21120_(handIn))) {
                        if (!player.m_7500_()) {
                            player.m_21120_(handIn).m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
                if (be.getBasins() < 4 || be.getSpeed() != 0.0f) {
                    return InteractionResult.PASS;
                }
                if (FluidHelper.tryEmptyItemIntoBE((Level)worldIn, (Player)player, (InteractionHand)handIn, (ItemStack)heldItem, (SmartBlockEntity)be)) {
                    return InteractionResult.SUCCESS;
                }
                if (FluidHelper.tryFillItemFromBE((Level)worldIn, (Player)player, (InteractionHand)handIn, (ItemStack)heldItem, (SmartBlockEntity)be)) {
                    return InteractionResult.SUCCESS;
                }
                if (GenericItemEmptying.canItemBeEmptied((Level)worldIn, (ItemStack)heldItem) || GenericItemFilling.canItemBeFilled((Level)worldIn, (ItemStack)heldItem)) {
                    return InteractionResult.SUCCESS;
                }
                if (heldItem.m_41720_().equals(Items.f_41902_) && !be.getCapability(ForgeCapabilities.FLUID_HANDLER).map(iFluidHandler -> iFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE)).orElse(FluidStack.EMPTY).isEmpty()) {
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            if (be.getBasins() < 4 || be.getSpeed() != 0.0f) {
                return InteractionResult.PASS;
            }
            IItemHandlerModifiable inv = (IItemHandlerModifiable)be.capability.orElse((Object)new ItemStackHandler(1));
            boolean success = false;
            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stackInSlot = inv.getStackInSlot(slot);
                if (stackInSlot.m_41619_()) continue;
                player.m_150109_().m_150079_(stackInSlot);
                inv.setStackInSlot(slot, ItemStack.f_41583_);
                success = true;
            }
            if (success) {
                worldIn.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f + Create.RANDOM.nextFloat());
            }
            return InteractionResult.SUCCESS;
        });
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == Direction.Axis.Y;
    }

    public Class<CentrifugeBlockEntity> getBlockEntityClass() {
        return CentrifugeBlockEntity.class;
    }

    public BlockEntityType<? extends CentrifugeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)VintageBlockEntity.CENTRIFUGE.get();
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        BlockPos pos = context.m_8083_();
        Direction.Axis axis = Direction.Axis.Y;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockState occupiedState;
                    BlockPos offset;
                    if (axis.m_7863_(x, y, z) != 0 || (offset = new BlockPos(x, y, z)).equals((Object)BlockPos.f_121853_) || (occupiedState = context.m_43725_().m_8055_(pos.m_121955_((Vec3i)offset))).m_247087_()) continue;
                    return null;
                }
            }
        }
        return stateForPlacement;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!level.m_183326_().m_183582_(pos, (Object)this)) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        Direction.Axis axis = Direction.Axis.Y;
        for (Direction side : Iterate.directions) {
            if (side.m_122434_() == axis) continue;
            boolean[] blArray = Iterate.falseAndTrue;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                BlockState requiredStructure;
                Direction targetSide;
                boolean secondary;
                BlockPos structurePos = (secondary ? pPos.m_121945_(side) : pPos).m_121945_(targetSide = (secondary = blArray[i]) ? side.m_175362_(axis) : side);
                BlockState occupiedState = pLevel.m_8055_(structurePos);
                if (occupiedState == (requiredStructure = (BlockState)VintageBlocks.CENTRIFUGE_STRUCTURAL.getDefaultState().m_61124_((Property)CentrifugeStructuralBlock.f_52588_, (Comparable)targetSide.m_122424_()))) continue;
                if (!occupiedState.m_247087_()) {
                    pLevel.m_46961_(pPos, false);
                    return;
                }
                pLevel.m_46597_(structurePos, requiredStructure);
            }
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity be = this.getBlockEntity((BlockGetter)worldIn, pos);
        if (be instanceof CentrifugeBlockEntity) {
            CentrifugeBlockEntity cbe = (CentrifugeBlockEntity)be;
            if (!cbe.getRedstoneApp()) {
                return 0;
            }
            return cbe.isProccesingNow() ? 15 : 0;
        }
        return 0;
    }
}

