/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.content.kinetics.vacuum_chamber;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.bluephs.vintage.VintageLang;
import dev.bluephs.vintage.VintageRecipes;
import dev.bluephs.vintage.content.kinetics.vacuum_chamber.PressurizingRecipe;
import dev.bluephs.vintage.content.kinetics.vacuum_chamber.VacuumChamberBlock;
import dev.bluephs.vintage.content.kinetics.vacuum_chamber.VacuumizingRecipe;
import dev.bluephs.vintage.foundation.advancement.VintageAdvancementBehaviour;
import dev.bluephs.vintage.foundation.advancement.VintageAdvancements;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class VacuumChamberBlockEntity
extends BasinOperatingBlockEntity {
    private static final Object vacuumizingRecipesKey = new Object();
    public int runningTicks;
    public int processingTicks;
    public boolean running;
    public SmartFluidTankBehaviour outputTank;
    public SmartFluidTankBehaviour inputTank;
    public LazyOptional<IFluidHandler> fluidCapability;
    boolean contentsChanged;
    boolean mode = false;
    VintageAdvancementBehaviour advancementBehaviour;

    public VacuumChamberBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean changeMode() {
        this.basinChecker.scheduleUpdate();
        this.mode = !this.mode;
        return this.mode;
    }

    public float getRenderedHeadOffset(float partialTicks) {
        float offset = 0.0f;
        if (this.running) {
            if (this.runningTicks < 20) {
                int localTick = this.runningTicks;
                float num = ((float)localTick + partialTicks) / 20.0f;
                num = (2.0f - Mth.m_14089_((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
                offset = Mth.m_14036_((float)offset, (float)0.0f, (float)0.625f);
            } else if (this.runningTicks <= 20) {
                offset = 0.625f;
            } else {
                int localTick = 40 - this.runningTicks;
                float num = ((float)localTick - partialTicks) / 20.0f;
                num = (2.0f - Mth.m_14089_((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
                offset = Mth.m_14036_((float)offset, (float)0.0f, (float)0.625f);
            }
        }
        return offset + 0.4375f;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        }).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        behaviours.add((BlockEntityBehaviour)this.outputTank);
        this.fluidCapability = LazyOptional.of(() -> {
            LazyOptional inputCap = this.inputTank.getCapability();
            LazyOptional outputCap = this.outputTank.getCapability();
            return new VacuumChamberTanksHandler((IFluidHandler)outputCap.orElse(null), (IFluidHandler)inputCap.orElse(null));
        });
        this.advancementBehaviour = new VintageAdvancementBehaviour((SmartBlockEntity)this);
        behaviours.add(this.advancementBehaviour);
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82363_(0.0, -1.5, 0.0);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.running = compound.m_128471_("Running");
        this.runningTicks = compound.m_128451_("Ticks");
        this.mode = compound.m_128471_("Mode");
        super.read(compound, clientPacket);
        if (clientPacket && this.m_58898_()) {
            this.getBasin().ifPresent(bte -> bte.setAreFluidsMoving(this.running && this.runningTicks <= 20));
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Running", this.running);
        compound.m_128405_("Ticks", this.runningTicks);
        compound.m_128379_("Mode", this.mode);
        super.write(compound, clientPacket);
    }

    public void tick() {
        super.tick();
        if (this.runningTicks >= 40) {
            this.running = false;
            this.runningTicks = 0;
            this.basinChecker.scheduleUpdate();
            return;
        }
        float speed = Math.abs(this.getSpeed());
        if (this.running && this.f_58857_ != null) {
            if (this.f_58857_.f_46443_ && this.runningTicks == 20) {
                this.renderParticles();
            }
            if ((!this.f_58857_.f_46443_ || this.isVirtual()) && this.runningTicks == 20) {
                if (this.processingTicks < 0) {
                    Couple tanks;
                    int t;
                    float recipeSpeed = 1.0f;
                    if (this.currentRecipe instanceof ProcessingRecipe && (t = ((ProcessingRecipe)this.currentRecipe).getProcessingDuration()) != 0) {
                        recipeSpeed = (float)t / 100.0f;
                    }
                    this.processingTicks = Mth.m_14045_((int)(Mth.m_14173_((int)((int)(512.0f / speed))) * Mth.m_14167_((float)(recipeSpeed * 15.0f)) + 1), (int)1, (int)512);
                    Optional basin = this.getBasin();
                    if (!(!basin.isPresent() || ((SmartFluidTankBehaviour)(tanks = ((BasinBlockEntity)basin.get()).getTanks()).getFirst()).isEmpty() && ((SmartFluidTankBehaviour)tanks.getSecond()).isEmpty())) {
                        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11776_, SoundSource.BLOCKS, 0.75f, speed < 65.0f ? 0.75f : 1.5f);
                    }
                } else {
                    --this.processingTicks;
                    if (this.processingTicks == 0) {
                        ++this.runningTicks;
                        this.processingTicks = -1;
                        this.applyBasinRecipe();
                        this.sendData();
                    }
                }
            }
            if (this.runningTicks != 20) {
                ++this.runningTicks;
            }
        }
    }

    protected void applyBasinRecipe() {
        if (this.currentRecipe == null) {
            return;
        }
        Optional optionalBasin = this.getBasin();
        if (!optionalBasin.isPresent()) {
            return;
        }
        BasinBlockEntity basin = (BasinBlockEntity)optionalBasin.get();
        boolean wasEmpty = basin.canContinueProcessing();
        if (!this.mode && !VacuumizingRecipe.apply(basin, this.currentRecipe, this)) {
            return;
        }
        if (this.mode && !PressurizingRecipe.apply(basin, this.currentRecipe, this)) {
            return;
        }
        this.getProcessedRecipeTrigger().ifPresent(arg_0 -> ((VacuumChamberBlockEntity)this).award(arg_0));
        basin.inputTank.sendDataImmediately();
        this.advancementBehaviour.awardVintageAdvancement(VintageAdvancements.USE_COMPRESSOR);
        if (wasEmpty && this.matchBasinRecipe(this.currentRecipe)) {
            this.continueWithPreviousRecipe();
            this.sendData();
        }
        basin.notifyChangeOfContents();
    }

    protected List<Recipe<?>> getMatchingRecipes() {
        Optional basin = this.getBasin();
        if (basin.isEmpty()) {
            return null;
        }
        if (this.mode) {
            for (int i = 0; i < ((BasinBlockEntity)basin.get()).getInputInventory().getSlots(); ++i) {
                Ingredient cur2;
                Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)((BasinBlockEntity)basin.get()).getInputInventory().getStackInSlot(i), VintageRecipes.PRESSURIZING.getType(), PressurizingRecipe.class);
                if (!assemblyRecipe.isPresent() || !((BasinBlockEntity)basin.get()).getFilter().test(((PressurizingRecipe)((Object)assemblyRecipe.get())).m_8043_((RegistryAccess)RegistryAccess.f_243945_))) continue;
                if (!((PressurizingRecipe)((Object)assemblyRecipe.get())).getRequiredHeat().testBlazeBurner(BlazeBurnerBlock.getHeatLevelOf((BlockState)this.f_58857_.m_8055_(this.m_58899_().m_6625_(3))))) {
                    return this.getRecipes();
                }
                for (Ingredient cur2 : ((PressurizingRecipe)((Object)assemblyRecipe.get())).m_7527_()) {
                    boolean find = false;
                    for (ItemStack item : cur2.m_43908_()) {
                        if (item.m_41613_() > ((BasinBlockEntity)basin.get()).getInputInventory().m_18947_(item.m_41720_())) continue;
                        find = true;
                        break;
                    }
                    if (find) continue;
                    return this.getRecipes();
                }
                Iterator iterator = ((PressurizingRecipe)((Object)assemblyRecipe.get())).getFluidIngredients().iterator();
                if (iterator.hasNext() && !(cur2 = (FluidIngredient)iterator.next()).test(((BasinBlockEntity)basin.get()).inputTank.getPrimaryHandler().getFluid())) {
                    return this.getRecipes();
                }
                return ImmutableList.of((Object)((Recipe)assemblyRecipe.get()));
            }
        } else {
            for (int i = 0; i < ((BasinBlockEntity)basin.get()).getInputInventory().getSlots(); ++i) {
                Ingredient cur3;
                Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)((BasinBlockEntity)basin.get()).getInputInventory().getStackInSlot(i), VintageRecipes.VACUUMIZING.getType(), VacuumizingRecipe.class);
                if (!assemblyRecipe.isPresent() || !((BasinBlockEntity)basin.get()).getFilter().test(((VacuumizingRecipe)((Object)assemblyRecipe.get())).m_8043_((RegistryAccess)RegistryAccess.f_243945_))) continue;
                if (!((VacuumizingRecipe)((Object)assemblyRecipe.get())).getRequiredHeat().testBlazeBurner(BlazeBurnerBlock.getHeatLevelOf((BlockState)this.f_58857_.m_8055_(this.m_58899_().m_6625_(3))))) {
                    return this.getRecipes();
                }
                for (Ingredient cur3 : ((VacuumizingRecipe)((Object)assemblyRecipe.get())).m_7527_()) {
                    boolean find = false;
                    for (ItemStack item : cur3.m_43908_()) {
                        if (item.m_41613_() > ((BasinBlockEntity)basin.get()).getInputInventory().m_18947_(item.m_41720_())) continue;
                        find = true;
                        break;
                    }
                    if (find) continue;
                    return this.getRecipes();
                }
                Iterator iterator = ((VacuumizingRecipe)((Object)assemblyRecipe.get())).getFluidIngredients().iterator();
                if (iterator.hasNext() && !(cur3 = (FluidIngredient)iterator.next()).test(((BasinBlockEntity)basin.get()).inputTank.getPrimaryHandler().getFluid())) {
                    return this.getRecipes();
                }
                return ImmutableList.of((Object)((Recipe)assemblyRecipe.get()));
            }
        }
        return this.getRecipes();
    }

    List<Recipe<?>> getRecipes() {
        ArrayList res = new ArrayList();
        for (Recipe recipe : super.getMatchingRecipes()) {
            if (this.mode && recipe instanceof PressurizingRecipe) {
                res.add(recipe);
                continue;
            }
            if (this.mode || !(recipe instanceof VacuumizingRecipe)) continue;
            res.add(recipe);
        }
        return res;
    }

    protected <C extends Container> boolean matchBasinRecipe(Recipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        Optional basin = this.getBasin();
        if (!basin.isPresent()) {
            return false;
        }
        SmartInventory outputInventory = ((BasinBlockEntity)basin.get()).getOutputInventory();
        for (int i = 0; i < outputInventory.getSlots(); ++i) {
            if (!outputInventory.getStackInSlot(i).m_41782_() || outputInventory.getStackInSlot(i).m_41783_().m_128423_("SequencedAssembly") == null) continue;
            return false;
        }
        if (recipe instanceof VacuumizingRecipe) {
            VacuumizingRecipe r = (VacuumizingRecipe)recipe;
            return VacuumizingRecipe.match((BasinBlockEntity)basin.get(), recipe, this);
        }
        if (recipe instanceof PressurizingRecipe) {
            PressurizingRecipe r = (PressurizingRecipe)recipe;
            return PressurizingRecipe.match((BasinBlockEntity)basin.get(), recipe, this);
        }
        return BasinRecipe.match((BasinBlockEntity)((BasinBlockEntity)basin.get()), recipe);
    }

    public boolean acceptOutputs(List<FluidStack> outputFluids, boolean simulate) {
        this.outputTank.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputFluids, simulate);
        this.outputTank.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<FluidStack> outputFluids, boolean simulate) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof VacuumChamberBlock)) {
            return false;
        }
        IFluidHandler targetTank = (IFluidHandler)this.outputTank.getCapability().orElse(null);
        if (outputFluids.isEmpty()) {
            return true;
        }
        if (targetTank == null) {
            return false;
        }
        return this.acceptFluidOutputsIntoCentrifuge(outputFluids, simulate, targetTank);
    }

    private boolean acceptFluidOutputsIntoCentrifuge(List<FluidStack> outputFluids, boolean simulate, IFluidHandler targetTank) {
        for (FluidStack fluidStack : outputFluids) {
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            int fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidStack.copy(), action) : targetTank.fill(fluidStack.copy(), action);
            if (fill == fluidStack.getAmount()) continue;
            return false;
        }
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void renderParticles() {
        Optional basin = this.getBasin();
        if (!basin.isPresent() || this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.m_8055_(this.m_58899_().m_7494_()).m_60713_(Blocks.f_50016_)) {
            return;
        }
        if (Mth.m_14154_((float)this.getSpeed()) < IRotate.SpeedLevel.MEDIUM.getSpeedValue()) {
            return;
        }
        float angle = this.f_58857_.f_46441_.m_188501_() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.25);
        offset = VecHelper.rotate((Vec3)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 target = VecHelper.rotate((Vec3)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y).m_82520_(0.0, 0.25, 0.0);
        Vec3 center = offset.m_82549_(VecHelper.getCenterOf((Vec3i)this.f_58858_));
        target = VecHelper.offsetRandomly((Vec3)target.m_82546_(offset), (RandomSource)this.f_58857_.f_46441_, (float)0.0078125f);
        if (this.mode) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, center.f_82479_ + target.f_82479_ * 10.0, center.f_82480_ + 0.5 + target.f_82480_ * 10.0, center.f_82481_ + target.f_82481_ * 10.0, -target.f_82479_ * 0.6, -target.f_82480_ * 0.6, -target.f_82481_ * 0.6);
        } else {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, center.f_82479_, center.f_82480_ + 0.5, center.f_82481_, target.f_82479_, target.f_82480_, target.f_82481_);
        }
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> r) {
        return r.m_6671_() == VintageRecipes.VACUUMIZING.getType() || r.m_6671_() == VintageRecipes.PRESSURIZING.getType();
    }

    public void startProcessingBasin() {
        if (this.running && this.runningTicks <= 20) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        this.runningTicks = 0;
    }

    public boolean continueWithPreviousRecipe() {
        this.runningTicks = 20;
        return true;
    }

    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.runningTicks = 40;
        this.running = false;
    }

    protected Object getRecipeCacheKey() {
        return vacuumizingRecipesKey;
    }

    protected boolean isRunning() {
        return this.running;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.runningTicks == 25) {
            AllSoundEvents.STEAM.playAt(this.f_58857_, (Vec3i)this.f_58858_, 3.0f, 1.0f, true);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.mode) {
            VintageLang.translate("gui.goggles.current_mode", new Object[0]).add(VintageLang.text((String)" ")).add(VintageLang.translate("gui.goggles.pressurizing_mode", new Object[0])).style(ChatFormatting.DARK_PURPLE).forGoggles(tooltip);
        } else {
            VintageLang.translate("gui.goggles.current_mode", new Object[0]).add(VintageLang.text((String)" ")).add(VintageLang.translate("gui.goggles.vacuumizing_mode", new Object[0])).style(ChatFormatting.DARK_AQUA).forGoggles(tooltip);
        }
        IFluidHandler fluids = (IFluidHandler)this.fluidCapability.orElse((Object)new FluidTank(0));
        boolean isEmpty = true;
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        for (int i = 0; i < fluids.getTanks(); ++i) {
            FluidStack fluidStack = fluids.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            CreateLang.text((String)"").add(CreateLang.fluidName((FluidStack)fluidStack).add(CreateLang.text((String)" ")).style(ChatFormatting.GRAY).add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (isEmpty) {
            tooltip.remove(0);
        }
        return true;
    }

    private class VacuumChamberTanksHandler
    extends CombinedTankWrapper {
        public VacuumChamberTanksHandler(IFluidHandler ... fluidHandlers) {
            super(fluidHandlers);
        }
    }
}

