/*
 * Decompiled with CFR 0.152.
 */
package net.syrupstudios.fortunecookie;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;

public class FortuneManager {
    private static final List<String> FORTUNES = new ArrayList<String>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Random RANDOM = new Random();
    private static final String[] DEFAULT_FORTUNES = new String[]{"If money really changes everything, then maybe you should try changing the money.", "There is more to life than just money, there's Bitcoin.", "You dont become a failure until you're satisfied with being one."};

    public static void initialize() {
        for (String fortune : DEFAULT_FORTUNES) {
            FORTUNES.add(fortune);
        }
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("luckyducks_fortunecookies", "fortunes");
            }

            public void method_14491(class_3300 manager) {
                FORTUNES.clear();
                manager.method_14488("fortunes", path -> path.method_12832().endsWith(".json")).forEach((identifier, resource) -> {
                    try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
                        JsonElement element = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                        if (element.isJsonObject() && element.getAsJsonObject().has("fortunes")) {
                            JsonArray array = element.getAsJsonObject().getAsJsonArray("fortunes");
                            for (JsonElement fortune : array) {
                                FORTUNES.add(fortune.getAsString());
                            }
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Error loading fortune file: " + String.valueOf(identifier));
                        e.printStackTrace();
                    }
                });
                if (FORTUNES.isEmpty()) {
                    for (String fortune : DEFAULT_FORTUNES) {
                        FORTUNES.add(fortune);
                    }
                }
                System.out.println("Loaded " + FORTUNES.size() + " fortunes");
            }
        });
    }

    public static String getRandomFortune(class_1937 world) {
        if (FORTUNES.isEmpty()) {
            return "Your fortune cookie is empty!";
        }
        return FORTUNES.get(RANDOM.nextInt(FORTUNES.size()));
    }
}

