/*
 * Decompiled with CFR 0.152.
 */
package net.syrupstudios.fortunecookie;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.syrupstudios.fortunecookie.Fortune;

public class FortuneManager {
    private static final List<Fortune> FORTUNES = new ArrayList<Fortune>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Random RANDOM = new Random();
    private static final List<Fortune> DEFAULT_FORTUNES = List.of(new Fortune("If money really changes everything, then maybe you should try changing the money.", 1), new Fortune("There is more to life than just money, there's Bitcoin.", 0), new Fortune("You dont become a failure until you're satisfied with being one.", -1));

    public static void initialize() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("luckyducks_fortunecookies", "fortunes");
            }

            public void method_14491(class_3300 manager) {
                FORTUNES.clear();
                manager.method_14488("fortunes", path -> path.method_12832().endsWith(".json")).forEach((identifier, resource) -> {
                    try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
                        JsonElement element = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                        if (element.isJsonObject() && element.getAsJsonObject().has("fortunes")) {
                            JsonArray array = element.getAsJsonObject().getAsJsonArray("fortunes");
                            for (JsonElement fortune : array) {
                                FORTUNES.add(new Fortune(fortune.getAsString(), 1));
                            }
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Error loading fortune file: " + String.valueOf(identifier));
                        e.printStackTrace();
                    }
                });
                if (FORTUNES.isEmpty()) {
                    FORTUNES.addAll(DEFAULT_FORTUNES);
                }
                System.out.println("Loaded " + FORTUNES.size() + " fortunes");
            }
        });
    }

    public static Fortune getRandomFortune() {
        if (FORTUNES.isEmpty()) {
            return new Fortune("Your fortune cookie is empty!", 0);
        }
        return FORTUNES.get(RANDOM.nextInt(FORTUNES.size()));
    }
}

