/*
 * Decompiled with CFR 0.152.
 */
package me.felixsoftwind.guestmode;

import com.destroystokyo.paper.event.player.PlayerPickupExperienceEvent;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class GuestModePlugin
extends JavaPlugin
implements Listener {
    private final Set<String> guests = new HashSet<String>();
    private final Set<String> except = new HashSet<String>();
    private boolean allGuests = false;
    private boolean allExcept = false;
    private File configFile;
    private YamlConfiguration yaml;
    private final Map<UUID, Location> orbOrigin = new ConcurrentHashMap<UUID, Location>();
    private ScheduledTask globalFreezeTask;
    private ScheduledTask guestInvisibilityTask;
    private ScheduledTask worldFreezeTask;
    private ScheduledTask mobFreezeTask;
    private final Map<World, Boolean> frozenWorlds = new ConcurrentHashMap<World, Boolean>();
    private static final double MOB_ATTENTION_RADIUS = 8.0;
    private static final double ORB_RADIUS = 10.0;
    private static final double ANCHOR_EPS2 = 0.0625;
    private static final double AABB_PAD = 0.06;
    private static final double TOP_EPS = 0.03;
    private static final double NEAR = 3.0;
    private static final double SAFE_GAP = 0.04;

    public void onEnable() {
        this.saveDefaultConfig();
        this.configFile = new File(this.getDataFolder(), "config.yml");
        this.yaml = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.reloadLists();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.startGlobalFreezeTask();
        this.startGuestInvisibilityTask();
        this.startWorldFreezeTask();
        this.getLogger().info("\ud83d\udc7b GuestMode enabled. Guests: " + this.guests.size());
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.applyMode(player);
        }
    }

    public void onDisable() {
        if (this.globalFreezeTask != null) {
            this.globalFreezeTask.cancel();
            this.globalFreezeTask = null;
        }
        if (this.guestInvisibilityTask != null) {
            this.guestInvisibilityTask.cancel();
            this.guestInvisibilityTask = null;
        }
        if (this.worldFreezeTask != null) {
            this.worldFreezeTask.cancel();
            this.worldFreezeTask = null;
        }
        if (this.mobFreezeTask != null) {
            this.mobFreezeTask.cancel();
            this.mobFreezeTask = null;
        }
        this.orbOrigin.clear();
        for (Player player : Bukkit.getOnlinePlayers()) {
            try {
                player.setSleepingIgnored(false);
            }
            catch (Throwable throwable) {}
        }
    }

    private void reloadLists() {
        this.yaml = YamlConfiguration.loadConfiguration((File)this.configFile);
        List list = this.yaml.getStringList("guests");
        List list2 = this.yaml.getStringList("except");
        this.allGuests = list.contains("[all]") || list.contains("all");
        this.allExcept = list2.contains("[all]") || list2.contains("all");
        this.guests.clear();
        this.except.clear();
        for (String string : list) {
            if (string.equalsIgnoreCase("[all]") || string.equalsIgnoreCase("all")) continue;
            this.guests.add(string);
        }
        for (String string : list2) {
            if (string.equalsIgnoreCase("[all]") || string.equalsIgnoreCase("all")) continue;
            this.except.add(string);
        }
        this.getLogger().info("\u2699 Modes: guests=[all]=" + this.allGuests + ", except=[all]=" + this.allExcept);
    }

    private void saveLists() {
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.guests);
            ArrayList<String> arrayList2 = new ArrayList<String>(this.except);
            if (this.allGuests && !arrayList.contains("[all]") && !arrayList.contains("all")) {
                arrayList.add(0, "[all]");
            }
            if (this.allExcept && !arrayList2.contains("[all]") && !arrayList2.contains("all")) {
                arrayList2.add(0, "[all]");
            }
            this.yaml.set("guests", arrayList);
            this.yaml.set("except", arrayList2);
            this.yaml.save(this.configFile);
            this.getLogger().info("\ud83d\udcbe Saved config: guests=" + String.valueOf(arrayList) + ", except=" + String.valueOf(arrayList2));
        }
        catch (IOException iOException) {
            this.getLogger().severe("\u274c Failed to save config.yml: " + iOException.getMessage());
        }
    }

    private boolean isGuest(Player player) {
        String string = player.getName();
        if (this.allExcept) {
            return this.guests.contains(string);
        }
        if (this.except.contains(string)) {
            return false;
        }
        if (this.allGuests) {
            return true;
        }
        return this.guests.contains(string);
    }

    private void applyMode(Player player) {
        if (this.isGuest(player)) {
            this.enableGhostMode(player);
        } else {
            this.disableGhostMode(player);
        }
    }

    private void enableGhostMode(Player player) {
        player.setGameMode(GameMode.ADVENTURE);
        player.setInvulnerable(true);
        player.setCollidable(false);
        player.setAllowFlight(true);
        player.setFlying(true);
        player.setCanPickupItems(false);
        player.setFireTicks(0);
        player.sendActionBar("\u00a77\ud83d\udc7b Guest mode is ON");
        this.freezeOrbsAround(player);
        try {
            player.setSleepingIgnored(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void disableGhostMode(Player player) {
        player.setGameMode(GameMode.SURVIVAL);
        player.setInvulnerable(false);
        player.setCollidable(true);
        player.setAllowFlight(false);
        player.setCanPickupItems(true);
        player.sendActionBar("\u00a7aGuest mode is OFF");
        try {
            player.setSleepingIgnored(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void startGuestInvisibilityTask() {
        this.guestInvisibilityTask = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this, scheduledTask2 -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!this.isGuest(player)) continue;
                player.getScheduler().run((Plugin)this, scheduledTask -> this.updateGuestInvisibility(player), null);
            }
        }, 1L, 1L);
    }

    private void updateGuestInvisibility(Player player) {
        Collection collection = player.getWorld().getNearbyEntitiesByType(LivingEntity.class, player.getLocation(), 8.0, 8.0, 8.0, livingEntity -> !(livingEntity instanceof Player) && !(livingEntity instanceof ArmorStand));
        if (!collection.isEmpty()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 30, 0, false, false, false));
            boolean bl = false;
            double d = 32.0;
            for (Player player2 : player.getWorld().getPlayers()) {
                double d2;
                if (player2 == player || this.isGuest(player2) || (d2 = player2.getLocation().distanceSquared(player.getLocation())) > d * d || !player2.hasLineOfSight((Entity)player)) continue;
                bl = true;
                break;
            }
            if (bl) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 30, 0, true, false, false));
            } else if (player.hasPotionEffect(PotionEffectType.GLOWING)) {
                player.removePotionEffect(PotionEffectType.GLOWING);
            }
        } else {
            if (player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                player.removePotionEffect(PotionEffectType.INVISIBILITY);
            }
            if (player.hasPotionEffect(PotionEffectType.GLOWING)) {
                player.removePotionEffect(PotionEffectType.GLOWING);
            }
        }
        player.setFireTicks(0);
    }

    private void startWorldFreezeTask() {
        this.worldFreezeTask = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this, scheduledTask -> {
            for (World world : Bukkit.getWorlds()) {
                this.updateWorldFreeze(world);
            }
        }, 1L, 20L);
        this.mobFreezeTask = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this, scheduledTask2 -> {
            for (World world : Bukkit.getWorlds()) {
                if (!Boolean.TRUE.equals(this.frozenWorlds.get(world))) continue;
                for (LivingEntity livingEntity : world.getLivingEntities()) {
                    if (livingEntity instanceof Player) continue;
                    livingEntity.getScheduler().run((Plugin)this, scheduledTask -> this.freezeMob(livingEntity), null);
                }
            }
        }, 1L, 1L);
    }

    private void freezeMob(LivingEntity livingEntity) {
        livingEntity.setVelocity(new Vector(0, 0, 0));
        livingEntity.setAI(false);
        livingEntity.setGravity(false);
        livingEntity.setInvulnerable(true);
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            mob.setTarget(null);
        }
    }

    private void updateWorldFreeze(World world) {
        Object object2;
        boolean bl = false;
        for (Object object2 : world.getPlayers()) {
            if (this.isGuest((Player)object2)) continue;
            bl = true;
            break;
        }
        boolean bl2 = !bl;
        object2 = this.frozenWorlds.get(world);
        if (object2 == null || (Boolean)object2 != bl2) {
            this.frozenWorlds.put(world, bl2);
            if (bl2) {
                world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
                world.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
                world.setGameRule(GameRule.DO_MOB_SPAWNING, (Object)false);
                world.setGameRule(GameRule.RANDOM_TICK_SPEED, (Object)0);
                this.getLogger().info("\ud83e\uddca Frozen world: " + world.getName());
            } else {
                world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)true);
                world.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)true);
                world.setGameRule(GameRule.DO_MOB_SPAWNING, (Object)true);
                world.setGameRule(GameRule.RANDOM_TICK_SPEED, (Object)3);
                for (LivingEntity livingEntity : world.getLivingEntities()) {
                    if (livingEntity instanceof Player) continue;
                    livingEntity.getScheduler().run((Plugin)this, scheduledTask -> {
                        livingEntity.setAI(true);
                        livingEntity.setGravity(true);
                        livingEntity.setInvulnerable(false);
                    }, null);
                }
                this.getLogger().info("\ud83d\udd25 Unfrozen world: " + world.getName());
            }
        }
    }

    @EventHandler
    public void onOrbSpawn(EntitySpawnEvent entitySpawnEvent) {
        Entity entity = entitySpawnEvent.getEntity();
        if (entity instanceof ExperienceOrb) {
            ExperienceOrb experienceOrb = (ExperienceOrb)entity;
            this.orbOrigin.put(experienceOrb.getUniqueId(), experienceOrb.getLocation().clone());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPickupXp(PlayerPickupExperienceEvent playerPickupExperienceEvent) {
        Player player = playerPickupExperienceEvent.getPlayer();
        ExperienceOrb experienceOrb = playerPickupExperienceEvent.getExperienceOrb();
        if (experienceOrb != null) {
            if (this.isGuest(player)) {
                playerPickupExperienceEvent.setCancelled(true);
                return;
            }
            this.orbOrigin.remove(experienceOrb.getUniqueId());
        }
    }

    private void startGlobalFreezeTask() {
        this.globalFreezeTask = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this, scheduledTask2 -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!this.isGuest(player)) continue;
                player.getScheduler().run((Plugin)this, scheduledTask -> this.freezeOrbsAround(player), null);
            }
        }, 1L, 1L);
    }

    private void freezeOrbsAround(Player player) {
        Collection collection = player.getWorld().getNearbyEntitiesByType(ExperienceOrb.class, player.getLocation(), 10.0, 10.0, 10.0);
        if (collection.isEmpty()) {
            return;
        }
        for (ExperienceOrb experienceOrb : collection) {
            experienceOrb.getScheduler().run((Plugin)this, scheduledTask -> this.updateOrbState(experienceOrb), null);
        }
    }

    private void updateOrbState(ExperienceOrb experienceOrb) {
        Location location = experienceOrb.getLocation();
        boolean bl = false;
        boolean bl2 = false;
        for (Player player : experienceOrb.getWorld().getNearbyPlayers(location, 10.0)) {
            if (this.isGuest(player)) {
                bl = true;
            } else {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            break;
        }
        if (bl && !bl2) {
            Location location2 = this.orbOrigin.computeIfAbsent(experienceOrb.getUniqueId(), uUID -> experienceOrb.getLocation().clone());
            if (!this.sameBlockOrClose(location, location2)) {
                experienceOrb.teleportAsync(location2);
            }
            experienceOrb.setVelocity(new Vector(0, 0, 0));
            try {
                experienceOrb.setGravity(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            experienceOrb.setFireTicks(0);
        } else {
            try {
                experienceOrb.setGravity(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private boolean sameBlockOrClose(Location location, Location location2) {
        if (location.getWorld() != location2.getWorld()) {
            return false;
        }
        return location.distanceSquared(location2) <= 0.0625;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onMove(PlayerMoveEvent playerMoveEvent) {
        Player player = playerMoveEvent.getPlayer();
        if (!this.isGuest(player)) {
            return;
        }
        if (playerMoveEvent.getTo() == null) {
            return;
        }
        double d = playerMoveEvent.getTo().getX() - playerMoveEvent.getFrom().getX();
        double d2 = playerMoveEvent.getTo().getY() - playerMoveEvent.getFrom().getY();
        double d3 = playerMoveEvent.getTo().getZ() - playerMoveEvent.getFrom().getZ();
        if (d == 0.0 && d3 == 0.0 && d2 >= 0.0) {
            return;
        }
        BoundingBox boundingBox = player.getBoundingBox().shift(d, d2, d3).expand(0.06);
        Collection collection = player.getWorld().getNearbyEntities(playerMoveEvent.getTo(), 3.0, 3.0, 3.0, entity -> entity != player && (entity instanceof Player || entity instanceof LivingEntity || entity instanceof Vehicle));
        if (d2 < 0.0 && !collection.isEmpty()) {
            double d4;
            double d5;
            double d6 = Double.NEGATIVE_INFINITY;
            boolean bl = false;
            for (Entity entity2 : collection) {
                BoundingBox boundingBox2 = entity2.getBoundingBox().expand(0.06);
                if (!boundingBox.overlaps(boundingBox2)) continue;
                bl = true;
                d6 = Math.max(d6, boundingBox2.getMaxY());
            }
            if (bl && (d5 = d6 + 0.03 - (d4 = boundingBox.getMinY())) > 0.0) {
                Location location = playerMoveEvent.getTo().clone();
                location.setY(location.getY() + d5);
                playerMoveEvent.setTo(location);
                return;
            }
        }
        if (!(d == 0.0 && d3 == 0.0 || collection.isEmpty())) {
            Location location = playerMoveEvent.getTo().clone();
            Location location2 = playerMoveEvent.getFrom().clone();
            Location location3 = this.resolveOverlapsForMove(player, location2, location, collection);
            if (!location3.equals((Object)location)) {
                playerMoveEvent.setTo(location3);
                return;
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        this.applyMode(playerJoinEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onNonGuestMove(PlayerMoveEvent playerMoveEvent) {
        Player player = playerMoveEvent.getPlayer();
        if (this.isGuest(player)) {
            return;
        }
        if (playerMoveEvent.getTo() == null) {
            return;
        }
        Collection collection = player.getWorld().getNearbyPlayers(playerMoveEvent.getTo(), 3.0, 3.0, 3.0, this::isGuest);
        if (collection.isEmpty()) {
            return;
        }
        BoundingBox boundingBox = player.getBoundingBox().expand(0.06);
        for (Player player2 : collection) {
            player2.getScheduler().run((Plugin)this, scheduledTask -> {
                BoundingBox boundingBox2;
                BoundingBox boundingBox3 = player2.getBoundingBox().expand(0.06);
                if (!boundingBox3.overlaps(boundingBox)) {
                    return;
                }
                Location location = player2.getLocation().clone();
                for (int i = 0; i < 3 && (boundingBox2 = player2.getBoundingBox().expand(0.06)).overlaps(boundingBox); ++i) {
                    Vector vector = GuestModePlugin.mtdHorizontal(boundingBox2, boundingBox, 0.04);
                    location.add(vector.getX(), 0.0, vector.getZ());
                    player2.teleportAsync(location);
                }
            }, null);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent blockBreakEvent) {
        if (this.isGuest(blockBreakEvent.getPlayer())) {
            blockBreakEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        if (this.isGuest(blockPlaceEvent.getPlayer())) {
            blockPlaceEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockDamage(BlockDamageEvent blockDamageEvent) {
        if (this.isGuest(blockDamageEvent.getPlayer())) {
            blockDamageEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent playerInteractEvent) {
        if (this.isGuest(playerInteractEvent.getPlayer())) {
            playerInteractEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onBucketEmpty(PlayerBucketEmptyEvent playerBucketEmptyEvent) {
        if (this.isGuest(playerBucketEmptyEvent.getPlayer())) {
            playerBucketEmptyEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onBucketFill(PlayerBucketFillEvent playerBucketFillEvent) {
        if (this.isGuest(playerBucketFillEvent.getPlayer())) {
            playerBucketFillEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onArmorStand(PlayerArmorStandManipulateEvent playerArmorStandManipulateEvent) {
        if (this.isGuest(playerArmorStandManipulateEvent.getPlayer())) {
            playerArmorStandManipulateEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onEditBook(PlayerEditBookEvent playerEditBookEvent) {
        if (this.isGuest(playerEditBookEvent.getPlayer())) {
            playerEditBookEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onSign(SignChangeEvent signChangeEvent) {
        if (this.isGuest(signChangeEvent.getPlayer())) {
            signChangeEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent playerDropItemEvent) {
        if (this.isGuest(playerDropItemEvent.getPlayer())) {
            playerDropItemEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onPickup(EntityPickupItemEvent entityPickupItemEvent) {
        Player player;
        LivingEntity livingEntity = entityPickupItemEvent.getEntity();
        if (livingEntity instanceof Player && this.isGuest(player = (Player)livingEntity)) {
            entityPickupItemEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onSwap(PlayerSwapHandItemsEvent playerSwapHandItemsEvent) {
        if (this.isGuest(playerSwapHandItemsEvent.getPlayer())) {
            playerSwapHandItemsEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemHeld(PlayerItemHeldEvent playerItemHeldEvent) {
        if (this.isGuest(playerItemHeldEvent.getPlayer())) {
            playerItemHeldEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemConsume(PlayerItemConsumeEvent playerItemConsumeEvent) {
        if (this.isGuest(playerItemConsumeEvent.getPlayer())) {
            playerItemConsumeEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onInvOpen(InventoryOpenEvent inventoryOpenEvent) {
        Player player;
        HumanEntity humanEntity = inventoryOpenEvent.getPlayer();
        if (humanEntity instanceof Player && this.isGuest(player = (Player)humanEntity)) {
            inventoryOpenEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onInvClick(InventoryClickEvent inventoryClickEvent) {
        Player player;
        HumanEntity humanEntity = inventoryClickEvent.getWhoClicked();
        if (humanEntity instanceof Player && this.isGuest(player = (Player)humanEntity)) {
            inventoryClickEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onInvDrag(InventoryDragEvent inventoryDragEvent) {
        Player player;
        HumanEntity humanEntity = inventoryDragEvent.getWhoClicked();
        if (humanEntity instanceof Player && this.isGuest(player = (Player)humanEntity)) {
            inventoryDragEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onCraft(CraftItemEvent craftItemEvent) {
        Player player;
        HumanEntity humanEntity = craftItemEvent.getWhoClicked();
        if (humanEntity instanceof Player && this.isGuest(player = (Player)humanEntity)) {
            craftItemEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onFurnace(FurnaceExtractEvent furnaceExtractEvent) {
        if (this.isGuest(furnaceExtractEvent.getPlayer())) {
            furnaceExtractEvent.setExpToDrop(0);
        }
    }

    @EventHandler
    public void onHangingPlace(HangingPlaceEvent hangingPlaceEvent) {
        if (this.isGuest(hangingPlaceEvent.getPlayer())) {
            hangingPlaceEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onHangingBreak(HangingBreakByEntityEvent hangingBreakByEntityEvent) {
        Player player;
        Entity entity = hangingBreakByEntityEvent.getRemover();
        if (entity instanceof Player && this.isGuest(player = (Player)entity)) {
            hangingBreakByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteractEntity(PlayerInteractEntityEvent playerInteractEntityEvent) {
        if (this.isGuest(playerInteractEntityEvent.getPlayer())) {
            playerInteractEntityEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteractAtEntity(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        if (this.isGuest(playerInteractAtEntityEvent.getPlayer())) {
            playerInteractAtEntityEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onBedEnter(PlayerBedEnterEvent playerBedEnterEvent) {
        if (this.isGuest(playerBedEnterEvent.getPlayer())) {
            playerBedEnterEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onShear(PlayerShearEntityEvent playerShearEntityEvent) {
        if (this.isGuest(playerShearEntityEvent.getPlayer())) {
            playerShearEntityEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onFish(PlayerFishEvent playerFishEvent) {
        if (this.isGuest(playerFishEvent.getPlayer())) {
            playerFishEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onVehicleEnter(VehicleEnterEvent vehicleEnterEvent) {
        Player player;
        Entity entity = vehicleEnterEvent.getEntered();
        if (entity instanceof Player && this.isGuest(player = (Player)entity)) {
            vehicleEnterEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onVehicleExit(VehicleExitEvent vehicleExitEvent) {
        Player player;
        LivingEntity livingEntity = vehicleExitEvent.getExited();
        if (livingEntity instanceof Player && this.isGuest(player = (Player)livingEntity)) {
            vehicleExitEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onVehicleDamage(VehicleDamageEvent vehicleDamageEvent) {
        Player player;
        Entity entity = vehicleDamageEvent.getAttacker();
        if (entity instanceof Player && this.isGuest(player = (Player)entity)) {
            vehicleDamageEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onVehicleDestroy(VehicleDestroyEvent vehicleDestroyEvent) {
        Player player;
        Entity entity = vehicleDestroyEvent.getAttacker();
        if (entity instanceof Player && this.isGuest(player = (Player)entity)) {
            vehicleDestroyEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamageToGuest(EntityDamageEvent entityDamageEvent) {
        Player player;
        Entity entity = entityDamageEvent.getEntity();
        if (entity instanceof Player && this.isGuest(player = (Player)entity)) {
            entityDamageEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCombust(EntityCombustEvent entityCombustEvent) {
        Player player;
        Entity entity = entityCombustEvent.getEntity();
        if (entity instanceof Player && this.isGuest(player = (Player)entity)) {
            entityCombustEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTarget(EntityTargetEvent entityTargetEvent) {
        Player player;
        Entity entity = entityTargetEvent.getTarget();
        if (entity instanceof Player && this.isGuest(player = (Player)entity)) {
            entityTargetEvent.setTarget(null);
            entityTargetEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamageByGuest(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player && this.isGuest(player = (Player)entity)) {
            entityDamageByEntityEvent.setCancelled(true);
            return;
        }
        Entity entity2 = entityDamageByEntityEvent.getDamager();
        if (entity2 instanceof Tameable && (entity2 = (player = (Tameable)entity2).getOwner()) instanceof Player && this.isGuest((Player)(entity = (Player)entity2))) {
            entityDamageByEntityEvent.setCancelled(true);
            return;
        }
        entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Projectile && (entity = (player = (Projectile)entity).getShooter()) instanceof Player && this.isGuest((Player)(entity2 = (Player)entity))) {
            entityDamageByEntityEvent.setCancelled(true);
            return;
        }
    }

    private Location resolveOverlapsForMove(Player player, Location location, Location location2, Collection<Entity> collection) {
        double d = location2.getX() - location.getX();
        double d2 = location2.getY() - location.getY();
        double d3 = location2.getZ() - location.getZ();
        BoundingBox boundingBox = player.getBoundingBox().shift(d, d2, d3).expand(0.06);
        Location location3 = location2.clone();
        for (int i = 0; i < 3; ++i) {
            Entity entity = null;
            Vector vector = null;
            double d4 = 0.0;
            for (Entity entity2 : collection) {
                Vector vector2;
                double d5;
                BoundingBox boundingBox2;
                if (entity2 == player || !boundingBox.overlaps(boundingBox2 = entity2.getBoundingBox().expand(0.06)) || !((d5 = Math.abs((vector2 = GuestModePlugin.mtdHorizontal(boundingBox, boundingBox2, 0.04)).getX()) + Math.abs(vector2.getZ())) > d4)) continue;
                d4 = d5;
                vector = vector2;
                entity = entity2;
            }
            if (entity == null || vector == null) break;
            location3.add(vector.getX(), 0.0, vector.getZ());
            boundingBox = boundingBox.shift(vector.getX(), 0.0, vector.getZ());
        }
        return location3;
    }

    private static Vector mtdHorizontal(BoundingBox boundingBox, BoundingBox boundingBox2, double d) {
        double d2;
        double d3 = boundingBox2.getMaxX() - boundingBox.getMinX() + d;
        double d4 = -(boundingBox.getMaxX() - boundingBox2.getMinX() + d);
        double d5 = boundingBox2.getMaxZ() - boundingBox.getMinZ() + d;
        double d6 = -(boundingBox.getMaxZ() - boundingBox2.getMinZ() + d);
        double d7 = (boundingBox.getMinX() + boundingBox.getMaxX()) * 0.5;
        double d8 = (boundingBox2.getMinX() + boundingBox2.getMaxX()) * 0.5;
        double d9 = (boundingBox.getMinZ() + boundingBox.getMaxZ()) * 0.5;
        double d10 = (boundingBox2.getMinZ() + boundingBox2.getMaxZ()) * 0.5;
        double d11 = d7 < d8 ? d4 : d3;
        double d12 = d2 = d9 < d10 ? d6 : d5;
        if (Math.abs(d11) <= Math.abs(d2)) {
            return new Vector(d11, 0.0, 0.0);
        }
        return new Vector(0.0, 0.0, d2);
    }

    @EventHandler
    public void onProjectileLaunch(ProjectileLaunchEvent projectileLaunchEvent) {
        Player player;
        ProjectileSource projectileSource = projectileLaunchEvent.getEntity().getShooter();
        if (projectileSource instanceof Player && this.isGuest(player = (Player)projectileSource)) {
            projectileLaunchEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onSplash(PotionSplashEvent potionSplashEvent) {
        Player player;
        ProjectileSource projectileSource = potionSplashEvent.getPotion().getShooter();
        if (projectileSource instanceof Player && this.isGuest(player = (Player)projectileSource)) {
            potionSplashEvent.getAffectedEntities().forEach(livingEntity -> potionSplashEvent.setIntensity(livingEntity, 0.0));
        }
    }

    @EventHandler
    public void onAreaCloud(AreaEffectCloudApplyEvent areaEffectCloudApplyEvent) {
        Player player;
        ProjectileSource projectileSource = areaEffectCloudApplyEvent.getEntity().getSource();
        if (projectileSource instanceof Player && this.isGuest(player = (Player)projectileSource)) {
            areaEffectCloudApplyEvent.getAffectedEntities().clear();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPetTeleport(EntityTeleportEvent entityTeleportEvent) {
        Player player;
        Tameable tameable;
        AnimalTamer animalTamer;
        Entity entity = entityTeleportEvent.getEntity();
        if (entity instanceof Tameable && (animalTamer = (tameable = (Tameable)entity).getOwner()) instanceof Player && this.isGuest(player = (Player)animalTamer)) {
            entityTeleportEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onTame(EntityTameEvent entityTameEvent) {
        Player player;
        AnimalTamer animalTamer = entityTameEvent.getOwner();
        if (animalTamer instanceof Player && this.isGuest(player = (Player)animalTamer)) {
            entityTameEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onBreed(EntityBreedEvent entityBreedEvent) {
        Player player;
        LivingEntity livingEntity = entityBreedEvent.getBreeder();
        if (livingEntity instanceof Player && this.isGuest(player = (Player)livingEntity)) {
            entityBreedEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onLeash(PlayerLeashEntityEvent playerLeashEntityEvent) {
        if (this.isGuest(playerLeashEntityEvent.getPlayer())) {
            playerLeashEntityEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onUnleash(PlayerUnleashEntityEvent playerUnleashEntityEvent) {
        if (this.isGuest(playerUnleashEntityEvent.getPlayer())) {
            playerUnleashEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPhantomSpawn(CreatureSpawnEvent creatureSpawnEvent) {
        LivingEntity livingEntity = creatureSpawnEvent.getEntity();
        if (livingEntity instanceof Phantom) {
            Phantom phantom = (Phantom)livingEntity;
            if (creatureSpawnEvent.getSpawnReason() == CreatureSpawnEvent.SpawnReason.NATURAL) {
                phantom.getScheduler().run((Plugin)this, scheduledTask -> {
                    Player player;
                    LivingEntity livingEntity = phantom.getTarget();
                    if (livingEntity instanceof Player && this.isGuest(player = (Player)livingEntity)) {
                        phantom.remove();
                    }
                }, null);
            }
        }
    }

    @EventHandler
    public void onPortal(PlayerPortalEvent playerPortalEvent) {
        if (this.isGuest(playerPortalEvent.getPlayer())) {
            playerPortalEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityPortal(EntityPortalEvent entityPortalEvent) {
        Player player;
        Entity entity = entityPortalEvent.getEntity();
        if (entity instanceof Player && this.isGuest(player = (Player)entity)) {
            entityPortalEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent playerTeleportEvent) {
        if (!this.isGuest(playerTeleportEvent.getPlayer())) {
            return;
        }
        PlayerTeleportEvent.TeleportCause teleportCause = playerTeleportEvent.getCause();
        if (teleportCause == PlayerTeleportEvent.TeleportCause.ENDER_PEARL || teleportCause == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL || teleportCause == PlayerTeleportEvent.TeleportCause.END_PORTAL || "CHORUS_FRUIT".equals(teleportCause.name())) {
            playerTeleportEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onIgnite(BlockIgniteEvent blockIgniteEvent) {
        Player player;
        Entity entity = blockIgniteEvent.getIgnitingEntity();
        if (entity instanceof Player && this.isGuest(player = (Player)entity)) {
            blockIgniteEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onExplosionPrime(ExplosionPrimeEvent explosionPrimeEvent) {
        Player player;
        TNTPrimed tNTPrimed;
        Entity entity;
        Entity entity2 = explosionPrimeEvent.getEntity();
        Player player2 = null;
        if (entity2 instanceof TNTPrimed && (entity = (tNTPrimed = (TNTPrimed)entity2).getSource()) instanceof Player) {
            player2 = player = (Player)entity;
        }
        if (entity2 instanceof Fireball && (entity = (tNTPrimed = (Fireball)entity2).getShooter()) instanceof Player) {
            player2 = player = (Player)entity;
        }
        if (entity2 instanceof WitherSkull && (entity = (tNTPrimed = (WitherSkull)entity2).getShooter()) instanceof Player) {
            player2 = player = (Player)entity;
        }
        if (player2 != null && this.isGuest(player2)) {
            explosionPrimeEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onAdvancement(PlayerAdvancementDoneEvent playerAdvancementDoneEvent) {
        Player player = playerAdvancementDoneEvent.getPlayer();
        if (!this.isGuest(player)) {
            return;
        }
        Advancement advancement = playerAdvancementDoneEvent.getAdvancement();
        for (String string : player.getAdvancementProgress(advancement).getAwardedCriteria()) {
            player.getAdvancementProgress(advancement).revokeCriteria(string);
        }
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        boolean bl;
        if (!command.getName().equalsIgnoreCase("guest")) {
            return false;
        }
        boolean bl2 = bl = !(commandSender instanceof Player) || ((Player)commandSender).isOp() || ((Player)commandSender).hasPermission("guestmode.use");
        if (!bl) {
            commandSender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return true;
        }
        if (stringArray.length == 0) {
            commandSender.sendMessage("\u00a77Usage: \u00a7f/guest <player>\u00a77 | \u00a7f/guest reload\u00a77 | \u00a7f/guest all [except]\u00a77 | \u00a7f/guest status");
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("reload")) {
            this.reloadLists();
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.applyMode(player);
            }
            commandSender.sendMessage("\u00a7aConfig reloaded.");
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("status")) {
            if (this.allGuests) {
                commandSender.sendMessage("\u00a77Mode: \u00a7a[all] in guests \u00a77\u2192 everyone is a guest except 'except'");
            } else if (this.allExcept) {
                commandSender.sendMessage("\u00a77Mode: \u00a7a[all] in except \u00a77\u2192 everyone is normal except explicit 'guests'");
            } else {
                commandSender.sendMessage("\u00a77Mode: \u00a7eindividual (only players listed in 'guests')");
            }
            commandSender.sendMessage("\u00a77Guests (without [all]): \u00a7f" + this.guests.size() + " \u00a77Except (without [all]): \u00a7f" + this.except.size());
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("all")) {
            if (stringArray.length > 1 && stringArray[1].equalsIgnoreCase("except")) {
                boolean bl3 = this.allExcept = !this.allExcept;
                if (this.allExcept) {
                    this.allGuests = false;
                    commandSender.sendMessage("\u00a7a[all] enabled in 'except' (everyone normal, only explicit 'guests' are guests).");
                } else {
                    commandSender.sendMessage("\u00a7e[all] disabled in 'except'.");
                }
            } else {
                boolean bl4 = this.allGuests = !this.allGuests;
                if (this.allGuests) {
                    this.allExcept = false;
                    commandSender.sendMessage("\u00a7a[all] enabled in 'guests' (everyone is a guest except 'except').");
                } else {
                    commandSender.sendMessage("\u00a7e[all] disabled in 'guests'.");
                }
            }
            this.saveLists();
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.applyMode(player);
            }
            return true;
        }
        String string2 = stringArray[0];
        Player player = Bukkit.getPlayerExact((String)string2);
        if (this.allExcept) {
            if (this.guests.contains(string2)) {
                this.guests.remove(string2);
            } else {
                this.guests.add(string2);
            }
        } else if (this.allGuests) {
            if (this.except.contains(string2)) {
                this.except.remove(string2);
            } else {
                this.except.add(string2);
            }
        } else if (this.guests.contains(string2)) {
            this.guests.remove(string2);
        } else {
            this.guests.add(string2);
        }
        this.saveLists();
        if (player != null) {
            this.applyMode(player);
        }
        commandSender.sendMessage("\u00a77Updated mode for \u00a7f" + string2 + "\u00a77.");
        return true;
    }
}

