/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.enchantments_plus.enchantments.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.kapitencraft.kap_lib.cooldown.Cooldown;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record ActivateCooldown(Cooldown cooldown, boolean reduceWithTime) implements EnchantmentEntityEffect
{
    public static final MapCodec<ActivateCooldown> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ExtraRegistries.COOLDOWNS.byNameCodec().fieldOf("cooldown").forGetter(ActivateCooldown::cooldown), (App)Codec.BOOL.fieldOf("reduceWithTime").forGetter(ActivateCooldown::reduceWithTime)).apply((Applicative)i, ActivateCooldown::new));

    public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse item, Entity entity, Vec3 origin) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.cooldown.applyCooldown(living, this.reduceWithTime);
        }
    }

    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

