/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.enchantments_plus.enchantments.components;

import com.mojang.serialization.MapCodec;
import net.kapitencraft.enchantments_plus.data_gen.ModDamageTypes;
import net.kapitencraft.enchantments_plus.data_gen.ModEnchantments;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleAnimation;
import net.kapitencraft.kap_lib.client.particle.animation.finalizers.EmptyFinalizer;
import net.kapitencraft.kap_lib.client.particle.animation.finalizers.ParticleFinalizer;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.RingSpawner;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.Spawner;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.EntityRemovedTerminatorTrigger;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.TimedTerminator;
import net.kapitencraft.kap_lib.enchantments.abstracts.EnchantmentCountEffect;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.registry.ExtraMobEffects;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class Inferno
implements EnchantmentCountEffect {
    public static final MapCodec<Inferno> CODEC = MapCodec.unit(Inferno::new);

    public EnchantmentCountEffect.CountType countType() {
        return EnchantmentCountEffect.CountType.NORMAL;
    }

    public int getCountAmount(int level) {
        return 10;
    }

    public float mainExecute(int level, ItemStack enchanted, LivingEntity attacker, LivingEntity attacked, float damageAmount, int curTick, DamageSource source, float attackDamageScale) {
        if (attackDamageScale == 1.0f && !source.getMsgId().equals("inferno")) {
            Level world = attacker.level();
            world.getProfiler().push("inferno enchantment");
            int extinguishLevel = EnchantmentHelper.getEnchantmentLevel((Holder)world.registryAccess().holderOrThrow(ModEnchantments.EXTINGUISH), (LivingEntity)attacked);
            if (attacked.level() instanceof ServerLevel) {
                ParticleAnimation.builder().spawnTime(ParticleAnimation.SpawnTime.absolute((int)1)).spawn((Spawner.Builder)((RingSpawner.Builder)RingSpawner.entityWithBBSize((Entity)attacked, (float)1.5f, (float)1.2f).setParticle((ParticleOptions)ParticleTypes.DRIPPING_LAVA)).heightPerTick(0.02f).rotPerTick(3.0f)).terminatedWhen(TimedTerminator.seconds((int)5)).terminatedWhen(EntityRemovedTerminatorTrigger.create((Entity)attacked)).finalizes((ParticleFinalizer.Builder)EmptyFinalizer.builder()).sendToAllPlayers();
            }
            int extinguishDamageReduction = extinguishLevel == 0 ? 0 : 50 + extinguishLevel * 15;
            this.attack(attacked, attacker, 0, damageAmount * (float)(100 + level * 25 - extinguishDamageReduction) / 100.0f);
            MiscHelper.maxEffectDuration((LivingEntity)attacked, (Holder)ExtraMobEffects.STUN, (int)100);
            world.getProfiler().pop();
        }
        return damageAmount;
    }

    private void attack(LivingEntity attacked, LivingEntity attacker, int tick, float damage) {
        MiscHelper.schedule((int)20, () -> {
            attacked.hurt(attacked.damageSources().source(ModDamageTypes.INFERNO, (Entity)attacker), damage);
            if (tick < 5) {
                this.attack(attacked, attacker, tick + 1, damage);
            }
        });
    }

    public MapCodec<? extends EnchantmentCountEffect> codec() {
        return CODEC;
    }
}

