/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.enchantments_plus.enchantments.components;

import com.mojang.serialization.MapCodec;
import net.kapitencraft.kap_lib.enchantments.abstracts.EnchantmentCountEffect;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LightningLord
implements EnchantmentCountEffect {
    public static final MapCodec<LightningLord> CODEC = MapCodec.unit(LightningLord::new);

    public EnchantmentCountEffect.CountType countType() {
        return EnchantmentCountEffect.CountType.NORMAL;
    }

    public int getCountAmount(int level) {
        return (int)(3.0 + (double)level * 0.4);
    }

    public float mainExecute(int level, ItemStack enchanted, LivingEntity attacker, LivingEntity attacked, float damageAmount, int curHit, DamageSource source, float attackStrenghtScale) {
        Level level2;
        if (attackStrenghtScale == 1.0f && (level2 = attacker.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)serverLevel);
            assert (lightning != null);
            lightning.moveTo(Vec3.atBottomCenterOf((Vec3i)attacked.getOnPos()));
            lightning.setVisualOnly(true);
            serverLevel.addFreshEntity((Entity)lightning);
            damageAmount *= 1.0f + (float)level * 0.1f;
        }
        return damageAmount;
    }

    public MapCodec<? extends EnchantmentCountEffect> codec() {
        return CODEC;
    }
}

