/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.enchantments_plus.loot_table.modifier;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.kapitencraft.enchantments_plus.data_gen.ModEnchantments;
import net.kapitencraft.kap_lib.helpers.LootTableHelper;
import net.kapitencraft.kap_lib.item.Compacting;
import net.kapitencraft.kap_lib.item.loot_table.IConditional;
import net.kapitencraft.kap_lib.item.loot_table.modifiers.ModLootModifier;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.NotNull;

public class CompactModifier
extends ModLootModifier
implements IConditional {
    public static final MapCodec<CompactModifier> CODEC = LootTableHelper.simpleCodec(CompactModifier::new);

    public CompactModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        LivingEntity living = LootTableHelper.getLivingSource((LootContext)context);
        if (living != null && EnchantmentHelper.getEnchantmentLevel((Holder)living.registryAccess().holderOrThrow(ModEnchantments.COMPACTING), (LivingEntity)living) > 0) {
            context.getLevel().getProfiler().push("compact modifier");
            for (int i = 0; i < generatedLoot.size(); ++i) {
                ItemStack stack = (ItemStack)generatedLoot.get(i);
                Compacting.Result compactResult = Compacting.tryCompact((Item)stack.getItem(), (ServerLevel)context.getLevel());
                if (compactResult != Compacting.Result.EMPTY) {
                    int amount = compactResult.getCountReq();
                    ItemStack result = compactResult.result();
                    int resultSize = 0;
                    while (stack.getCount() >= amount) {
                        stack.shrink(amount);
                        resultSize += result.getCount();
                    }
                    if (resultSize > 0) {
                        ItemStack outputResult = result.copyWithCount(resultSize);
                        if (stack.isEmpty()) {
                            generatedLoot.remove((Object)stack);
                        }
                        boolean handled = false;
                        for (ItemStack s : generatedLoot) {
                            if (!ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)outputResult)) continue;
                            handled = true;
                            s.grow(outputResult.getCount());
                        }
                        if (!handled) {
                            generatedLoot.add((Object)outputResult);
                        }
                    }
                }
                context.getLevel().getProfiler().pop();
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

