/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.enchantments_plus.mixin.classes;

import java.util.List;
import net.kapitencraft.enchantments_plus.data_gen.ModEnchantments;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={BowItem.class})
public abstract class BowItemMixin
extends ProjectileWeaponItem {
    public BowItemMixin(Item.Properties properties) {
        super(properties);
    }

    @Redirect(method={"releaseUsing"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/BowItem;shoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/item/ItemStack;Ljava/util/List;FFZLnet/minecraft/world/entity/LivingEntity;)V"))
    private void addPrecision(BowItem instance, ServerLevel serverLevel, LivingEntity living, InteractionHand hand, ItemStack stack, List<ItemStack> list, float velocity, float inaccuracy, boolean isCrit, LivingEntity target) {
        int precision = stack.getEnchantmentLevel(living.registryAccess().holderOrThrow(ModEnchantments.PRECISION));
        this.shoot(serverLevel, living, hand, stack, list, velocity, inaccuracy - (float)precision * 0.15f, isCrit, target);
    }
}

