/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.enchantments_plus.mixin.classes;

import net.kapitencraft.enchantments_plus.data_gen.ModEnchantments;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={LightTexture.class})
public class LightTextureMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Redirect(method={"calculateDarknessScale"}, at=@At(value="INVOKE", target="Ljava/lang/Math;max(FF)F"))
    private float reduceDarkness(float a, float b, LivingEntity pLiving) {
        int enlightenmentLevel = LightTextureMixin.getEnlightenmentLevel(pLiving);
        return Math.max(a, b - (float)enlightenmentLevel * 0.2f);
    }

    @Unique
    private static int getEnlightenmentLevel(LivingEntity living) {
        return EnchantmentHelper.getEnchantmentLevel((Holder)living.registryAccess().holderOrThrow(ModEnchantments.ENLIGHTENMENT), (LivingEntity)living);
    }

    @ModifyVariable(method={"updateLightTexture"}, at=@At(value="LOAD"), ordinal=7)
    private float increaseNightVision(float value) {
        int enlightenmentLevel = LightTextureMixin.getEnlightenmentLevel((LivingEntity)this.minecraft.player);
        return value + (float)enlightenmentLevel * 0.2f;
    }
}

