/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.enchantments_plus.data_gen;

import net.kapitencraft.enchantments_plus.EnchantmentsPlusMod;
import net.kapitencraft.enchantments_plus.registry.ModBlocks;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    private static final ResourceLocation BASALT_SIDE = ResourceLocation.withDefaultNamespace((String)"block/basalt_side");
    private static final ResourceLocation BASALT_TOP = ResourceLocation.withDefaultNamespace((String)"block/basalt_top");

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "enchantments_plus", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.getVariantBuilder((Block)ModBlocks.FRAGILE_BASALT.get()).forAllStates(state -> {
            int level = (Integer)state.getValue((Property)BlockStateProperties.AGE_3);
            return ConfiguredModel.builder().modelFile(this.createFragileBasaltModel(level)).build();
        });
    }

    private ModelFile createFragileBasaltModel(int age) {
        return this.models().cubeColumn("fragile_basalt_" + age, age == 0 ? BASALT_SIDE : EnchantmentsPlusMod.res("block/fragile_basalt_side_" + age), age == 0 ? BASALT_TOP : EnchantmentsPlusMod.res("block/fragile_basalt_top_" + age));
    }
}

