/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.enchantments_plus.enchantments.components;

import com.mojang.serialization.MapCodec;
import java.util.Comparator;
import net.kapitencraft.kap_lib.enchantments.abstracts.EnchantmentBowEffect;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;

public class Aim
implements EnchantmentBowEffect {
    public static final MapCodec<Aim> CODEC = MapCodec.unit(Aim::new);

    public void write(CompoundTag compoundTag, int i, ItemStack itemStack, LivingEntity livingEntity, AbstractArrow abstractArrow) {
    }

    public void execute(int level, @Nullable LivingEntity target, CompoundTag tag, EnchantmentBowEffect.ExePhase type, MutableFloat oldDamage, AbstractArrow arrow) {
        if (!arrow.onGround() && type == EnchantmentBowEffect.ExePhase.TICK && !arrow.getDeltaMovement().equals((Object)Vec3.ZERO)) {
            MathHelper.getLivingAround((Entity)arrow, (double)(level * 2)).stream().filter(living -> arrow.getOwner() != living && !living.isDeadOrDying()).sorted(Comparator.comparingDouble(value -> value.distanceTo((Entity)arrow))).findAny().ifPresent(living -> {
                Vec2 rotation = MathHelper.createTargetRotationFromPos((Vec3)arrow.position(), (Vec3)living.getEyePosition());
                Vec3 delta = arrow.getDeltaMovement();
                arrow.setXRot(rotation.x);
                arrow.setYRot(rotation.y);
                arrow.setDeltaMovement(living.position().subtract(arrow.position()).normalize().scale(delta.length()));
                arrow.hurtMarked = true;
            });
        }
    }

    public boolean shouldTick() {
        return true;
    }

    public MapCodec<? extends EnchantmentBowEffect> codec() {
        return CODEC;
    }
}

