/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.enchantments_plus.enchantments.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.kapitencraft.kap_lib.util.attribute.TimedModifierUtils;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record ApplyTimedModifier(ResourceLocation location, LevelBasedValue duration, Holder<Attribute> attribute, LevelBasedValue amount, AttributeModifier.Operation operation) implements EnchantmentEntityEffect
{
    public static final MapCodec<ApplyTimedModifier> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ResourceLocation.CODEC.fieldOf("location").forGetter(ApplyTimedModifier::location), (App)LevelBasedValue.CODEC.fieldOf("duration").forGetter(ApplyTimedModifier::duration), (App)Attribute.CODEC.fieldOf("attribute").forGetter(ApplyTimedModifier::attribute), (App)LevelBasedValue.CODEC.fieldOf("amount").forGetter(ApplyTimedModifier::amount), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(ApplyTimedModifier::operation)).apply((Applicative)i, ApplyTimedModifier::new));

    public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse item, Entity entity, Vec3 origin) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            TimedModifierUtils.add((LivingEntity)living, (ResourceLocation)this.location, (int)((int)this.duration.calculate(enchantmentLevel)), this.attribute, (double)this.amount.calculate(enchantmentLevel), (AttributeModifier.Operation)this.operation);
        }
    }

    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

