/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.enchantments_plus.event;

import java.util.ArrayList;
import java.util.List;
import net.kapitencraft.enchantments_plus.data_gen.ModDamageTypes;
import net.kapitencraft.enchantments_plus.data_gen.ModEnchantments;
import net.kapitencraft.enchantments_plus.registry.ModEnchantmentEffectComponents;
import net.kapitencraft.enchantments_plus.util.VeinMinerHolder;
import net.kapitencraft.kap_lib.client.particle.LightningParticleOptions;
import net.kapitencraft.kap_lib.event.custom.ModifyFishingHookStatsEvent;
import net.kapitencraft.kap_lib.helpers.EnchantmentHelperExtras;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.util.Reference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.EnderManAngerEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.PlayerSpawnPhantomsEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber
public class EventHandler {
    @SubscribeEvent
    public static void endermanEvent(EnderManAngerEvent event) {
        Player player = event.getPlayer();
        if (EnchantmentHelper.has((ItemStack)player.getItemBySlot(EquipmentSlot.HEAD), (DataComponentType)((DataComponentType)ModEnchantmentEffectComponents.ENDER_FRIEND.get()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void blockBreakRegister(BlockEvent.BreakEvent event) {
        ServerLevel serverLevel1;
        ServerLevel serverLevel;
        Player player = event.getPlayer();
        ItemStack mainHandItem = player.getMainHandItem();
        BlockState state = event.getState();
        Block block = state.getBlock();
        Level level = player.level();
        BlockPos pos = event.getPos();
        ServerLevel serverLevel2 = serverLevel = level instanceof ServerLevel ? (serverLevel1 = (ServerLevel)level) : null;
        if (serverLevel == null) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (EnchantmentHelper.has((ItemStack)mainHandItem, (DataComponentType)((DataComponentType)ModEnchantmentEffectComponents.MAGMATIC.get())) && state.is(Blocks.NETHERRACK)) {
            event.setCanceled(true);
            level.setBlockAndUpdate(pos, Blocks.LAVA.defaultBlockState());
            return;
        }
        if (block instanceof CropBlock || block instanceof NetherWartBlock) {
            IntegerProperty ageProperty;
            int max;
            if (block instanceof CropBlock) {
                CropBlock cropBlock = (CropBlock)block;
                v1 = cropBlock.getMaxAge();
            } else {
                v1 = max = 3;
            }
            if (block instanceof CropBlock) {
                CropBlock cropBlock = (CropBlock)block;
                v2 = cropBlock.getAgeProperty();
            } else {
                v2 = ageProperty = BlockStateProperties.AGE_3;
            }
            if ((Integer)state.getValue((Property)ageProperty) < max && EnchantmentHelper.has((ItemStack)mainHandItem, (DataComponentType)((DataComponentType)ModEnchantmentEffectComponents.DELICATE.get()))) {
                event.setCanceled(true);
                return;
            }
            if (EnchantmentHelper.has((ItemStack)mainHandItem, (DataComponentType)((DataComponentType)ModEnchantmentEffectComponents.REPLENISH.get()))) {
                event.setCanceled(true);
                Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
                mainHandItem.mineBlock(level, state, pos, player);
                state = (BlockState)state.setValue((Property)ageProperty, (Comparable)Integer.valueOf(0));
                level.setBlockAndUpdate(pos, state);
            }
        }
        if (EnchantmentHelper.has((ItemStack)mainHandItem, (DataComponentType)((DataComponentType)ModEnchantmentEffectComponents.LUMBERJACK.get())) && state.is(BlockTags.LOGS)) {
            VeinMinerHolder.create(pos, serverPlayer, block, pos1 -> {}, state1 -> true, pos1 -> false);
        }
        if (state.is(BlockTags.MINEABLE_WITH_PICKAXE) || state.is(BlockTags.MINEABLE_WITH_SHOVEL)) {
            EnchantmentHelperExtras.getEnchantmentLevelAndDo((RegistryAccess)level.registryAccess(), (ItemStack)mainHandItem, ModEnchantments.VEIN_MINER, integer -> {
                Reference brokenBlocks = Reference.of((Object)-1);
                VeinMinerHolder.create(pos, serverPlayer, block, pos1 -> MathHelper.up1((Reference)brokenBlocks), state1 -> true, pos1 -> brokenBlocks.getIntValue() > integer);
            });
        }
    }

    @SubscribeEvent
    public static void onLivingDamagePre(LivingDamageEvent.Pre event) {
        DamageSource source = event.getSource();
        LivingEntity attacked = event.getEntity();
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            EnchantmentHelperExtras.getEnchantmentLevelAndDo((LivingEntity)attacker, ModEnchantments.GIANT_KILLER, i -> {
                double moreHpPercent = attacked.getHealth() / attacker.getHealth();
                event.setNewDamage((float)((double)event.getNewDamage() * (1.0 + Math.min(moreHpPercent * (double)i.intValue() * 0.01, 0.5))));
            });
            EnchantmentHelperExtras.getEnchantmentLevelAndDo((LivingEntity)attacker, ModEnchantments.COMBAT_KNOWLEDGE, level -> {
                if (source.getDirectEntity() == attacker && MathHelper.chance((double)0.001, (LivingEntity)attacker)) {
                    event.setNewDamage(Float.MAX_VALUE);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onBlockDrops(BlockDropsEvent event) {
        Entity entity = event.getBreaker();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack mainHandItem = event.getTool();
            RegistryAccess access = player.registryAccess();
            if (event.getDroppedExperience() > 0) {
                EnchantmentHelperExtras.getEnchantmentLevelAndDo((RegistryAccess)access, (ItemStack)mainHandItem, ModEnchantments.EXPERIENCED, enchLevel -> MathHelper.add(() -> ((BlockDropsEvent)event).getDroppedExperience(), arg_0 -> ((BlockDropsEvent)event).setDroppedExperience(arg_0), (int)enchLevel));
            }
            if (EnchantmentHelper.has((ItemStack)mainHandItem, (DataComponentType)((DataComponentType)ModEnchantmentEffectComponents.TELEKINESIS.get()))) {
                EventHandler.addXp(player, event.getDroppedExperience());
                event.setDroppedExperience(0);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamagePost(LivingDamageEvent.Post event) {
        LivingEntity living;
        Entity entity;
        LivingEntity attacked = event.getEntity();
        DamageSource source = event.getSource();
        LivingEntity livingEntity = source.isDirect() ? ((entity = source.getDirectEntity()) instanceof LivingEntity ? (living = (LivingEntity)entity) : null) : null;
        LivingEntity attacker = livingEntity;
        float damage = event.getOriginalDamage();
        if (attacker != null && !attacker.level().isClientSide()) {
            ServerLevel level = (ServerLevel)attacker.level();
            int enchantmentLevel = EnchantmentHelper.getEnchantmentLevel((Holder)level.registryAccess().holderOrThrow(ModEnchantments.CHAIN_LIGHTNING), (LivingEntity)attacker);
            ArrayList<LivingEntity> previous = new ArrayList<LivingEntity>();
            if (level.getRandom().nextFloat() < (float)enchantmentLevel * 0.02f) {
                LivingEntity target;
                for (int i = 0; i < enchantmentLevel && (target = EventHandler.selectTarget(enchantmentLevel, (Level)level, attacked, attacker, previous)) != null; ++i) {
                    previous.add(target);
                    target.hurt(attacked.damageSources().source(ModDamageTypes.CHAIN_LIGHTNING, (Entity)attacker), (float)enchantmentLevel * 0.05f * damage);
                    level.sendParticles((ParticleOptions)new LightningParticleOptions(attacked.getEyePosition(), target.getEyePosition(), 5, 100, 0.4f, 0.2f), target.getX(), target.getY(), target.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                    attacked = target;
                }
            }
        }
    }

    private static LivingEntity selectTarget(int enchLevel, Level level, LivingEntity origin, LivingEntity attacker, List<LivingEntity> previous) {
        List livings = level.getEntitiesOfClass(LivingEntity.class, origin.getBoundingBox().inflate((double)(enchLevel * 2)), living1 -> {
            if (living1 == attacker || previous.contains(living1)) {
                return false;
            }
            BlockHitResult result = living1.level().clip(new ClipContext(origin.getEyePosition(), living1.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.WATER, (Entity)attacker));
            return result.getType() == HitResult.Type.MISS;
        });
        return (LivingEntity)MathHelper.pickRandom((List)livings, (RandomSource)origin.getRandom());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void telekinesisXpRegister(LivingExperienceDropEvent event) {
        ItemStack mainHand;
        Player attacker = event.getAttackingPlayer();
        if (attacker != null && EnchantmentHelper.has((ItemStack)(mainHand = attacker.getMainHandItem()), (DataComponentType)((DataComponentType)ModEnchantmentEffectComponents.TELEKINESIS.get()))) {
            EventHandler.addXp(attacker, event.getDroppedExperience());
            event.setCanceled(true);
        }
    }

    private static void addXp(Player player, int amount) {
        player.giveExperiencePoints(EnchantmentHelperExtras.repairPlayerItems((Player)player, (int)amount, (DataComponentType)EnchantmentEffectComponents.REPAIR_WITH_XP));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void tickVeinMiner(ServerTickEvent.Post event) {
        VeinMinerHolder.tickAll();
    }

    @SubscribeEvent
    public static void onModifyFishingHookStats(ModifyFishingHookStatsEvent event) {
        event.hookSpeed.addAddition(event.fishingRod.getEnchantmentLevel(event.player.registryAccess().holderOrThrow(ModEnchantments.FLASH)));
    }

    @SubscribeEvent
    public static void healthRegenRegister(LivingHealEvent event) {
        LivingEntity living = event.getEntity();
        if (living instanceof Player) {
            Player player = (Player)living;
            float amount = event.getAmount();
            amount = (float)EnchantmentHelperExtras.repairPlayerItems((Player)player, (int)((int)amount), (DataComponentType)((DataComponentType)ModEnchantmentEffectComponents.REPAIR_WITH_HEALTH.get())) + amount % 1.0f;
            event.setAmount(amount);
        }
    }

    @SubscribeEvent
    public static void itemUseEvents(LivingEntityUseItemEvent event) {
        if (event.getItem().getFoodProperties(event.getEntity()) != null) {
            EnchantmentHelperExtras.getEnchantmentLevelAndDo((LivingEntity)event.getEntity(), ModEnchantments.GLUTTONOUS, i -> event.setDuration((int)((double)event.getDuration() * (1.0 - (double)i.intValue() * 0.1))));
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity entity;
        DamageSource source = event.getSource();
        if (source.isDirect() && (entity = source.getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            EnchantmentHelperExtras.getEnchantmentLevelAndDo((LivingEntity)living, ModEnchantments.BLOOD_THIRST, integer -> {
                AttributeInstance attack = living.getAttribute(Attributes.ATTACK_DAMAGE);
                if (attack != null) {
                    // empty if block
                }
            });
        }
    }

    @SubscribeEvent
    public static void onMobEffectAdded(MobEffectEvent.Added event) {
        if (!((MobEffect)event.getEffectInstance().getEffect().value()).isBeneficial()) {
            EnchantmentHelperExtras.getEnchantmentLevelAndDo((LivingEntity)event.getEntity(), ModEnchantments.RESILIENCE, integer -> {
                MobEffectInstance instance = event.getEffectInstance();
                instance.duration = instance.mapDuration(i -> (int)((double)i * (1.0 - (double)integer.intValue() * 0.2)));
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerSpawnPhantoms(PlayerSpawnPhantomsEvent event) {
        EnchantmentHelperExtras.getEnchantmentLevelAndDo((LivingEntity)event.getEntity(), ModEnchantments.SLEEPY, i -> event.setResult(PlayerSpawnPhantomsEvent.Result.DENY));
    }

    @SubscribeEvent
    public static void onPlayerSleepInBed(CanPlayerSleepEvent event) {
        EnchantmentHelperExtras.getEnchantmentLevelAndDo((LivingEntity)event.getEntity(), ModEnchantments.INSOMNIA, i -> event.setProblem(Player.BedSleepingProblem.NOT_SAFE));
    }
}

