/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.enchantments_plus.loot_table.modifier;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.kapitencraft.enchantments_plus.data_gen.ModEnchantments;
import net.kapitencraft.kap_lib.helpers.LootTableHelper;
import net.kapitencraft.kap_lib.item.loot_table.IConditional;
import net.kapitencraft.kap_lib.item.loot_table.modifiers.ModLootModifier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.NotNull;

public class ChromaticModifier
extends ModLootModifier
implements IConditional {
    public static final MapCodec<ChromaticModifier> CODEC = LootTableHelper.simpleCodec(ChromaticModifier::new);

    public ChromaticModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> items, LootContext lootContext) {
        int level;
        LivingEntity living = LootTableHelper.getLivingSource((LootContext)lootContext);
        if (living != null && (level = EnchantmentHelper.getEnchantmentLevel((Holder)living.registryAccess().holderOrThrow(ModEnchantments.CHROMATIC), (LivingEntity)living)) > 0) {
            for (int i = 0; i < items.size(); ++i) {
                Optional wool;
                if (!((ItemStack)items.get(i)).is(ItemTags.WOOL) || !(wool = BuiltInRegistries.ITEM.getRandomElementOf(ItemTags.WOOL, lootContext.getRandom())).isPresent()) continue;
                items.set(i, (Object)new ItemStack((ItemLike)((Holder)wool.get()).value(), ((ItemStack)items.get(i)).getCount()));
            }
        }
        return items;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

