/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.enchantments_plus.loot_table.modifier;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.kapitencraft.enchantments_plus.data_gen.ModEnchantments;
import net.kapitencraft.kap_lib.helpers.LootTableHelper;
import net.kapitencraft.kap_lib.item.loot_table.IConditional;
import net.kapitencraft.kap_lib.item.loot_table.modifiers.ModLootModifier;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.NotNull;

public class SmeltModifier
extends ModLootModifier
implements IConditional {
    public static final MapCodec<SmeltModifier> CODEC = LootTableHelper.simpleCodec(SmeltModifier::new);
    private LootContext context = null;

    public SmeltModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        LivingEntity source = LootTableHelper.getLivingSource((LootContext)context);
        if (source != null && source.getMainHandItem().getEnchantmentLevel(source.registryAccess().holderOrThrow(ModEnchantments.SMELTING_TOUCH)) > 0) {
            context.getLevel().getProfiler().push("smelt modifier");
            this.context = context;
            generatedLoot = new ObjectArrayList(generatedLoot.stream().map(this::run).toList());
            this.context = null;
            context.getLevel().getProfiler().pop();
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    private ItemStack run(ItemStack unSmelt) {
        ItemStack itemstack;
        Optional optional;
        if (!unSmelt.isEmpty() && (optional = this.context.getLevel().getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(unSmelt), (Level)this.context.getLevel())).isPresent() && !(itemstack = ((SmeltingRecipe)((RecipeHolder)optional.get()).value()).getResultItem((HolderLookup.Provider)this.context.getLevel().registryAccess())).isEmpty()) {
            ItemStack itemstack1 = itemstack.copy();
            itemstack1.setCount(unSmelt.getCount() * itemstack.getCount());
            return itemstack1;
        }
        return unSmelt;
    }
}

