/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.enchantments_plus.loot_table.modifier;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.kapitencraft.enchantments_plus.registry.ModEnchantmentEffectComponents;
import net.kapitencraft.kap_lib.helpers.LootTableHelper;
import net.kapitencraft.kap_lib.item.loot_table.IConditional;
import net.kapitencraft.kap_lib.item.loot_table.modifiers.ModLootModifier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.NotNull;

public class TelekinesisModifier
extends ModLootModifier
implements IConditional {
    public static final MapCodec<TelekinesisModifier> CODEC = LootTableHelper.simpleCodec(TelekinesisModifier::new);

    public TelekinesisModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Player source = LootTableHelper.getPlayerSource((LootContext)context);
        if (source != null && EnchantmentHelper.has((ItemStack)source.getMainHandItem(), (DataComponentType)((DataComponentType)ModEnchantmentEffectComponents.TELEKINESIS.get()))) {
            context.getLevel().getProfiler().push("telekinesis modifier");
            Inventory inventory = source.getInventory();
            generatedLoot.removeIf(arg_0 -> ((Inventory)inventory).add(arg_0));
            context.getLevel().getProfiler().pop();
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

