/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.enchantments_plus.mixin.classes;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.CommonHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ShearsDispenseItemBehavior.class})
public abstract class ShearsDispenseItemBehaviourMixin
extends OptionalDispenseItemBehavior {
    @Shadow
    private static boolean tryShearBeehive(ServerLevel pLevel, BlockPos pPos) {
        return false;
    }

    @Shadow
    private static boolean tryShearLivingEntity(ServerLevel level, BlockPos pos, ItemStack stack) {
        return false;
    }

    @Overwrite
    protected ItemStack execute(BlockSource pSource, ItemStack pStack) {
        ServerLevel serverlevel = pSource.level();
        if (!serverlevel.isClientSide()) {
            BlockPos blockpos = pSource.pos().relative((Direction)pSource.state().getValue((Property)DispenserBlock.FACING));
            this.setSuccess(CommonHooks.tryDispenseShearsHarvestBlock((BlockSource)pSource, (ItemStack)pStack, (ServerLevel)serverlevel, (BlockPos)blockpos) || ShearsDispenseItemBehaviourMixin.tryShearBeehive(serverlevel, blockpos) || ShearsDispenseItemBehaviourMixin.tryShearLivingEntity(serverlevel, blockpos, pStack));
            if (this.isSuccess()) {
                pStack.hurtAndBreak(1, serverlevel, null, p_348118_ -> {});
                pStack.setCount(0);
            }
        }
        return pStack;
    }
}

