/*
 * Decompiled with CFR 0.152.
 */
package com.aztech.ez_stock_ticker.mixin;

import com.aztech.ez_stock_ticker.ClientConfig;
import com.aztech.ez_stock_ticker.CreateEasyStockTicker;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.AddressEditBox;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.stockTicker.CraftableBigItemStack;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestScreen;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.ScreenWithStencils;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StockKeeperRequestScreen.class}, remap=false)
public abstract class StockKeeperRequestScreenMixin
extends AbstractSimiContainerScreen<StockKeeperRequestMenu>
implements ScreenWithStencils {
    @Unique
    private static final ResourceLocation STOCK_KEEPER_PATCH = CreateEasyStockTicker.asResource("textures/gui/stock_keeper_patch.png");
    @Shadow
    public EditBox searchBox;
    @Shadow
    public boolean refreshSearchNextTick;
    @Shadow
    public boolean moveToTopNextTick;
    @Shadow
    public AddressEditBox addressBox;
    @Shadow
    private int itemsX;
    @Shadow
    @Final
    private int cols;
    @Shadow
    @Final
    private int colWidth;
    @Shadow
    private int windowHeight;
    @Shadow
    private boolean scrollHandleActive;
    @Shadow
    private boolean isAdmin;
    @Shadow
    public LerpedFloat itemScroll;
    @Shadow
    private int lockY;
    @Shadow
    private int lockX;
    @Shadow
    private boolean isLocked;
    @Shadow
    private StockTickerBlockEntity blockEntity;
    @Shadow
    private int itemsY;
    @Shadow
    public List<StockKeeperRequestScreen.CategoryEntry> categories;
    @Shadow
    public List<List<BigItemStack>> displayedItems;
    @Shadow
    @Final
    private int rowHeight;
    @Shadow
    private Set<Integer> hiddenCategories;
    @Shadow
    @Final
    private Couple<Integer> noneHovered;
    @Shadow
    public List<BigItemStack> itemsToOrder;
    @Shadow
    public List<CraftableBigItemStack> recipesToOrder;
    @Shadow
    @Final
    private static AllGuiTextures HEADER;
    @Shadow
    @Final
    private static AllGuiTextures BODY;
    @Shadow
    @Final
    private static AllGuiTextures FOOTER;

    public StockKeeperRequestScreenMixin(StockKeeperRequestMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    @Shadow
    protected abstract void syncJEI();

    @Shadow
    protected abstract Couple<Integer> getHoveredSlot(int var1, int var2);

    @Shadow
    protected abstract int getMaxScroll();

    @Shadow
    protected abstract void sendIt();

    @Shadow
    protected abstract boolean isConfirmHovered(int var1, int var2);

    @Shadow
    public abstract void requestCraftable(CraftableBigItemStack var1, int var2);

    @Shadow
    @Nullable
    protected abstract BigItemStack getOrderForItem(ItemStack var1);

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init_tail(CallbackInfo ci) {
        this.searchBox.setFocused(true);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseClicked(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        boolean lmbClicked = pButton == 0;
        Pair<Integer, Integer> ezLocation = this.getEzLocation();
        if (lmbClicked && pMouseX >= (double)((Integer)ezLocation.getFirst()).intValue() && pMouseX <= (double)((Integer)ezLocation.getFirst() + 16) && pMouseY >= (double)((Integer)ezLocation.getSecond()).intValue() && pMouseY <= (double)((Integer)ezLocation.getSecond() + 7)) {
            boolean newValue = (Boolean)ClientConfig.CONFIG.isEzStockTickerEnabled.get() == false;
            ClientConfig.CONFIG.isEzStockTickerEnabled.set((Object)newValue);
            ClientConfig.CONFIG.isEzStockTickerEnabled.save();
            this.playUiSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/BigItemStack;count:I", ordinal=1, shift=At.Shift.AFTER)})
    private void mouseClickedTransferInject(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir, @Local(name={"current"}) int current, @Local(name={"existingOrder"}) BigItemStack existingOrder, @Local(name={"transfer"}) LocalIntRef transfer, @Local(name={"rmb"}) boolean rmb) {
        boolean isEzEnabled = (Boolean)ClientConfig.CONFIG.isEzStockTickerEnabled.get();
        if (rmb && isEzEnabled) {
            transfer.set(existingOrder.count == 1 ? 1 : current / 2);
            existingOrder.count = current - transfer.get();
        }
    }

    @Overwrite
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        BigItemStack existingOrder;
        boolean recipeClicked;
        boolean noHover;
        if (this.addressBox.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        Couple<Integer> hoveredSlot = this.getHoveredSlot((int)mouseX, (int)mouseY);
        boolean bl = noHover = hoveredSlot == this.noneHovered;
        if (noHover || (Integer)hoveredSlot.getFirst() >= 0 && !StockKeeperRequestScreenMixin.hasShiftDown() && this.getMaxScroll() != 0) {
            int maxScroll = this.getMaxScroll();
            int direction = (int)(Math.ceil(Math.abs(scrollY)) * -Math.signum(scrollY));
            float newTarget = Mth.clamp((int)Math.round(this.itemScroll.getChaseTarget() + (float)direction), (int)0, (int)maxScroll);
            this.itemScroll.chase((double)newTarget, 0.5, LerpedFloat.Chaser.EXP);
            return true;
        }
        boolean orderClicked = (Integer)hoveredSlot.getFirst() == -1;
        boolean bl2 = recipeClicked = (Integer)hoveredSlot.getFirst() == -2;
        BigItemStack entry = recipeClicked ? (BigItemStack)this.recipesToOrder.get((Integer)hoveredSlot.getSecond()) : (orderClicked ? this.itemsToOrder.get((Integer)hoveredSlot.getSecond()) : this.displayedItems.get((Integer)hoveredSlot.getFirst()).get((Integer)hoveredSlot.getSecond()));
        boolean remove = scrollY < 0.0;
        int stackSnapping = StockKeeperRequestScreenMixin.hasControlDown() ? 10 : entry.stack.getMaxStackSize() / 4;
        int transfer = Mth.ceil((double)Math.abs(scrollY)) * (StockKeeperRequestScreenMixin.hasControlDown() ? 10 : 1);
        if (recipeClicked && entry instanceof CraftableBigItemStack) {
            CraftableBigItemStack cbis = (CraftableBigItemStack)entry;
            this.requestCraftable(cbis, remove ? -transfer : transfer);
            return true;
        }
        boolean isEzEnabled = (Boolean)ClientConfig.CONFIG.isEzStockTickerEnabled.get();
        BigItemStack bigItemStack = existingOrder = orderClicked ? entry : this.getOrderForItem(entry.stack);
        if (existingOrder == null) {
            if (this.itemsToOrder.size() >= this.cols || remove) {
                return true;
            }
            existingOrder = new BigItemStack(entry.stack.copyWithCount(StockKeeperRequestScreenMixin.hasShiftDown() && isEzEnabled ? stackSnapping : 1), 0);
            this.itemsToOrder.add(existingOrder);
            this.playUiSound(SoundEvents.WOOL_STEP, 0.75f, 1.2f);
            this.playUiSound(SoundEvents.BAMBOO_WOOD_STEP, 0.75f, 0.8f);
        }
        int current = existingOrder.count;
        if (isEzEnabled) {
            if (StockKeeperRequestScreenMixin.hasShiftDown() || StockKeeperRequestScreenMixin.hasControlDown()) {
                int target = (Math.floorDiv(current, stackSnapping) + (remove ? -1 : 1)) * stackSnapping;
                target = Math.max(1, target);
                transfer = (remove ? -1 : 1) * (target - current);
            } else if (remove) {
                int target = current + -transfer;
                target = Math.max(1, target);
                transfer = Math.abs(target - current);
            }
        }
        if (remove) {
            existingOrder.count = current - transfer;
            if (existingOrder.count <= 0) {
                this.itemsToOrder.remove(existingOrder);
                this.playUiSound(SoundEvents.WOOL_STEP, 0.75f, 1.8f);
                this.playUiSound(SoundEvents.BAMBOO_WOOD_STEP, 0.75f, 1.8f);
            } else if (existingOrder.count != current) {
                this.playUiSound(AllSoundEvents.SCROLL_VALUE.getMainEvent(), 0.25f, 1.2f);
            }
            return true;
        }
        existingOrder.count = current + Math.min(transfer, this.blockEntity.getLastClientsideStockSnapshotAsSummary().getCountOf(entry.stack) - current);
        if (existingOrder.count != current && current != 0) {
            this.playUiSound(AllSoundEvents.SCROLL_VALUE.getMainEvent(), 0.25f, 1.2f);
        }
        return true;
    }

    @Inject(method={"renderBg"}, at={@At(value="INVOKE", target="Lnet/createmod/catnip/gui/UIRenderHelper;swapAndBlitColor(Lcom/mojang/blaze3d/pipeline/RenderTarget;Lcom/mojang/blaze3d/pipeline/RenderTarget;)V", shift=At.Shift.BEFORE)})
    protected void renderForeground(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY, CallbackInfo ci) {
        boolean isEzEnabled = (Boolean)ClientConfig.CONFIG.isEzStockTickerEnabled.get();
        Pair<Integer, Integer> ezLocation = this.getEzLocation();
        int v = isEzEnabled ? 7 : 0;
        graphics.blit(STOCK_KEEPER_PATCH, ((Integer)ezLocation.getFirst()).intValue(), ((Integer)ezLocation.getSecond()).intValue(), 0, v, 16, 7);
    }

    @Inject(method={"renderForeground"}, at={@At(value="TAIL")})
    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        Pair<Integer, Integer> ezLocation = this.getEzLocation();
        if (mouseX >= (Integer)ezLocation.getFirst() && mouseX <= (Integer)ezLocation.getFirst() + 16 && mouseY >= (Integer)ezLocation.getSecond() && mouseY <= (Integer)ezLocation.getSecond() + 7) {
            graphics.renderComponentTooltip(this.font, (Boolean)ClientConfig.CONFIG.isEzStockTickerEnabled.get() != false ? List.of(Component.translatable((String)"ez_stock_ticker.gui.enabled").withStyle(ChatFormatting.GREEN), Component.translatable((String)"ez_stock_ticker.gui.enabled_description_1").withStyle(ChatFormatting.DARK_GRAY), Component.translatable((String)"ez_stock_ticker.gui.enabled_description_2").withStyle(ChatFormatting.DARK_GRAY), Component.translatable((String)"ez_stock_ticker.gui.click_to_toggle").withStyle(ChatFormatting.GRAY)) : List.of(Component.translatable((String)"ez_stock_ticker.gui.disabled").withStyle(ChatFormatting.RED), Component.translatable((String)"ez_stock_ticker.gui.disabled_description_1").withStyle(ChatFormatting.DARK_GRAY), Component.translatable((String)"ez_stock_ticker.gui.disabled_description_2").withStyle(ChatFormatting.DARK_GRAY), Component.translatable((String)"ez_stock_ticker.gui.click_to_toggle").withStyle(ChatFormatting.GRAY)), mouseX, mouseY);
        }
    }

    private Pair<Integer, Integer> getEzLocation() {
        int x = this.getGuiLeft();
        int y = this.getGuiTop() + HEADER.getHeight() + FOOTER.getHeight();
        for (int i = 0; i < (this.windowHeight - HEADER.getHeight() - FOOTER.getHeight()) / BODY.getHeight(); ++i) {
            y += BODY.getHeight();
        }
        int ezTooltipX = x + 13;
        int ezTooltipY = y - 13;
        return Pair.of((Object)ezTooltipX, (Object)ezTooltipY);
    }
}

