/*
 * Decompiled with CFR 0.152.
 */
package net.grimwitch.tanuki.entity.custom;

import com.google.common.annotations.VisibleForTesting;
import net.grimwitch.tanuki.entity.ModEntities;
import net.grimwitch.tanuki.entity.varient.TanukiVarient;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class TanukiEntity
extends TamableAnimal {
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeOut = 0;
    private static final Ingredient FOOD_ITEMS;
    public final AnimationState sitAnimationState = new AnimationState();
    public final AnimationState sitPoseAnimationState = new AnimationState();
    public final AnimationState sitUpAnimationState = new AnimationState();
    public final AnimationState layDownAnimationState = new AnimationState();
    public static final EntityDataAccessor<Long> LAST_POSE_CHANGE_TICK;
    private static final EntityDataAccessor<Boolean> IS_LYING;
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT;
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR;

    public TanukiEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean isTanukiSitting() {
        return (Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor pColor) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)pColor.m_41060_());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    public void setLying(boolean pLying) {
        this.f_19804_.m_135381_(IS_LYING, (Object)pLying);
    }

    public boolean isLying() {
        return (Boolean)this.f_19804_.m_135370_(IS_LYING);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeOut <= 0) {
            this.idleAnimationTimeOut = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeOut;
        }
        if (this.isTanukiVisuallySitting()) {
            this.sitUpAnimationState.m_216973_();
            if (this.isVisuallySittingDown()) {
                this.sitAnimationState.m_216982_(this.f_19797_);
                this.sitPoseAnimationState.m_216973_();
            } else {
                this.sitAnimationState.m_216973_();
                this.idleAnimationState.m_216973_();
                this.sitPoseAnimationState.m_216982_(this.f_19797_);
            }
        } else {
            this.sitAnimationState.m_216973_();
            this.sitPoseAnimationState.m_216973_();
            this.idleAnimationState.m_216982_(this.f_19797_);
            this.sitUpAnimationState.m_246184_(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.f_19797_);
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public long getPoseTime() {
        return this.m_9236_().m_46467_() - Math.abs((Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK));
    }

    public boolean isTanukiVisuallySitting() {
        return this.getPoseTime() < 0L != this.isTanukiSitting();
    }

    private boolean isVisuallySittingDown() {
        return this.isTanukiSitting() && this.getPoseTime() < 0L && this.getPoseTime() >= 0L;
    }

    public boolean isInPoseTransition() {
        long i = this.getPoseTime();
        return i < (long)(this.isTanukiSitting() ? 0 : 1);
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long pLastPoseChangeTick) {
        this.f_19804_.m_135381_(LAST_POSE_CHANGE_TICK, (Object)pLastPoseChangeTick);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, (double)1.1f));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, (double)1.2f, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.25, 4.0f, 24.0f, false));
        this.f_21345_.m_25352_(10, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(12, (Goal)new RestrictSunGoal((PathfinderMob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 8.0).m_22268_(Attributes.f_22287_, 25.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(LAST_POSE_CHANGE_TICK, (Object)0L);
        this.f_19804_.m_135372_(IS_LYING, (Object)false);
    }

    public void m_7378_(CompoundTag pCompound) {
        long i;
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)pCompound.m_128451_("Variant"));
        if (pCompound.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)pCompound.m_128451_("CollarColor")));
        }
        if ((i = pCompound.m_128454_("LastPoseTick")) < 0L) {
            this.m_20124_(Pose.SITTING);
        }
        this.resetLastPoseChangeTick(i);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Variant", this.getTypeVariant());
        pCompound.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        pCompound.m_128356_("LastPoseTick", ((Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK)).longValue());
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        TanukiEntity baby = (TanukiEntity)((EntityType)ModEntities.TANUKI.get()).m_20615_((Level)serverLevel);
        int j = this.f_19796_.m_188503_(1024);
        TanukiVarient variant = TanukiVarient.DEFAULT;
        if (j > 1023) {
            variant = TanukiVarient.KIYOMI;
        }
        baby.setVariant(variant);
        return baby;
    }

    public int m_5792_() {
        return 8;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        InteractionResult interactionresult1;
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (this.m_9236_().f_46443_) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)pPlayer)) {
                return InteractionResult.SUCCESS;
            }
            return this.m_6898_(itemstack) && (this.m_21223_() < this.m_21233_() || !this.m_21824_()) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)pPlayer)) {
                if (!(item instanceof DyeItem)) {
                    if (item.m_41472_() && this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                        this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                        this.m_142075_(pPlayer, pHand, itemstack);
                        return InteractionResult.CONSUME;
                    }
                    InteractionResult interactionresult = super.m_6071_(pPlayer, pHand);
                    if (!interactionresult.m_19077_() || this.m_6162_()) {
                        if (this.isTanukiSitting()) {
                            this.standUpInstantly();
                            this.m_21839_(false);
                        } else {
                            this.sitDownInstantly();
                            this.m_21839_(true);
                        }
                    }
                    return interactionresult;
                }
                DyeColor dyecolor = ((DyeItem)item).m_41089_();
                if (dyecolor != this.getCollarColor()) {
                    this.setCollarColor(dyecolor);
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_21530_();
                    return InteractionResult.CONSUME;
                }
            }
        } else if (this.m_6898_(itemstack)) {
            this.m_142075_(pPlayer, pHand, itemstack);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                this.m_21828_(pPlayer);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            return InteractionResult.CONSUME;
        }
        if ((interactionresult1 = super.m_6071_(pPlayer, pHand)).m_19077_()) {
            this.m_21530_();
        }
        return interactionresult1;
    }

    public boolean m_6898_(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_11944_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11948_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11948_;
    }

    public SoundEvent m_7866_(ItemStack pStack) {
        return SoundEvents.f_11948_;
    }

    public void sitDown() {
        if (!this.isTanukiSitting()) {
            this.m_20124_(Pose.SITTING);
            this.resetLastPoseChangeTick(-this.m_9236_().m_46467_());
        }
    }

    public void standUp() {
        if (this.isTanukiSitting()) {
            this.m_20124_(Pose.STANDING);
            this.resetLastPoseChangeTick(this.m_9236_().m_46467_());
        }
    }

    public void standUpInstantly() {
        this.m_20124_(Pose.STANDING);
        this.resetLastPoseChangeTickToFullStand(this.m_9236_().m_46467_());
    }

    public void sitDownInstantly() {
        this.m_20124_(Pose.SITTING);
        this.resetLastPoseChangeTick(-this.m_9236_().m_46467_());
    }

    private void resetLastPoseChangeTickToFullStand(long pLastPoseChangedTick) {
        this.resetLastPoseChangeTick(Math.max(0L, pLastPoseChangedTick - 52L - 1L));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_, @Nullable CompoundTag p_146750_) {
        int j = this.f_19796_.m_188503_(2048);
        TanukiVarient variant = TanukiVarient.DEFAULT;
        if (j > 2047) {
            variant = TanukiVarient.KIYOMI;
        }
        this.setVariant(variant);
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    public TanukiVarient getVariant() {
        return TanukiVarient.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(TanukiVarient variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    static {
        LAST_POSE_CHANGE_TICK = SynchedEntityData.m_135353_(TanukiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
        IS_LYING = SynchedEntityData.m_135353_(TanukiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(TanukiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(TanukiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42531_, Items.f_42580_, Items.f_42582_, Items.f_42530_, Items.f_42659_, Items.f_42486_, Items.f_42698_});
    }
}

