/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.command.relocate.incendo.cloud.velocity;

import app.simplecloud.plugin.command.relocate.incendo.cloud.CommandManager;
import app.simplecloud.plugin.command.relocate.incendo.cloud.SenderMapper;
import app.simplecloud.plugin.command.relocate.incendo.cloud.SenderMapperHolder;
import app.simplecloud.plugin.command.relocate.incendo.cloud.brigadier.BrigadierManagerHolder;
import app.simplecloud.plugin.command.relocate.incendo.cloud.brigadier.CloudBrigadierManager;
import app.simplecloud.plugin.command.relocate.incendo.cloud.brigadier.suggestion.TooltipSuggestion;
import app.simplecloud.plugin.command.relocate.incendo.cloud.caption.Caption;
import app.simplecloud.plugin.command.relocate.incendo.cloud.caption.CaptionProvider;
import app.simplecloud.plugin.command.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.plugin.command.relocate.incendo.cloud.execution.ExecutionCoordinator;
import app.simplecloud.plugin.command.relocate.incendo.cloud.suggestion.SuggestionFactory;
import app.simplecloud.plugin.command.relocate.incendo.cloud.velocity.VelocityCaptionKeys;
import app.simplecloud.plugin.command.relocate.incendo.cloud.velocity.VelocityCommandPreprocessor;
import app.simplecloud.plugin.command.relocate.incendo.cloud.velocity.VelocityPluginRegistrationHandler;
import app.simplecloud.plugin.command.relocate.incendo.cloud.velocity.parser.PlayerParser;
import app.simplecloud.plugin.command.relocate.incendo.cloud.velocity.parser.ServerParser;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@Singleton
public class VelocityCommandManager<C>
extends CommandManager<C>
implements BrigadierManagerHolder<C, CommandSource>,
SenderMapperHolder<CommandSource, C> {
    public static final String ARGUMENT_PARSE_FAILURE_PLAYER = "'<input>' is not a valid player";
    public static final String ARGUMENT_PARSE_FAILURE_SERVER = "'<input>' is not a valid server";
    private final ProxyServer proxyServer;
    private final SenderMapper<CommandSource, C> senderMapper;
    private final SuggestionFactory<C, ? extends TooltipSuggestion> suggestionFactory;

    @Inject
    public VelocityCommandManager(@NonNull PluginContainer plugin, @NonNull ProxyServer proxyServer, @NonNull ExecutionCoordinator<C> commandExecutionCoordinator, @NonNull SenderMapper<CommandSource, C> senderMapper) {
        super(commandExecutionCoordinator, new VelocityPluginRegistrationHandler());
        this.proxyServer = proxyServer;
        this.senderMapper = senderMapper;
        this.suggestionFactory = super.suggestionFactory().mapped(TooltipSuggestion::tooltipSuggestion);
        ((VelocityPluginRegistrationHandler)this.commandRegistrationHandler()).initialize(this);
        this.registerCommandPreProcessor(new VelocityCommandPreprocessor(this));
        this.parserRegistry().registerParser(PlayerParser.playerParser()).registerParser(ServerParser.serverParser());
        this.captionRegistry().registerProvider(CaptionProvider.constantProvider().putCaption(VelocityCaptionKeys.ARGUMENT_PARSE_FAILURE_PLAYER, ARGUMENT_PARSE_FAILURE_PLAYER).putCaption(VelocityCaptionKeys.ARGUMENT_PARSE_FAILURE_SERVER, ARGUMENT_PARSE_FAILURE_SERVER).build());
        this.proxyServer.getEventManager().register((Object)plugin, ServerPreConnectEvent.class, ev -> this.lockRegistration());
        this.parameterInjectorRegistry().registerInjector(CommandSource.class, (context, annotations) -> this.senderMapper.reverse(context.sender()));
        this.registerDefaultExceptionHandlers();
    }

    @Override
    public final boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        return this.senderMapper.reverse(sender).hasPermission(permission);
    }

    @Override
    @API(status=API.Status.STABLE, since="2.0.0")
    public final boolean hasBrigadierManager() {
        return true;
    }

    @Override
    @API(status=API.Status.STABLE, since="2.0.0")
    public final @NonNull CloudBrigadierManager<C, CommandSource> brigadierManager() {
        return ((VelocityPluginRegistrationHandler)this.commandRegistrationHandler()).brigadierManager();
    }

    @Override
    public final @NonNull SuggestionFactory<C, ? extends TooltipSuggestion> suggestionFactory() {
        return this.suggestionFactory;
    }

    final @NonNull ProxyServer proxyServer() {
        return this.proxyServer;
    }

    private void registerDefaultExceptionHandlers() {
        this.registerDefaultExceptionHandlers(triplet -> {
            CommandSource source = ((CommandContext)triplet.first()).inject(CommandSource.class).orElseThrow(NullPointerException::new);
            String message = ((CommandContext)triplet.first()).formatCaption((Caption)triplet.second(), (List)triplet.third());
            source.sendMessage((Component)Component.text(message, (TextColor)NamedTextColor.RED));
        }, pair -> ((Throwable)pair.second()).printStackTrace());
    }

    @Override
    public final @NonNull SenderMapper<CommandSource, C> senderMapper() {
        return this.senderMapper;
    }
}

