/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.command.relocate.spongepowered.configurate.reactive;

import app.simplecloud.plugin.command.relocate.spongepowered.configurate.reactive.Disposable;
import app.simplecloud.plugin.command.relocate.spongepowered.configurate.reactive.NoOpDisposable;
import app.simplecloud.plugin.command.relocate.spongepowered.configurate.reactive.Processor;
import app.simplecloud.plugin.command.relocate.spongepowered.configurate.reactive.Publisher;
import app.simplecloud.plugin.command.relocate.spongepowered.configurate.reactive.Subscriber;
import app.simplecloud.plugin.command.relocate.spongepowered.configurate.reactive.TransactionFailedException;
import app.simplecloud.plugin.command.relocate.spongepowered.configurate.util.CheckedFunction;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;

class MappedProcessor<I, O>
implements Processor.Transactional<I, O> {
    private final Processor.TransactionalIso<O> processor;
    private final AtomicReference<Disposable> disposable = new AtomicReference();
    private final CheckedFunction<? super I, ? extends O, TransactionFailedException> mapper;
    private final @Nullable Publisher<I> parent;

    MappedProcessor(CheckedFunction<? super I, ? extends O, TransactionFailedException> mapper, @Nullable Publisher<I> parent) {
        this.processor = parent == null ? Processor.createTransactional() : Processor.createTransactional(parent.executor());
        this.mapper = mapper;
        this.parent = parent;
    }

    @Override
    public Disposable subscribe(Subscriber<? super O> subscriber) {
        Disposable ret2 = this.processor.subscribe(subscriber);
        if (ret2 != NoOpDisposable.INSTANCE) {
            Disposable ours = this.disposable.updateAndGet(it -> it == null && this.parent != null ? this.parent.subscribe(this) : it);
            if (ours == NoOpDisposable.INSTANCE) {
                this.processor.onClose();
                return NoOpDisposable.INSTANCE;
            }
            return () -> {
                ret2.dispose();
                if (!this.hasSubscribers()) {
                    Disposable disposable = this.disposable.getAndSet(null);
                    disposable.dispose();
                }
            };
        }
        return ret2;
    }

    @Override
    public boolean hasSubscribers() {
        return this.processor.hasSubscribers();
    }

    @Override
    public Executor executor() {
        return this.processor.executor();
    }

    @Override
    public void beginTransaction(I newValue) throws TransactionFailedException {
        this.processor.beginTransaction(this.mapper.apply(newValue));
    }

    @Override
    public void commit() {
        this.processor.commit();
    }

    @Override
    public void rollback() {
        this.processor.rollback();
    }

    @Override
    public void onError(Throwable thrown) {
        this.processor.onError(thrown);
    }

    @Override
    public void onClose() {
        Disposable disposable = this.disposable.getAndSet(null);
        if (disposable != null) {
            disposable.dispose();
        }
        this.processor.onClose();
    }

    @Override
    public void inject(O element) {
        this.processor.submit(element);
    }

    @Override
    public void fallbackHandler(@Nullable Subscriber<O> subscriber) {
        this.processor.fallbackHandler(subscriber);
    }

    @Override
    public boolean closeIfUnsubscribed() {
        if (this.processor.closeIfUnsubscribed()) {
            Disposable disposable = this.disposable.getAndSet(null);
            if (disposable != null) {
                disposable.dispose();
            }
            return true;
        }
        return false;
    }
}

