/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.command.relocate.spongepowered.configurate.util;

import app.simplecloud.plugin.command.relocate.spongepowered.configurate.util.NamingScheme;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum NamingSchemes implements NamingScheme
{
    PASSTHROUGH{

        @Override
        public String coerce(String input) {
            return input;
        }
    }
    ,
    CAMEL_CASE{

        @Override
        public String coerce(String input) {
            Matcher match = DASH_UNDERSCORE.matcher(input);
            if (!match.find()) {
                return input;
            }
            StringBuffer ret2 = new StringBuffer(input.length());
            do {
                match.appendReplacement(ret2, "");
                ret2.appendCodePoint(input.codePointAt(match.start()));
                ret2.appendCodePoint(Character.toUpperCase(input.codePointBefore(match.end())));
            } while (match.find());
            match.appendTail(ret2);
            return ret2.toString();
        }
    }
    ,
    SNAKE_CASE{

        @Override
        public String coerce(String input) {
            return NamingSchemes.enforceLowerCaseSeparatorChar(input, '_', '-');
        }
    }
    ,
    LOWER_CASE_DASHED{

        @Override
        public String coerce(String input) {
            return NamingSchemes.enforceLowerCaseSeparatorChar(input, '-', '_');
        }
    };

    private static final Pattern DASH_UNDERSCORE;
    private static final char UNDERSCORE = '_';
    private static final char DASH = '-';

    private static String enforceLowerCaseSeparatorChar(String input, char preferredDelimiter, char convertDelimiter) {
        StringBuilder build = new StringBuilder(input);
        for (int i2 = 0; i2 < build.length(); ++i2) {
            int ch = build.codePointAt(i2);
            if (ch == convertDelimiter) {
                if (i2 == 0 || i2 == build.length() - 1) continue;
                build.setCharAt(i2, preferredDelimiter);
                continue;
            }
            if (!Character.isUpperCase(ch)) continue;
            build.insert(i2++, preferredDelimiter);
            int lower = Character.toLowerCase(ch);
            if (Character.isBmpCodePoint(lower)) {
                build.setCharAt(i2, (char)lower);
                continue;
            }
            build.setCharAt(i2++, Character.highSurrogate(lower));
            build.setCharAt(i2, Character.lowSurrogate(lower));
        }
        return build.toString();
    }

    static {
        DASH_UNDERSCORE = Pattern.compile(".[-_].");
    }
}

