/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.command.shared;

import app.simplecloud.controller.api.ControllerApi;
import app.simplecloud.controller.api.ServerApi;
import app.simplecloud.controller.shared.group.Group;
import app.simplecloud.controller.shared.server.Server;
import app.simplecloud.plugin.command.relocate.incendo.cloud.Command;
import app.simplecloud.plugin.command.relocate.incendo.cloud.CommandManager;
import app.simplecloud.plugin.command.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.plugin.command.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.plugin.command.relocate.incendo.cloud.parser.standard.LongParser;
import app.simplecloud.plugin.command.relocate.incendo.cloud.parser.standard.StringParser;
import app.simplecloud.plugin.command.relocate.incendo.cloud.permission.Permission;
import app.simplecloud.plugin.command.relocate.incendo.cloud.suggestion.Suggestion;
import app.simplecloud.plugin.command.shared.CloudSender;
import app.simplecloud.plugin.command.shared.CommandPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0002J\b\u0010\u0016\u001a\u00020\u000fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lapp/simplecloud/plugin/command/shared/CloudCommandHandler;", "C", "Lapp/simplecloud/plugin/command/shared/CloudSender;", "", "commandManager", "Lapp/simplecloud/plugin/command/relocate/incendo/cloud/CommandManager;", "commandPlugin", "Lapp/simplecloud/plugin/command/shared/CommandPlugin;", "<init>", "(Lorg/incendo/cloud/CommandManager;Lapp/simplecloud/plugin/command/shared/CommandPlugin;)V", "getCommandPlugin", "()Lapp/simplecloud/plugin/command/shared/CommandPlugin;", "controllerApi", "Lapp/simplecloud/controller/api/ControllerApi$Future;", "createCloudCommand", "", "registerStartCommand", "registerStopCommand", "registerServerInfoCommand", "registerGroupInfoCommand", "registerDeleteGroupCommand", "registerEditGroupCommand", "registerEditServerCommand", "command-shared"})
@SourceDebugExtension(value={"SMAP\nCloudCommandHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudCommandHandler.kt\napp/simplecloud/plugin/command/shared/CloudCommandHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,611:1\n1557#2:612\n1628#2,3:613\n1557#2:616\n1628#2,3:617\n1557#2:620\n1628#2,3:621\n1863#2,2:624\n1557#2:626\n1628#2,3:627\n1557#2:630\n1628#2,3:631\n1863#2,2:634\n1863#2,2:636\n1557#2:638\n1628#2,3:639\n1863#2,2:642\n1557#2:644\n1628#2,3:645\n1863#2,2:648\n1557#2:650\n1628#2,3:651\n1557#2:654\n1628#2,3:655\n1557#2:658\n1628#2,3:659\n1557#2:662\n1628#2,3:663\n1557#2:666\n1628#2,3:667\n*S KotlinDebug\n*F\n+ 1 CloudCommandHandler.kt\napp/simplecloud/plugin/command/shared/CloudCommandHandler\n*L\n79#1:612\n79#1:613,3\n107#1:616\n107#1:617,3\n112#1:620\n112#1:621,3\n126#1:624,2\n159#1:626\n159#1:627,3\n164#1:630\n164#1:631,3\n235#1:634,2\n265#1:636,2\n301#1:638\n301#1:639,3\n356#1:642,2\n395#1:644\n395#1:645,3\n407#1:648,2\n430#1:650\n430#1:651,3\n444#1:654\n444#1:655,3\n552#1:658\n552#1:659,3\n557#1:662\n557#1:663,3\n562#1:666\n562#1:667,3\n*E\n"})
public final class CloudCommandHandler<C extends CloudSender> {
    @NotNull
    private final CommandManager<C> commandManager;
    @NotNull
    private final CommandPlugin commandPlugin;
    @NotNull
    private final ControllerApi.Future controllerApi;

    public CloudCommandHandler(@NotNull CommandManager<C> commandManager, @NotNull CommandPlugin commandPlugin) {
        Intrinsics.checkNotNullParameter(commandManager, (String)"commandManager");
        Intrinsics.checkNotNullParameter((Object)commandPlugin, (String)"commandPlugin");
        this.commandManager = commandManager;
        this.commandPlugin = commandPlugin;
        this.controllerApi = ControllerApi.Companion.createFutureApi();
    }

    @NotNull
    public final CommandPlugin getCommandPlugin() {
        return this.commandPlugin;
    }

    public final void createCloudCommand() {
        this.commandManager.command(this.commandManager.commandBuilder("cloud", new String[0]).handler(arg_0 -> CloudCommandHandler.createCloudCommand$lambda$0(this, arg_0)).permission(Permission.permission("simplecloud.command.cloud")).build());
        this.registerStartCommand();
        this.registerStopCommand();
        this.registerServerInfoCommand();
        this.registerGroupInfoCommand();
        this.registerDeleteGroupCommand();
        this.registerEditGroupCommand();
        this.registerEditServerCommand();
    }

    private final void registerStartCommand() {
        this.commandManager.command(this.commandManager.commandBuilder("cloud", new String[0]).literal("start", new String[0]).required("group", StringParser.stringParser(), (arg_0, arg_1) -> CloudCommandHandler.registerStartCommand$lambda$4(this, arg_0, arg_1)).handler(arg_0 -> CloudCommandHandler.registerStartCommand$lambda$7(this, arg_0)).permission(Permission.permission("simplecloud.command.cloud.start")).build());
    }

    private final void registerStopCommand() {
        this.commandManager.command(this.commandManager.commandBuilder("cloud", new String[0]).literal("stop", new String[0]).required("group", StringParser.stringParser(), (arg_0, arg_1) -> CloudCommandHandler.registerStopCommand$lambda$11(this, arg_0, arg_1)).optional("id", LongParser.longParser(), (arg_0, arg_1) -> CloudCommandHandler.registerStopCommand$lambda$15(this, arg_0, arg_1)).handler(arg_0 -> CloudCommandHandler.registerStopCommand$lambda$19(this, arg_0)).permission(Permission.permission("simplecloud.command.cloud.stop")).build());
    }

    private final void registerServerInfoCommand() {
        String[] stringArray = new String[]{"get"};
        Command.Builder builder = this.commandManager.commandBuilder("cloud", new String[0]).literal("info", stringArray);
        stringArray = new String[]{"server"};
        this.commandManager.command(builder.literal("servers", stringArray).optional("group", StringParser.stringParser(), (arg_0, arg_1) -> CloudCommandHandler.registerServerInfoCommand$lambda$23(this, arg_0, arg_1)).optional("id", LongParser.longParser(), (arg_0, arg_1) -> CloudCommandHandler.registerServerInfoCommand$lambda$27(this, arg_0, arg_1)).handler(arg_0 -> CloudCommandHandler.registerServerInfoCommand$lambda$38(this, arg_0)).permission(Permission.permission("simplecloud.command.cloud.get.servers")).build());
    }

    private final void registerGroupInfoCommand() {
        String[] stringArray = new String[]{"get"};
        Command.Builder builder = this.commandManager.commandBuilder("cloud", new String[0]).literal("info", stringArray);
        stringArray = new String[]{"group"};
        this.commandManager.command(builder.literal("groups", stringArray).optional("group", StringParser.stringParser(), (arg_0, arg_1) -> CloudCommandHandler.registerGroupInfoCommand$lambda$42(this, arg_0, arg_1)).handler(arg_0 -> CloudCommandHandler.registerGroupInfoCommand$lambda$50(this, arg_0)).permission(Permission.permission("simplecloud.command.cloud.get.groups")).build());
    }

    private final void registerDeleteGroupCommand() {
        this.commandManager.command(this.commandManager.commandBuilder("cloud", new String[0]).literal("delete", new String[0]).literal("group", new String[0]).required("group", StringParser.stringParser(), (arg_0, arg_1) -> CloudCommandHandler.registerDeleteGroupCommand$lambda$54(this, arg_0, arg_1)).handler(arg_0 -> CloudCommandHandler.registerDeleteGroupCommand$lambda$58(this, arg_0)).permission(Permission.permission("simplecloud.command.cloud.delete.group")).build());
    }

    private final void registerEditGroupCommand() {
        this.commandManager.command(this.commandManager.commandBuilder("cloud", new String[0]).literal("edit", new String[0]).literal("group", new String[0]).required("group", StringParser.stringParser(), (arg_0, arg_1) -> CloudCommandHandler.registerEditGroupCommand$lambda$62(this, arg_0, arg_1)).required("setting", StringParser.stringParser(), CloudCommandHandler::registerEditGroupCommand$lambda$64).required("value", StringParser.stringParser()).handler(arg_0 -> CloudCommandHandler.registerEditGroupCommand$lambda$69(this, arg_0)).permission(Permission.permission("simplecloud.command.cloud.edit.group")).build());
    }

    private final void registerEditServerCommand() {
        this.commandManager.command(this.commandManager.commandBuilder("cloud", new String[0]).literal("edit", new String[0]).literal("server", new String[0]).required("group", StringParser.stringParser(), (arg_0, arg_1) -> CloudCommandHandler.registerEditServerCommand$lambda$73(this, arg_0, arg_1)).required("id", LongParser.longParser(), (arg_0, arg_1) -> CloudCommandHandler.registerEditServerCommand$lambda$77(this, arg_0, arg_1)).required("setting", StringParser.stringParser(), CloudCommandHandler::registerEditServerCommand$lambda$79).required("value", StringParser.stringParser()).handler(arg_0 -> CloudCommandHandler.registerEditServerCommand$lambda$84(this, arg_0)).permission(Permission.permission("simplecloud.command.cloud.edit.server")).build());
    }

    private static final void createCloudCommand$lambda$0(CloudCommandHandler this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CloudSender cloudSender = (CloudSender)context.sender();
        Object o = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getCloudHelpTitle());
        Intrinsics.checkNotNullExpressionValue(o, (String)"deserialize(...)");
        cloudSender.sendMessage((Component)o);
        CloudSender cloudSender2 = (CloudSender)context.sender();
        Object o2 = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getCloudStartCommand());
        Intrinsics.checkNotNullExpressionValue(o2, (String)"deserialize(...)");
        cloudSender2.sendMessage((Component)o2);
        CloudSender cloudSender3 = (CloudSender)context.sender();
        Object o3 = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getCloudStopCommand());
        Intrinsics.checkNotNullExpressionValue(o3, (String)"deserialize(...)");
        cloudSender3.sendMessage((Component)o3);
        CloudSender cloudSender4 = (CloudSender)context.sender();
        Object o4 = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getCloudServerInfoCommand());
        Intrinsics.checkNotNullExpressionValue(o4, (String)"deserialize(...)");
        cloudSender4.sendMessage((Component)o4);
        CloudSender cloudSender5 = (CloudSender)context.sender();
        Object o5 = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getCloudGroupInfoCommand());
        Intrinsics.checkNotNullExpressionValue(o5, (String)"deserialize(...)");
        cloudSender5.sendMessage((Component)o5);
        CloudSender cloudSender6 = (CloudSender)context.sender();
        Object o6 = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getCloudEditGroupCommand());
        Intrinsics.checkNotNullExpressionValue(o6, (String)"deserialize(...)");
        cloudSender6.sendMessage((Component)o6);
        CloudSender cloudSender7 = (CloudSender)context.sender();
        Object o7 = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getCloudEditServerCommand());
        Intrinsics.checkNotNullExpressionValue(o7, (String)"deserialize(...)");
        cloudSender7.sendMessage((Component)o7);
        CloudSender cloudSender8 = (CloudSender)context.sender();
        Object o8 = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getCloudDeleteGroupCommand());
        Intrinsics.checkNotNullExpressionValue(o8, (String)"deserialize(...)");
        cloudSender8.sendMessage((Component)o8);
    }

    /*
     * WARNING - void declaration
     */
    private static final List registerStartCommand$lambda$4$lambda$2(List groups) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)groups);
        Iterable $this$map$iv = groups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void group;
            Group group2 = (Group)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Suggestion.suggestion(group.getName()));
        }
        return (List)destination$iv$iv;
    }

    private static final List registerStartCommand$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final CompletableFuture registerStartCommand$lambda$4(CloudCommandHandler this$0, CommandContext commandContext, CommandInput commandInput) {
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        return this$0.controllerApi.getGroups().getAllGroups().thenApply(arg_0 -> CloudCommandHandler.registerStartCommand$lambda$4$lambda$3(CloudCommandHandler::registerStartCommand$lambda$4$lambda$2, arg_0));
    }

    private static final Unit registerStartCommand$lambda$7$lambda$5(CloudCommandHandler this$0, String $group, CommandContext $context, Server server) {
        MiniMessage miniMessage = MiniMessage.miniMessage();
        String string = this$0.commandPlugin.getMessageConfiguration().getServerStarting();
        TagResolver[] tagResolverArray = new TagResolver[2];
        tagResolverArray[0] = Placeholder.component("group", Component.text($group));
        Server server2 = server;
        Integer n = server2 != null ? Integer.valueOf(server2.getNumericalId()) : null;
        Intrinsics.checkNotNull((Object)n);
        tagResolverArray[1] = Placeholder.component("id", Component.text(n));
        Component component = miniMessage.deserialize(string, tagResolverArray);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
        Component message = component;
        ((CloudSender)$context.sender()).sendMessage(message);
        return Unit.INSTANCE;
    }

    private static final void registerStartCommand$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void registerStartCommand$lambda$7(CloudCommandHandler this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object v = context.get("group");
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        String group = (String)v;
        ServerApi.Future.DefaultImpls.startServer$default((ServerApi.Future)this$0.controllerApi.getServers(), (String)group, null, (int)2, null).thenAccept(arg_0 -> CloudCommandHandler.registerStartCommand$lambda$7$lambda$6(arg_0 -> CloudCommandHandler.registerStartCommand$lambda$7$lambda$5(this$0, group, context, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final List registerStopCommand$lambda$11$lambda$9(List groups) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)groups);
        Iterable $this$map$iv = groups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void group;
            Group group2 = (Group)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Suggestion.suggestion(group.getName()));
        }
        return (List)destination$iv$iv;
    }

    private static final List registerStopCommand$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final CompletableFuture registerStopCommand$lambda$11(CloudCommandHandler this$0, CommandContext commandContext, CommandInput commandInput) {
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        return this$0.controllerApi.getGroups().getAllGroups().thenApply(arg_0 -> CloudCommandHandler.registerStopCommand$lambda$11$lambda$10(CloudCommandHandler::registerStopCommand$lambda$11$lambda$9, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final List registerStopCommand$lambda$15$lambda$13(List servers) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)servers);
        Iterable $this$map$iv = servers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void server;
            Server server2 = (Server)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Suggestion.suggestion(String.valueOf(server.getNumericalId())));
        }
        return (List)destination$iv$iv;
    }

    private static final List registerStopCommand$lambda$15$lambda$14(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final CompletableFuture registerStopCommand$lambda$15(CloudCommandHandler this$0, CommandContext commandContext, CommandInput commandInput) {
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        return this$0.controllerApi.getServers().getAllServers().thenApply(arg_0 -> CloudCommandHandler.registerStopCommand$lambda$15$lambda$14(CloudCommandHandler::registerStopCommand$lambda$15$lambda$13, arg_0));
    }

    private static final Unit registerStopCommand$lambda$19$lambda$17(CloudCommandHandler this$0, List servers) {
        Intrinsics.checkNotNull((Object)servers);
        Iterable $this$forEach$iv = servers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Server server = (Server)element$iv;
            boolean bl = false;
            ServerApi.Future.DefaultImpls.stopServer$default((ServerApi.Future)this$0.controllerApi.getServers(), (String)server.getGroup(), (long)server.getNumericalId(), null, (int)4, null);
        }
        return Unit.INSTANCE;
    }

    private static final void registerStopCommand$lambda$19$lambda$18(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void registerStopCommand$lambda$19(CloudCommandHandler this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object v = context.get("group");
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        String group = (String)v;
        Long id = context.getOrDefault("id", null);
        if (id == null) {
            Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getGroupServerStopped(), (TagResolver)Placeholder.component("group", Component.text(group)));
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
            Component message = component;
            this$0.controllerApi.getServers().getServersByGroup(group).thenAccept(arg_0 -> CloudCommandHandler.registerStopCommand$lambda$19$lambda$18(arg_0 -> CloudCommandHandler.registerStopCommand$lambda$19$lambda$17(this$0, arg_0), arg_0));
            ((CloudSender)context.sender()).sendMessage(message);
        } else {
            TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component("group", Component.text(group)), Placeholder.component("id", Component.text(id.toString()))};
            Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getServerStopped(), tagResolverArray);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
            Component message = component;
            ServerApi.Future.DefaultImpls.stopServer$default((ServerApi.Future)this$0.controllerApi.getServers(), (String)group, (long)id, null, (int)4, null);
            ((CloudSender)context.sender()).sendMessage(message);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List registerServerInfoCommand$lambda$23$lambda$21(List groups) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)groups);
        Iterable $this$map$iv = groups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void group;
            Group group2 = (Group)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Suggestion.suggestion(group.getName()));
        }
        return (List)destination$iv$iv;
    }

    private static final List registerServerInfoCommand$lambda$23$lambda$22(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final CompletableFuture registerServerInfoCommand$lambda$23(CloudCommandHandler this$0, CommandContext commandContext, CommandInput commandInput) {
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        return this$0.controllerApi.getGroups().getAllGroups().thenApply(arg_0 -> CloudCommandHandler.registerServerInfoCommand$lambda$23$lambda$22(CloudCommandHandler::registerServerInfoCommand$lambda$23$lambda$21, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final List registerServerInfoCommand$lambda$27$lambda$25(List servers) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)servers);
        Iterable $this$map$iv = servers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void server;
            Server server2 = (Server)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Suggestion.suggestion(String.valueOf(server.getNumericalId())));
        }
        return (List)destination$iv$iv;
    }

    private static final List registerServerInfoCommand$lambda$27$lambda$26(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final CompletableFuture registerServerInfoCommand$lambda$27(CloudCommandHandler this$0, CommandContext commandContext, CommandInput commandInput) {
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        return this$0.controllerApi.getServers().getAllServers().thenApply(arg_0 -> CloudCommandHandler.registerServerInfoCommand$lambda$27$lambda$26(CloudCommandHandler::registerServerInfoCommand$lambda$27$lambda$25, arg_0));
    }

    private static final Unit registerServerInfoCommand$lambda$38$lambda$30$lambda$28(CommandContext $context, CloudCommandHandler this$0, Server $server, String $groupName, Group group) {
        CloudSender cloudSender = (CloudSender)$context.sender();
        TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component("servergroup", Component.text($server.getGroup())), Placeholder.component("serveramount", Component.text(String.valueOf(((List)this$0.controllerApi.getServers().getServersByGroup($groupName).get()).size())))};
        Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getServerInfoTitle(), tagResolverArray);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
        cloudSender.sendMessage(component);
        CloudSender cloudSender2 = (CloudSender)$context.sender();
        Component component2 = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getServerInfoType(), (TagResolver)Placeholder.component("grouptype", Component.text($server.getType().name())));
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"deserialize(...)");
        cloudSender2.sendMessage(component2);
        CloudSender cloudSender3 = (CloudSender)$context.sender();
        Component component3 = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getServerInfoSoftware(), (TagResolver)Placeholder.component("groupsoftware", Component.text(String.valueOf(group.getProperties().get("server-software")))));
        Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"deserialize(...)");
        cloudSender3.sendMessage(component3);
        CloudSender cloudSender4 = (CloudSender)$context.sender();
        Component component4 = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getServerInfoMemory(), (TagResolver)Placeholder.component("groupmemory", Component.text($server.getMaxMemory())));
        Intrinsics.checkNotNullExpressionValue((Object)component4, (String)"deserialize(...)");
        cloudSender4.sendMessage(component4);
        CloudSender cloudSender5 = (CloudSender)$context.sender();
        Component component5 = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getServerInfoPlayers(), (TagResolver)Placeholder.component("groupplayers", Component.text($server.getPlayerCount())));
        Intrinsics.checkNotNullExpressionValue((Object)component5, (String)"deserialize(...)");
        cloudSender5.sendMessage(component5);
        return Unit.INSTANCE;
    }

    private static final void registerServerInfoCommand$lambda$38$lambda$30$lambda$29(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit registerServerInfoCommand$lambda$38$lambda$30(CloudCommandHandler this$0, String $groupName, CommandContext $context, Server server) {
        this$0.controllerApi.getGroups().getGroupByName($groupName).thenAccept(arg_0 -> CloudCommandHandler.registerServerInfoCommand$lambda$38$lambda$30$lambda$29(arg_0 -> CloudCommandHandler.registerServerInfoCommand$lambda$38$lambda$30$lambda$28($context, this$0, server, $groupName, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void registerServerInfoCommand$lambda$38$lambda$31(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit registerServerInfoCommand$lambda$38$lambda$33(CommandContext $context, CloudCommandHandler this$0, String $groupName, List servers) {
        CloudSender cloudSender = (CloudSender)$context.sender();
        Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getGroupServerListTitle(), (TagResolver)Placeholder.component("servergroup", Component.text($groupName)));
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
        cloudSender.sendMessage(component);
        Intrinsics.checkNotNull((Object)servers);
        Iterable $this$forEach$iv = servers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Server server = (Server)element$iv;
            boolean bl = false;
            CloudSender cloudSender2 = (CloudSender)$context.sender();
            TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component("servergroup", Component.text(server.getGroup())), Placeholder.component("numericalid", Component.text(String.valueOf(server.getNumericalId()))), Placeholder.component("onlineplayers", Component.text(server.getPlayerCount())), Placeholder.component("maxplayers", Component.text(server.getMaxPlayers())), Placeholder.component("minmemory", Component.text(server.getMinMemory())), Placeholder.component("maxmemory", Component.text(server.getMaxMemory())), Placeholder.component("state", Component.text(server.getState().name()))};
            Component component2 = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getGroupServerListEntry(), tagResolverArray);
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"deserialize(...)");
            cloudSender2.sendMessage(component2);
        }
        return Unit.INSTANCE;
    }

    private static final void registerServerInfoCommand$lambda$38$lambda$34(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit registerServerInfoCommand$lambda$38$lambda$36(CommandContext $context, CloudCommandHandler this$0, List servers) {
        CloudSender cloudSender = (CloudSender)$context.sender();
        Object o = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getServerListTitle());
        Intrinsics.checkNotNullExpressionValue(o, (String)"deserialize(...)");
        cloudSender.sendMessage((Component)o);
        Intrinsics.checkNotNull((Object)servers);
        Iterable $this$forEach$iv = servers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Server server = (Server)element$iv;
            boolean bl = false;
            CloudSender cloudSender2 = (CloudSender)$context.sender();
            TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component("servergroup", Component.text(server.getGroup())), Placeholder.component("numericalid", Component.text(String.valueOf(server.getNumericalId()))), Placeholder.component("onlineplayers", Component.text(server.getPlayerCount())), Placeholder.component("maxplayers", Component.text(server.getMaxPlayers())), Placeholder.component("minmemory", Component.text(server.getMinMemory())), Placeholder.component("maxmemory", Component.text(server.getMaxMemory())), Placeholder.component("state", Component.text(server.getState().name()))};
            Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getServerListEntry(), tagResolverArray);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
            cloudSender2.sendMessage(component);
        }
        return Unit.INSTANCE;
    }

    private static final void registerServerInfoCommand$lambda$38$lambda$37(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void registerServerInfoCommand$lambda$38(CloudCommandHandler this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String groupName = context.getOrDefault("group", null);
        Long id = context.getOrDefault("id", null);
        CompletionStage completionStage = groupName != null && id != null ? this$0.controllerApi.getServers().getServerByNumerical(groupName, id.longValue()).thenAccept(arg_0 -> CloudCommandHandler.registerServerInfoCommand$lambda$38$lambda$31(arg_0 -> CloudCommandHandler.registerServerInfoCommand$lambda$38$lambda$30(this$0, groupName, context, arg_0), arg_0)) : (groupName != null ? this$0.controllerApi.getServers().getServersByGroup(groupName).thenAccept(arg_0 -> CloudCommandHandler.registerServerInfoCommand$lambda$38$lambda$34(arg_0 -> CloudCommandHandler.registerServerInfoCommand$lambda$38$lambda$33(context, this$0, groupName, arg_0), arg_0)) : this$0.controllerApi.getServers().getAllServers().thenAccept(arg_0 -> CloudCommandHandler.registerServerInfoCommand$lambda$38$lambda$37(arg_0 -> CloudCommandHandler.registerServerInfoCommand$lambda$38$lambda$36(context, this$0, arg_0), arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private static final List registerGroupInfoCommand$lambda$42$lambda$40(List groups) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)groups);
        Iterable $this$map$iv = groups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void group;
            Group group2 = (Group)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Suggestion.suggestion(group.getName()));
        }
        return (List)destination$iv$iv;
    }

    private static final List registerGroupInfoCommand$lambda$42$lambda$41(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final CompletableFuture registerGroupInfoCommand$lambda$42(CloudCommandHandler this$0, CommandContext commandContext, CommandInput commandInput) {
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        return this$0.controllerApi.getGroups().getAllGroups().thenApply(arg_0 -> CloudCommandHandler.registerGroupInfoCommand$lambda$42$lambda$41(CloudCommandHandler::registerGroupInfoCommand$lambda$42$lambda$40, arg_0));
    }

    private static final Unit registerGroupInfoCommand$lambda$50$lambda$45$lambda$43(CommandContext $context, CloudCommandHandler this$0, String $groupName, Group $group, List servers) {
        CloudSender cloudSender = (CloudSender)$context.sender();
        TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component("servergroup", Component.text($groupName)), Placeholder.component("serveramount", Component.text(servers.size()))};
        Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getGroupInfoTitle(), tagResolverArray);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
        cloudSender.sendMessage(component);
        CloudSender cloudSender2 = (CloudSender)$context.sender();
        Component component2 = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getGroupInfoType(), (TagResolver)Placeholder.component("grouptype", Component.text($group.getType().name())));
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"deserialize(...)");
        cloudSender2.sendMessage(component2);
        CloudSender cloudSender3 = (CloudSender)$context.sender();
        Component component3 = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getGroupInfoTemplate(), (TagResolver)Placeholder.component("grouptemplate", Component.text(String.valueOf($group.getProperties().get("template-id")))));
        Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"deserialize(...)");
        cloudSender3.sendMessage(component3);
        CloudSender cloudSender4 = (CloudSender)$context.sender();
        tagResolverArray = new TagResolver[]{Placeholder.component("minmemory", Component.text($group.getMinMemory())), Placeholder.component("maxmemory", Component.text($group.getMaxMemory()))};
        Component component4 = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getGroupInfoMemory(), tagResolverArray);
        Intrinsics.checkNotNullExpressionValue((Object)component4, (String)"deserialize(...)");
        cloudSender4.sendMessage(component4);
        CloudSender cloudSender5 = (CloudSender)$context.sender();
        Component component5 = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getGroupInfoPlayers(), (TagResolver)Placeholder.component("maxplayers", Component.text($group.getMaxPlayers())));
        Intrinsics.checkNotNullExpressionValue((Object)component5, (String)"deserialize(...)");
        cloudSender5.sendMessage(component5);
        return Unit.INSTANCE;
    }

    private static final void registerGroupInfoCommand$lambda$50$lambda$45$lambda$44(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit registerGroupInfoCommand$lambda$50$lambda$45(CloudCommandHandler this$0, String $groupName, CommandContext $context, Group group) {
        this$0.controllerApi.getServers().getServersByGroup($groupName).thenAccept(arg_0 -> CloudCommandHandler.registerGroupInfoCommand$lambda$50$lambda$45$lambda$44(arg_0 -> CloudCommandHandler.registerGroupInfoCommand$lambda$50$lambda$45$lambda$43($context, this$0, $groupName, group, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void registerGroupInfoCommand$lambda$50$lambda$46(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit registerGroupInfoCommand$lambda$50$lambda$48(CommandContext $context, CloudCommandHandler this$0, List groups) {
        CloudSender cloudSender = (CloudSender)$context.sender();
        Object o = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getGroupsListTitle());
        Intrinsics.checkNotNullExpressionValue(o, (String)"deserialize(...)");
        cloudSender.sendMessage((Component)o);
        Intrinsics.checkNotNull((Object)groups);
        Iterable $this$forEach$iv = groups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Group group = (Group)element$iv;
            boolean bl = false;
            CloudSender cloudSender2 = (CloudSender)$context.sender();
            TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component("servergroup", Component.text(group.getName())), Placeholder.component("onlinecount", Component.text(String.valueOf(((List)this$0.controllerApi.getServers().getServersByGroup(group).get()).size()))), Placeholder.component("template", Component.text(String.valueOf(group.getProperties().get("template-id")))), Placeholder.component("type", Component.text(group.getType().name())), Placeholder.component("maxcount", Component.text(group.getMaxOnlineCount())), Placeholder.component("minmemory", Component.text(group.getMinMemory())), Placeholder.component("maxmemory", Component.text(group.getMaxMemory()))};
            Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getGroupsListEntry(), tagResolverArray);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
            cloudSender2.sendMessage(component);
        }
        return Unit.INSTANCE;
    }

    private static final void registerGroupInfoCommand$lambda$50$lambda$49(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void registerGroupInfoCommand$lambda$50(CloudCommandHandler this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String groupName = context.getOrDefault("group", null);
        CompletionStage completionStage = groupName != null ? this$0.controllerApi.getGroups().getGroupByName(groupName).thenAccept(arg_0 -> CloudCommandHandler.registerGroupInfoCommand$lambda$50$lambda$46(arg_0 -> CloudCommandHandler.registerGroupInfoCommand$lambda$50$lambda$45(this$0, groupName, context, arg_0), arg_0)) : this$0.controllerApi.getGroups().getAllGroups().thenAccept(arg_0 -> CloudCommandHandler.registerGroupInfoCommand$lambda$50$lambda$49(arg_0 -> CloudCommandHandler.registerGroupInfoCommand$lambda$50$lambda$48(context, this$0, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final List registerDeleteGroupCommand$lambda$54$lambda$52(List groups) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)groups);
        Iterable $this$map$iv = groups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void group;
            Group group2 = (Group)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Suggestion.suggestion(group.getName()));
        }
        return (List)destination$iv$iv;
    }

    private static final List registerDeleteGroupCommand$lambda$54$lambda$53(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final CompletableFuture registerDeleteGroupCommand$lambda$54(CloudCommandHandler this$0, CommandContext commandContext, CommandInput commandInput) {
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        return this$0.controllerApi.getGroups().getAllGroups().thenApply(arg_0 -> CloudCommandHandler.registerDeleteGroupCommand$lambda$54$lambda$53(CloudCommandHandler::registerDeleteGroupCommand$lambda$54$lambda$52, arg_0));
    }

    private static final Unit registerDeleteGroupCommand$lambda$58$lambda$56(CloudCommandHandler this$0, List servers) {
        Intrinsics.checkNotNull((Object)servers);
        Iterable $this$forEach$iv = servers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Server server = (Server)element$iv;
            boolean bl = false;
            ServerApi.Future.DefaultImpls.stopServer$default((ServerApi.Future)this$0.controllerApi.getServers(), (String)server.getGroup(), (long)server.getNumericalId(), null, (int)4, null);
        }
        return Unit.INSTANCE;
    }

    private static final void registerDeleteGroupCommand$lambda$58$lambda$57(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void registerDeleteGroupCommand$lambda$58(CloudCommandHandler this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object v = context.get("group");
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        String group = (String)v;
        Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getGroupDeleted(), (TagResolver)Placeholder.component("group", Component.text(group)));
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
        Component message = component;
        this$0.controllerApi.getServers().getServersByGroup(group).thenAccept(arg_0 -> CloudCommandHandler.registerDeleteGroupCommand$lambda$58$lambda$57(arg_0 -> CloudCommandHandler.registerDeleteGroupCommand$lambda$58$lambda$56(this$0, arg_0), arg_0));
        this$0.controllerApi.getGroups().deleteGroup(group);
        ((CloudSender)context.sender()).sendMessage(message);
    }

    /*
     * WARNING - void declaration
     */
    private static final List registerEditGroupCommand$lambda$62$lambda$60(List groups) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)groups);
        Iterable $this$map$iv = groups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void group;
            Group group2 = (Group)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Suggestion.suggestion(group.getName()));
        }
        return (List)destination$iv$iv;
    }

    private static final List registerEditGroupCommand$lambda$62$lambda$61(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final CompletableFuture registerEditGroupCommand$lambda$62(CloudCommandHandler this$0, CommandContext commandContext, CommandInput commandInput) {
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        return this$0.controllerApi.getGroups().getAllGroups().thenApply(arg_0 -> CloudCommandHandler.registerEditGroupCommand$lambda$62$lambda$61(CloudCommandHandler::registerEditGroupCommand$lambda$62$lambda$60, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final CompletableFuture registerEditGroupCommand$lambda$64(CommandContext commandContext, CommandInput commandInput) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        Object[] objectArray = new String[]{"max-players", "max-memory", "max-online-count", "min-memory", "min-online-count", "properties", "server-url", "start-port"};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Suggestion.suggestion((String)it));
        }
        return CompletableFuture.completedFuture((List)destination$iv$iv);
    }

    private static final Unit registerEditGroupCommand$lambda$69$lambda$67$lambda$65(CommandContext $context, CloudCommandHandler this$0, Group group) {
        CloudSender cloudSender = (CloudSender)$context.sender();
        Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getGroupUpdated(), (TagResolver)Placeholder.component("group", Component.text(group.getName())));
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
        cloudSender.sendMessage(component);
        return Unit.INSTANCE;
    }

    private static final void registerEditGroupCommand$lambda$69$lambda$67$lambda$66(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit registerEditGroupCommand$lambda$69$lambda$67(String $setting, String $value, CommandContext $context, CloudCommandHandler this$0, Group group) {
        Group group2;
        switch ($setting) {
            case "max-players": {
                Long l = StringsKt.toLongOrNull((String)$value);
                if (l == null) {
                    CloudSender cloudSender = (CloudSender)$context.sender();
                    TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component("value", Component.text($value)), Placeholder.component("key", Component.text($setting))};
                    Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getInvalidValue(), tagResolverArray);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
                    cloudSender.sendMessage(component);
                    return Unit.INSTANCE;
                }
                group2 = Group.copy$default((Group)group, null, null, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L, (long)l, (long)0L, null, (int)895, null);
                break;
            }
            case "max-memory": {
                Long l = StringsKt.toLongOrNull((String)$value);
                if (l == null) {
                    CloudSender cloudSender = (CloudSender)$context.sender();
                    TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component("value", Component.text($value)), Placeholder.component("key", Component.text($setting))};
                    Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getInvalidValue(), tagResolverArray);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
                    cloudSender.sendMessage(component);
                    return Unit.INSTANCE;
                }
                group2 = Group.copy$default((Group)group, null, null, (long)0L, (long)l, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L, null, (int)1015, null);
                break;
            }
            case "min-memory": {
                Long l = StringsKt.toLongOrNull((String)$value);
                if (l == null) {
                    CloudSender cloudSender = (CloudSender)$context.sender();
                    TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component("value", Component.text($value)), Placeholder.component("key", Component.text($setting))};
                    Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getInvalidValue(), tagResolverArray);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
                    cloudSender.sendMessage(component);
                    return Unit.INSTANCE;
                }
                group2 = Group.copy$default((Group)group, null, null, (long)l, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L, null, (int)1019, null);
                break;
            }
            case "max-online-count": {
                Long l = StringsKt.toLongOrNull((String)$value);
                if (l == null) {
                    CloudSender cloudSender = (CloudSender)$context.sender();
                    TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component("value", Component.text($value)), Placeholder.component("key", Component.text($setting))};
                    Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getInvalidValue(), tagResolverArray);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
                    cloudSender.sendMessage(component);
                    return Unit.INSTANCE;
                }
                group2 = Group.copy$default((Group)group, null, null, (long)0L, (long)0L, (long)0L, (long)0L, (long)l, (long)0L, (long)0L, null, (int)959, null);
                break;
            }
            case "min-online-count": {
                Long l = StringsKt.toLongOrNull((String)$value);
                if (l == null) {
                    CloudSender cloudSender = (CloudSender)$context.sender();
                    TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component("value", Component.text($value)), Placeholder.component("key", Component.text($setting))};
                    Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getInvalidValue(), tagResolverArray);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
                    cloudSender.sendMessage(component);
                    return Unit.INSTANCE;
                }
                group2 = Group.copy$default((Group)group, null, null, (long)0L, (long)0L, (long)0L, (long)l, (long)0L, (long)0L, (long)0L, null, (int)991, null);
                break;
            }
            case "start-port": {
                Long l = StringsKt.toLongOrNull((String)$value);
                if (l == null) {
                    CloudSender cloudSender = (CloudSender)$context.sender();
                    TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component("value", Component.text($value)), Placeholder.component("key", Component.text($setting))};
                    Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getInvalidValue(), tagResolverArray);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
                    cloudSender.sendMessage(component);
                    return Unit.INSTANCE;
                }
                group2 = Group.copy$default((Group)group, null, null, (long)0L, (long)0L, (long)l, (long)0L, (long)0L, (long)0L, (long)0L, null, (int)1007, null);
                break;
            }
            case "server-url": {
                group2 = Group.copy$default((Group)group, null, null, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L, (Map)MapsKt.plus((Map)group.getProperties(), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"server-url", (Object)$value))), (int)511, null);
                break;
            }
            case "properties": {
                group2 = Group.copy$default((Group)group, null, null, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L, (Map)MapsKt.plus((Map)group.getProperties(), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"custom-property", (Object)$value))), (int)511, null);
                break;
            }
            default: {
                CloudSender cloudSender = (CloudSender)$context.sender();
                Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getInvalidSetting(), (TagResolver)Placeholder.component("key", Component.text($setting)));
                Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
                cloudSender.sendMessage(component);
                return Unit.INSTANCE;
            }
        }
        Group updatedGroup = group2;
        this$0.controllerApi.getGroups().updateGroup(updatedGroup).thenAccept(arg_0 -> CloudCommandHandler.registerEditGroupCommand$lambda$69$lambda$67$lambda$66(arg_0 -> CloudCommandHandler.registerEditGroupCommand$lambda$69$lambda$67$lambda$65($context, this$0, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void registerEditGroupCommand$lambda$69$lambda$68(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void registerEditGroupCommand$lambda$69(CloudCommandHandler this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object v = context.get("group");
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        String groupName = (String)v;
        Object v2 = context.get("setting");
        Intrinsics.checkNotNullExpressionValue(v2, (String)"get(...)");
        String setting = (String)v2;
        Object v3 = context.get("value");
        Intrinsics.checkNotNullExpressionValue(v3, (String)"get(...)");
        String value = (String)v3;
        this$0.controllerApi.getGroups().getGroupByName(groupName).thenAccept(arg_0 -> CloudCommandHandler.registerEditGroupCommand$lambda$69$lambda$68(arg_0 -> CloudCommandHandler.registerEditGroupCommand$lambda$69$lambda$67(setting, value, context, this$0, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final List registerEditServerCommand$lambda$73$lambda$71(List groups) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)groups);
        Iterable $this$map$iv = groups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void group;
            Group group2 = (Group)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Suggestion.suggestion(group.getName()));
        }
        return (List)destination$iv$iv;
    }

    private static final List registerEditServerCommand$lambda$73$lambda$72(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final CompletableFuture registerEditServerCommand$lambda$73(CloudCommandHandler this$0, CommandContext commandContext, CommandInput commandInput) {
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        return this$0.controllerApi.getGroups().getAllGroups().thenApply(arg_0 -> CloudCommandHandler.registerEditServerCommand$lambda$73$lambda$72(CloudCommandHandler::registerEditServerCommand$lambda$73$lambda$71, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final List registerEditServerCommand$lambda$77$lambda$75(List servers) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)servers);
        Iterable $this$map$iv = servers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void server;
            Server server2 = (Server)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Suggestion.suggestion(String.valueOf(server.getNumericalId())));
        }
        return (List)destination$iv$iv;
    }

    private static final List registerEditServerCommand$lambda$77$lambda$76(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final CompletableFuture registerEditServerCommand$lambda$77(CloudCommandHandler this$0, CommandContext commandContext, CommandInput commandInput) {
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        return this$0.controllerApi.getServers().getAllServers().thenApply(arg_0 -> CloudCommandHandler.registerEditServerCommand$lambda$77$lambda$76(CloudCommandHandler::registerEditServerCommand$lambda$77$lambda$75, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final CompletableFuture registerEditServerCommand$lambda$79(CommandContext commandContext, CommandInput commandInput) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        Iterable $this$map$iv = CollectionsKt.listOf((Object)"max-players");
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Suggestion.suggestion((String)it));
        }
        return CompletableFuture.completedFuture((List)destination$iv$iv);
    }

    private static final Unit registerEditServerCommand$lambda$84$lambda$82$lambda$80(CommandContext $context, CloudCommandHandler this$0, Server server) {
        CloudSender cloudSender = (CloudSender)$context.sender();
        TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component("group", Component.text(server.getGroup())), Placeholder.component("numericalid", Component.text(String.valueOf(server.getNumericalId())))};
        Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getServerUpdated(), tagResolverArray);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
        cloudSender.sendMessage(component);
        return Unit.INSTANCE;
    }

    private static final void registerEditServerCommand$lambda$84$lambda$82$lambda$81(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit registerEditServerCommand$lambda$84$lambda$82(String $setting, String $value, CommandContext $context, CloudCommandHandler this$0, Server server) {
        Long l;
        if (Intrinsics.areEqual((Object)$setting, (Object)"max-players")) {
            l = StringsKt.toLongOrNull((String)$value);
            if (l == null) {
                CloudSender cloudSender = (CloudSender)$context.sender();
                TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component("value", Component.text($value)), Placeholder.component("key", Component.text($setting))};
                Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getInvalidValue(), tagResolverArray);
                Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
                cloudSender.sendMessage(component);
                return Unit.INSTANCE;
            }
        } else {
            CloudSender cloudSender = (CloudSender)$context.sender();
            Component component = MiniMessage.miniMessage().deserialize(this$0.commandPlugin.getMessageConfiguration().getInvalidSetting(), (TagResolver)Placeholder.component("key", Component.text($setting)));
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
            cloudSender.sendMessage(component);
            return Unit.INSTANCE;
        }
        Server updatedServer = Server.copy$default((Server)server, null, null, null, null, (int)0, null, (long)0L, (long)0L, (long)0L, (long)l, (long)0L, null, null, null, null, (int)32255, null);
        this$0.controllerApi.getServers().updateServer(updatedServer).thenAccept(arg_0 -> CloudCommandHandler.registerEditServerCommand$lambda$84$lambda$82$lambda$81(arg_0 -> CloudCommandHandler.registerEditServerCommand$lambda$84$lambda$82$lambda$80($context, this$0, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void registerEditServerCommand$lambda$84$lambda$83(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void registerEditServerCommand$lambda$84(CloudCommandHandler this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object v = context.get("group");
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        String groupName = (String)v;
        Object v2 = context.get("id");
        Intrinsics.checkNotNullExpressionValue(v2, (String)"get(...)");
        long serverId = ((Number)v2).longValue();
        Object v3 = context.get("setting");
        Intrinsics.checkNotNullExpressionValue(v3, (String)"get(...)");
        String setting = (String)v3;
        Object v4 = context.get("value");
        Intrinsics.checkNotNullExpressionValue(v4, (String)"get(...)");
        String value = (String)v4;
        this$0.controllerApi.getServers().getServerByNumerical(groupName, serverId).thenAccept(arg_0 -> CloudCommandHandler.registerEditServerCommand$lambda$84$lambda$83(arg_0 -> CloudCommandHandler.registerEditServerCommand$lambda$84$lambda$82(setting, value, context, this$0, arg_0), arg_0));
    }
}

