/*
 * Decompiled with CFR 0.152.
 */
package com.moandjiezana.toml;

import com.moandjiezana.toml.Context;
import com.moandjiezana.toml.Identifier;
import com.moandjiezana.toml.Results;
import com.moandjiezana.toml.ValueReader;
import com.moandjiezana.toml.ValueReaders;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

class InlineTableValueReader
implements ValueReader {
    static final InlineTableValueReader INLINE_TABLE_VALUE_READER = new InlineTableValueReader();

    @Override
    public boolean canRead(String s2) {
        return s2.startsWith("{");
    }

    @Override
    public Object read(String s2, AtomicInteger sharedIndex, Context context) {
        AtomicInteger line = context.line;
        int startLine = line.get();
        int startIndex = sharedIndex.get();
        boolean inKey = true;
        boolean inValue = false;
        boolean terminated = false;
        StringBuilder currentKey = new StringBuilder();
        HashMap<String, Object> results = new HashMap<String, Object>();
        Results.Errors errors = new Results.Errors();
        int i2 = sharedIndex.incrementAndGet();
        while (sharedIndex.get() < s2.length()) {
            char c = s2.charAt(i2);
            if (inValue && !Character.isWhitespace(c)) {
                Object converted = ValueReaders.VALUE_READERS.convert(s2, sharedIndex, context.with(Identifier.from(currentKey.toString(), context)));
                if (converted instanceof Results.Errors) {
                    errors.add((Results.Errors)converted);
                    return errors;
                }
                String currentKeyTrimmed = currentKey.toString().trim();
                Object previous = results.put(currentKeyTrimmed, converted);
                if (previous != null) {
                    errors.duplicateKey(currentKeyTrimmed, context.line.get());
                    return errors;
                }
                currentKey = new StringBuilder();
                inValue = false;
            } else if (c == ',') {
                inKey = true;
                inValue = false;
                currentKey = new StringBuilder();
            } else if (c == '=') {
                inKey = false;
                inValue = true;
            } else {
                if (c == '}') {
                    terminated = true;
                    break;
                }
                if (inKey) {
                    currentKey.append(c);
                }
            }
            i2 = sharedIndex.incrementAndGet();
        }
        if (!terminated) {
            errors.unterminated(context.identifier.getName(), s2.substring(startIndex), startLine);
        }
        if (errors.hasErrors()) {
            return errors;
        }
        return results;
    }

    private InlineTableValueReader() {
    }
}

