/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.ceramicshears;

import de.cech12.ceramicshears.CommonLoader;
import de.cech12.ceramicshears.Constants;
import de.cech12.ceramicshears.item.CeramicShearsItem;
import java.util.function.Function;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="ceramicshears")
@Mod.EventBusSubscriber(modid="ceramicshears")
public class ForgeCeramicShearsMod {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"ceramicshears");
    public static final RegistryObject<Item> CLAY_SHEARS_PART = ForgeCeramicShearsMod.registerItem("clay_shears_part", Item::new);
    public static final RegistryObject<Item> CERAMIC_SHEARS_PART = ForgeCeramicShearsMod.registerItem("ceramic_shears_part", Item::new);

    private static RegistryObject<Item> registerItem(String name, Function<Item.Properties, Item> itemConstructor) {
        return ITEMS.register(name, () -> (Item)itemConstructor.apply(new Item.Properties().setId(ResourceKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)Constants.id(name)))));
    }

    public ForgeCeramicShearsMod(FMLJavaModLoadingContext context) {
        ITEMS.register(context.getModBusGroup());
        CommonLoader.init();
    }

    @SubscribeEvent
    public static void registerDispenseBehavior(FMLCommonSetupEvent event) {
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)Constants.CERAMIC_SHEARS.get()), (DispenseItemBehavior)new ShearsDispenseItemBehavior());
    }

    @SubscribeEvent
    public static void addItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept(CLAY_SHEARS_PART);
            event.accept(CERAMIC_SHEARS_PART);
        }
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(Constants.CERAMIC_SHEARS);
        }
    }

    static {
        Constants.CERAMIC_SHEARS = ForgeCeramicShearsMod.registerItem("ceramic_shears", CeramicShearsItem::new);
    }
}

