/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.ceramicshears.platform;

import de.cech12.ceramicshears.platform.services.IConfigHelper;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class NeoforgeConfigHelper
implements IConfigHelper {
    private static final ModConfigSpec SERVER_CONFIG;
    private static final ModConfigSpec.IntValue DURABILITY;

    @Override
    public void init() {
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
    }

    @Override
    public int getDurability() {
        try {
            return (Integer)DURABILITY.get();
        }
        catch (IllegalStateException ex) {
            return 179;
        }
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("Balance Options");
        DURABILITY = builder.comment("Defines the maximum durability of Ceramic Shears. (179 - default value, 0 - deactivates the durability)").defineInRange("durability", 179, 0, 10000);
        builder.pop();
        SERVER_CONFIG = builder.build();
    }
}

