/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.block;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.cell.Cell;
import com.dtteam.dynamictrees.api.cell.CellNull;
import com.dtteam.dynamictrees.api.network.Connections;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.treedata.TreePart;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.loot.DTLootParameterSets;
import com.dtteam.dynamictrees.loot.entry.SeedItemLootPoolEntry;
import com.dtteam.dynamictrees.loot.function.MultiplyByLogsCount;
import com.dtteam.dynamictrees.loot.function.MultiplyBySticksCount;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionSelectionContext;
import com.dtteam.dynamictrees.tree.ChunkTreeHelper;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictreesplus.init.DTPConfigs;
import com.dtteam.dynamictreesplus.tree.CactusSpecies;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CactusBranchBlock
extends BranchBlock {
    public static final EnumProperty<Direction> ORIGIN = EnumProperty.create((String)"origin", Direction.class, (Predicate)((com.google.common.base.Predicate)dir -> dir != Direction.UP));
    public static final EnumProperty<CactusThickness> TRUNK_TYPE = EnumProperty.create((String)"type", CactusThickness.class);
    private static final double hurtMovementDelta = 0.003;

    public CactusBranchBlock(ResourceLocation name, BlockBehaviour.Properties properties) {
        super(name, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(TRUNK_TYPE, (Comparable)((Object)CactusThickness.TRUNK))).setValue(ORIGIN, (Comparable)Direction.DOWN));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ORIGIN, TRUNK_TYPE});
    }

    public int branchSupport(BlockState blockState, BlockGetter blockAccess, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        return 0;
    }

    public boolean checkForRot(LevelAccessor level, BlockPos pos, Species species, int fertility, int radius, RandomSource rand, float chance, boolean rapid) {
        return false;
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entity) {
        boolean damage = false;
        if (((Boolean)DTPConfigs.CACTUS_PRICKLE_ON_MOVE_ONLY.get()).booleanValue() && entity instanceof LivingEntity) {
            boolean falling = entity.getDeltaMovement().y < 0.0;
            entity.setDeltaMovement(entity.getDeltaMovement().x * 0.25, entity.getDeltaMovement().y * (falling ? 0.5 : 1.0), entity.getDeltaMovement().z * 0.25);
            if (!(worldIn.isClientSide || entity.xOld == entity.getX() && entity.yOld == entity.getY() && entity.zOld == entity.getZ())) {
                double xMovement = Math.abs(entity.getX() - entity.xOld);
                double yMovement = Math.abs(entity.getY() - entity.yOld);
                double zMovement = Math.abs(entity.getZ() - entity.zOld);
                if (xMovement >= 0.003 || yMovement >= 0.003 || zMovement >= 0.003) {
                    damage = true;
                }
            }
        } else if (!(entity instanceof ItemEntity) || ((Boolean)DTPConfigs.CACTUS_KILL_ITEMS.get()).booleanValue()) {
            damage = true;
        }
        if (damage) {
            entity.hurt(worldIn.damageSources().cactus(), 1.0f);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState returnState = this.defaultBlockState();
        BlockState adjState = context.getLevel().getBlockState(context.getClickedPos().relative(context.getClickedFace().getOpposite()));
        boolean trunk = context.getClickedFace() == Direction.UP && (adjState.getBlock() != this || adjState.getValue(TRUNK_TYPE) != CactusThickness.BRANCH);
        return (BlockState)((BlockState)returnState.setValue(TRUNK_TYPE, (Comparable)((Object)(trunk ? CactusThickness.TRUNK : CactusThickness.BRANCH)))).setValue(ORIGIN, (Comparable)(context.getClickedFace() != Direction.DOWN ? context.getClickedFace().getOpposite() : Direction.DOWN));
    }

    public Cell getHydrationCell(BlockGetter blockAccess, BlockPos pos, BlockState blockState, Direction dir, LeavesProperties leavesProperties) {
        return CellNull.NULL_CELL;
    }

    protected int getCactusRadius(CactusThickness trunk) {
        switch (trunk.ordinal()) {
            default: {
                return this.getFamily().getSecondaryThickness();
            }
            case 1: {
                return this.getFamily().getPrimaryThickness();
            }
            case 2: 
        }
        return 7;
    }

    public int getRadius(BlockState blockState) {
        return blockState.getBlock() == this ? this.getCactusRadius((CactusThickness)((Object)blockState.getValue(TRUNK_TYPE))) : 0;
    }

    public int setRadius(LevelAccessor world, BlockPos pos, int radius, @Nullable Direction originDir, int flags) {
        destroyMode = DynamicTrees.DestroyMode.SET_RADIUS;
        world.setBlock(pos, (BlockState)this.getStateForRadius(radius).setValue(ORIGIN, (Comparable)Objects.requireNonNullElse(originDir, Direction.DOWN)), flags);
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
        return radius;
    }

    public int probabilityForBlock(BlockState blockState, BlockGetter blockAccess, BlockPos pos, BranchBlock from) {
        return this.isSameTree(from) ? this.getRadius(blockState) + 2 : 0;
    }

    public GrowSignal growIntoAir(Level world, BlockPos pos, GrowSignal signal) {
        Direction originDir = signal.dir.getOpposite();
        CactusThickness trunk = signal.getSpecies() instanceof CactusSpecies ? ((CactusSpecies)signal.getSpecies()).thicknessForBranchPlaced((LevelAccessor)world, pos, true) : CactusThickness.BRANCH;
        if (originDir.getAxis() != Direction.Axis.Y && (world.getBlockState(pos.above()).getBlock() == this || world.getBlockState(pos.below()).getBlock() == this)) {
            signal.success = false;
            return signal;
        }
        if (originDir == Direction.UP) {
            originDir = Direction.DOWN;
        }
        signal.success = world.setBlock(pos, (BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(TRUNK_TYPE, (Comparable)((Object)trunk))).setValue(ORIGIN, (Comparable)originDir), 2);
        signal.radius = this.getCactusRadius(trunk);
        return signal;
    }

    public GrowSignal growSignal(Level world, BlockPos pos, GrowSignal signal) {
        if (signal.step()) {
            CactusThickness newIsTrunk;
            CactusThickness isTrunk;
            Species species = signal.getSpecies();
            Direction targetDir = species.getGrowthLogicKit().selectNewDirection(new DirectionSelectionContext(world, pos, signal.getSpecies(), (BranchBlock)this, signal));
            signal.doTurn(targetDir);
            BlockPos deltaPos = pos.relative(targetDir);
            BlockState deltaState = world.getBlockState(deltaPos);
            TreePart treepart = TreeHelper.getTreePart((BlockState)deltaState);
            if (treepart == this) {
                signal = treepart.growSignal(world, deltaPos, signal);
            } else if (world.isEmptyBlock(deltaPos)) {
                signal = this.growIntoAir(world, deltaPos, signal);
            }
            BlockState thisState = world.getBlockState(pos);
            if (thisState.getBlock() == this && species instanceof CactusSpecies && (isTrunk = (CactusThickness)((Object)thisState.getValue(TRUNK_TYPE))) != (newIsTrunk = ((CactusSpecies)species).thicknessAfterGrowthSignal(world, pos, signal, isTrunk))) {
                this.setRadius((LevelAccessor)world, pos, this.getCactusRadius(newIsTrunk), (Direction)thisState.getValue(ORIGIN));
            }
        }
        return signal;
    }

    public BlockState getStateForRadius(int radius) {
        CactusThickness thickness = CactusThickness.BRANCH;
        if (radius >= this.getCactusRadius(CactusThickness.CORE)) {
            thickness = CactusThickness.CORE;
        } else if (radius >= this.getCactusRadius(CactusThickness.TRUNK)) {
            thickness = CactusThickness.TRUNK;
        }
        return (BlockState)this.defaultBlockState().setValue(TRUNK_TYPE, (Comparable)((Object)thickness));
    }

    public Connections getConnectionData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        Connections connections = new Connections();
        for (Direction dir : Direction.values()) {
            connections.setRadius(dir, this.getSideConnectionRadius((BlockGetter)world, pos, dir));
        }
        return connections;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        int thisRadius = this.getRadius(state);
        VoxelShape shape = Shapes.empty();
        int numConnections = 0;
        for (Direction dir : Direction.values()) {
            int connRadius = this.getSideConnectionRadius(worldIn, pos, dir);
            if (connRadius <= 0) continue;
            ++numConnections;
            double radius = (double)Mth.clamp((int)connRadius, (int)1, (int)thisRadius) / 16.0;
            double gap = 0.5 - radius;
            AABB aabb = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).inflate(radius);
            aabb = aabb.move((double)dir.getStepX() * gap, (double)dir.getStepY() * gap, (double)dir.getStepZ() * gap).move(0.5, 0.5, 0.5);
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.create((AABB)aabb), (BooleanOp)BooleanOp.OR);
        }
        if (state.getValue(TRUNK_TYPE) == CactusThickness.BRANCH && numConnections == 1 && ((Direction)state.getValue(ORIGIN)).getAxis().isHorizontal()) {
            double radius = (double)Mth.clamp((int)this.getCactusRadius(CactusThickness.BRANCH), (int)1, (int)thisRadius) / 16.0;
            double gap = 0.5 - radius;
            AABB aabb = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).inflate(radius);
            aabb = aabb.move((double)Direction.UP.getStepX() * gap, (double)Direction.UP.getStepY() * gap, (double)Direction.UP.getStepZ() * gap).move(0.5, 0.5, 0.5);
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.create((AABB)aabb), (BooleanOp)BooleanOp.OR);
        }
        double min = 0.5 - (double)thisRadius / 16.0;
        double max = 0.5 + (double)thisRadius / 16.0;
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.create((AABB)new AABB(min, min, min, max, max, max)), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public int getRadiusForConnection(BlockState blockState, BlockGetter blockAccess, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return this.getRadius(blockState);
    }

    protected int getSideConnectionRadius(BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockPos deltaPos = pos.relative(side);
        BlockState otherState = ChunkTreeHelper.getStateSafe((BlockGetter)blockAccess, (BlockPos)deltaPos);
        BlockState state = ChunkTreeHelper.getStateSafe((BlockGetter)blockAccess, (BlockPos)pos);
        if (otherState == null || state == null || state.getBlock() != this) {
            return 0;
        }
        if (otherState.getBlock() == this && (otherState.getValue(ORIGIN) == side.getOpposite() || state.getValue(ORIGIN) == side)) {
            return Math.min(this.getCactusRadius((CactusThickness)((Object)state.getValue(TRUNK_TYPE))), this.getCactusRadius((CactusThickness)((Object)otherState.getValue(TRUNK_TYPE))));
        }
        if (side == Direction.DOWN && state.getValue(ORIGIN) == side && (otherState.getBlock() == this || otherState.getBlock() instanceof SoilBlock)) {
            return this.getCactusRadius((CactusThickness)((Object)state.getValue(TRUNK_TYPE)));
        }
        return 0;
    }

    public MapSignal analyse(BlockState blockState, LevelAccessor world, BlockPos pos, @Nullable Direction fromDir, MapSignal signal) {
        if (signal.depth++ < 32) {
            BlockState state = world.getBlockState(pos);
            signal.run(blockState, world, pos, fromDir);
            for (Direction dir : Direction.values()) {
                if (dir == fromDir) continue;
                BlockPos deltaPos = pos.relative(dir);
                BlockState deltaState = world.getBlockState(deltaPos);
                if (deltaState.getBlock() == this && deltaState.getValue(ORIGIN) == dir.getOpposite()) {
                    signal = ((TreePart)deltaState.getBlock()).analyse(deltaState, world, deltaPos, dir.getOpposite(), signal);
                } else if (state.getBlock() == this && state.getValue(ORIGIN) == dir) {
                    signal = TreeHelper.getTreePart((BlockState)deltaState).analyse(deltaState, world, deltaPos, dir.getOpposite(), signal);
                }
                if (!signal.foundRoot || signal.localRootDir != null || fromDir != null) continue;
                signal.localRootDir = dir;
            }
            signal.returnRun(blockState, world, pos, fromDir);
        } else {
            BlockState state = world.getBlockState(pos);
            if (state.getBlock() instanceof BranchBlock) {
                BranchBlock branch = (BranchBlock)state.getBlock();
                branch.breakDeliberate(world, pos, DynamicTrees.DestroyMode.OVERFLOW);
            }
            signal.overflow = true;
        }
        --signal.depth;
        return signal;
    }

    public LootTable.Builder createBranchDrops(HolderLookup.Provider registries) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)this.getPrimitiveLog().get())).apply(MultiplyByLogsCount.multiplyByLogsCount()).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)SeedItemLootPoolEntry.lootTableSeedItem().apply(MultiplyBySticksCount.multiplyBySticksCount()).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()))).setParamSet(DTLootParameterSets.BRANCHES);
    }

    public static enum CactusThickness implements StringRepresentable
    {
        BRANCH("branch", 4),
        TRUNK("trunk", 5),
        CORE("core", 7);

        final String name;
        final int radius;

        private CactusThickness(String name, int radius) {
            this.name = name;
            this.radius = radius;
        }

        public int getRadius() {
            return this.radius;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

