/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.block;

import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.fruit.Fruit;
import com.dtteam.dynamictrees.block.fruit.FruitBlock;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictreesplus.block.CactusBranchBlock;
import com.dtteam.dynamictreesplus.block.CactusFruitBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CactusFruit
extends Fruit {
    public static final TypedRegistry.EntryType<Fruit> TYPE = TypedRegistry.newType(CactusFruit::new);

    public CactusFruit(ResourceLocation registryName) {
        super(registryName);
    }

    protected FruitBlock createBlock(BlockBehaviour.Properties properties) {
        return new CactusFruitBlock(properties, this);
    }

    public void place(LevelAccessor world, BlockPos pos, @Nullable Float seasonValue) {
        BlockState state = this.getStateForAge(0);
        state = this.offsetBlockIfOnTop(world, pos, state);
        world.setBlock(pos, state, 3);
    }

    public void placeDuringWorldGen(LevelAccessor world, BlockPos pos, @Nullable Float seasonValue) {
        BlockState state = this.getStateForAge(this.getAgeForWorldGen(world, pos, seasonValue));
        state = this.offsetBlockIfOnTop(world, pos, state);
        world.setBlock(pos, state, 3);
    }

    private BlockState offsetBlockIfOnTop(LevelAccessor world, BlockPos pos, BlockState inState) {
        BlockState downState = world.getBlockState(pos.below());
        BranchBlock downBranch = TreeHelper.getBranch((BlockState)world.getBlockState(pos.below()));
        if (downBranch instanceof CactusBranchBlock && downState.getValue(CactusBranchBlock.ORIGIN) == Direction.DOWN) {
            return (BlockState)inState.setValue((Property)CactusFruitBlock.OFFSET, (Comparable)Boolean.valueOf(true));
        }
        return inState;
    }
}

