/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.block.mushroom;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.lazyvalue.MutableLazyValue;
import com.dtteam.dynamictrees.api.registry.RegistryEntry;
import com.dtteam.dynamictrees.api.registry.RegistryHandler;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.loot.DTLootContextParams;
import com.dtteam.dynamictrees.loot.DTLootParameterSets;
import com.dtteam.dynamictrees.loot.LootTableSupplier;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.treepack.Resettable;
import com.dtteam.dynamictrees.utility.Optionals;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapBlock;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.dtteam.dynamictreesplus.data.CapCenterStateGenerator;
import com.dtteam.dynamictreesplus.data.CapStateGenerator;
import com.dtteam.dynamictreesplus.data.DTPLootTableHandler;
import com.dtteam.dynamictreesplus.tree.HugeMushroomSpecies;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;

public class CapProperties
extends RegistryEntry<CapProperties>
implements Resettable<CapProperties> {
    public static final Codec<CapProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf(TypedRegistry.RESOURCE_LOCATION.toString()).forGetter(RegistryEntry::getRegistryName)).apply((Applicative)instance, CapProperties::new));
    public static final CapProperties NULL = ((CapProperties)new CapProperties(){

        @Override
        public Family getFamily() {
            return Family.NULL_FAMILY;
        }

        @Override
        public BlockState getPrimitiveCap() {
            return Blocks.AIR.defaultBlockState();
        }

        @Override
        public ItemStack getPrimitiveCapItemStack() {
            return ItemStack.EMPTY;
        }

        @Override
        public CapProperties setDynamicCapState(BlockState state, boolean center) {
            return this;
        }

        @Override
        public BlockState getDynamicCapState(boolean center) {
            return Blocks.AIR.defaultBlockState();
        }

        @Override
        public BlockState getDynamicCapState(int distance) {
            return Blocks.AIR.defaultBlockState();
        }

        @Override
        public int getFlammability() {
            return 0;
        }

        @Override
        public int getFireSpreadSpeed() {
            return 0;
        }
    }.setRegistryName(DynamicTrees.NULL)).setBlockRegistryName(DynamicTrees.NULL);
    public static final TypedRegistry<CapProperties> REGISTRY = new TypedRegistry(CapProperties.class, (RegistryEntry)NULL, new TypedRegistry.EntryType(CODEC));
    protected BlockState primitiveCap;
    protected Family family;
    protected BlockState[] dynamicMushroomBlockDistanceStates = new BlockState[9];
    protected BlockState dynamicMushroomCenterBlock;
    protected int flammability = 0;
    protected int fireSpreadSpeed = 0;
    protected VoxelShape ageZeroShape = Shapes.block();
    private ResourceLocation blockRegistryName;
    private ResourceLocation centerBlockRegistryName;
    private Item mushroomItem;
    private final LootTableSupplier blockLootTableSupplier;
    private final LootTableSupplier lootTableSupplier;
    protected final MutableLazyValue<Generator<DTDataProvider.BlockState, CapProperties>> capStateGenerator = MutableLazyValue.supplied(CapStateGenerator::new);
    protected final MutableLazyValue<Generator<DTDataProvider.BlockState, CapProperties>> capCenterStateGenerator = MutableLazyValue.supplied(CapCenterStateGenerator::new);
    private boolean generateFaceModels = false;
    protected HashMap<String, ResourceLocation> textureOverrides = new HashMap();
    protected HashMap<String, ResourceLocation> modelOverrides = new HashMap();
    public static final String OUTSIDE_FACE = "outside_face";
    public static final String INSIDE_FACE = "inside_face";
    public static final String FACE = "face";
    public static final String CAP_CENTER_AGE_0_PARENT = "cap_center_age_0_parent";

    private CapProperties() {
        this.blockLootTableSupplier = new LootTableSupplier("null/", DynamicTrees.NULL);
        this.lootTableSupplier = new LootTableSupplier("null/", DynamicTrees.NULL);
    }

    public CapProperties(ResourceLocation registryName) {
        this(null, registryName);
    }

    public CapProperties(@Nullable BlockState primitiveCap, ResourceLocation registryName) {
        this.family = Family.NULL_FAMILY;
        this.primitiveCap = primitiveCap != null ? primitiveCap : Blocks.AIR.defaultBlockState();
        this.setRegistryName(registryName);
        this.centerBlockRegistryName = ResourceLocationUtils.suffix((ResourceLocation)registryName, (String)this.getCenterBlockRegistryNameSuffix());
        this.blockRegistryName = ResourceLocationUtils.suffix((ResourceLocation)registryName, (String)this.getBlockRegistryNameSuffix());
        this.blockLootTableSupplier = new LootTableSupplier("blocks/", this.blockRegistryName);
        this.lootTableSupplier = new LootTableSupplier("trees/mushroom_caps/", registryName);
    }

    public BlockState getPrimitiveCap() {
        return this.primitiveCap;
    }

    public Optional<Block> getPrimitiveCapBlock() {
        return Optionals.ofBlock(this.primitiveCap == null ? null : this.primitiveCap.getBlock());
    }

    public void setPrimitiveCap(Block primitiveCap) {
        if (this.primitiveCap == null || primitiveCap != this.primitiveCap.getBlock()) {
            this.primitiveCap = primitiveCap.defaultBlockState();
        }
    }

    public ItemStack getPrimitiveCapItemStack() {
        return new ItemStack((ItemLike)Item.BY_BLOCK.get(this.getPrimitiveCap().getBlock()));
    }

    public Family getFamily() {
        return this.family;
    }

    public CapProperties setFamily(Family family) {
        this.family = family;
        if (family.isFireProof()) {
            this.flammability = 0;
            this.fireSpreadSpeed = 0;
        }
        return this;
    }

    public int getFlammability() {
        return this.flammability;
    }

    public void setFlammability(int flammability) {
        this.flammability = flammability;
    }

    public int getFireSpreadSpeed() {
        return this.fireSpreadSpeed;
    }

    public void setFireSpreadSpeed(int fireSpreadSpeed) {
        this.fireSpreadSpeed = fireSpreadSpeed;
    }

    public BlockBehaviour.Properties getDefaultBlockProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(0.2f);
    }

    public int getMaxAge(HugeMushroomSpecies species) {
        return species.getMushroomShapeKit().getMaxCapAge();
    }

    public void setAgeZeroShape(VoxelShape ageZeroShape) {
        this.ageZeroShape = ageZeroShape;
    }

    public VoxelShape getAgeZeroShape() {
        return this.ageZeroShape;
    }

    public ResourceLocation getBlockRegistryName() {
        return this.blockRegistryName;
    }

    public ResourceLocation getCenterBlockRegistryName() {
        return this.centerBlockRegistryName;
    }

    public CapProperties setBlockRegistryName(ResourceLocation blockRegistryName) {
        this.blockRegistryName = blockRegistryName;
        return this;
    }

    public CapProperties setCenterBlockRegistryName(ResourceLocation blockRegistryName) {
        this.centerBlockRegistryName = blockRegistryName;
        return this;
    }

    protected String getBlockRegistryNameSuffix() {
        return "_cap";
    }

    protected String getCenterBlockRegistryNameSuffix() {
        return "_cap_center";
    }

    public Optional<DynamicCapBlock> getDynamicCapBlock() {
        Block block = this.getDynamicCapState(false).getBlock();
        return Optional.ofNullable(block instanceof DynamicCapBlock ? (DynamicCapBlock)block : null);
    }

    public Optional<DynamicCapCenterBlock> getDynamicCapCenterBlock() {
        Block block = this.getDynamicCapState(true).getBlock();
        return Optional.ofNullable(block instanceof DynamicCapCenterBlock ? (DynamicCapCenterBlock)block : null);
    }

    protected DynamicCapBlock createDynamicCap(BlockBehaviour.Properties properties) {
        return new DynamicCapBlock(this, properties);
    }

    protected DynamicCapCenterBlock createDynamicCapCenter(BlockBehaviour.Properties properties) {
        return new DynamicCapCenterBlock(this, properties);
    }

    public void generateDynamicCapBlocks(BlockBehaviour.Properties properties) {
        RegistryHandler.addBlock((ResourceLocation)this.blockRegistryName, () -> this.createDynamicCap(properties));
        RegistryHandler.addBlock((ResourceLocation)this.centerBlockRegistryName, () -> this.createDynamicCapCenter(properties));
    }

    public CapProperties setDynamicCapState(BlockState state, boolean center) {
        if (center) {
            this.dynamicMushroomCenterBlock = state;
            return this;
        }
        this.dynamicMushroomBlockDistanceStates[0] = Blocks.AIR.defaultBlockState();
        for (int i = 1; i <= 8; ++i) {
            this.dynamicMushroomBlockDistanceStates[i] = (BlockState)state.setValue((Property)DynamicCapBlock.DISTANCE, (Comparable)Integer.valueOf(i));
        }
        return this;
    }

    public BlockState getDynamicCapState(boolean center) {
        return this.getDynamicCapState(center, 1);
    }

    public BlockState getDynamicCapState(boolean center, int prop) {
        if (center) {
            return (BlockState)this.dynamicMushroomCenterBlock.setValue((Property)DynamicCapCenterBlock.AGE, (Comparable)Integer.valueOf(Math.min(prop, 8)));
        }
        return this.getDynamicCapState(prop);
    }

    public BlockState getDynamicCapState(int distance) {
        return Optional.ofNullable(this.dynamicMushroomBlockDistanceStates[Mth.clamp((int)distance, (int)0, (int)8)]).orElse(Blocks.AIR.defaultBlockState());
    }

    public BlockState getDynamicCapState(int distance, boolean[] directions) {
        return DynamicCapBlock.setDirectionValues(this.getDynamicCapState(distance), directions);
    }

    public boolean isPartOfCap(BlockState state) {
        DynamicCapBlock capBlock = this.getDynamicCapBlock().orElse(null);
        DynamicCapCenterBlock capCenterBlock = this.getDynamicCapCenterBlock().orElse(null);
        if (capBlock == null || capCenterBlock == null) {
            return false;
        }
        return state.is((Block)capBlock) || state.is((Block)capCenterBlock);
    }

    public ParticleOptions sporeParticleType(BlockState state, Level level, BlockPos pos, RandomSource random) {
        return ParticleTypes.WHITE_ASH;
    }

    public Vec3 sporeParticleSpeed(BlockState state, Level level, BlockPos pos, RandomSource random) {
        return new Vec3(1.0, 0.0, 1.0);
    }

    public final Item getMushroomItem() {
        if (this.mushroomItem == null) {
            LogManager.getLogger().warn("Invoked too early or item was not set on \"" + String.valueOf(this.getRegistryName()) + "\".");
            return Items.AIR;
        }
        return this.mushroomItem;
    }

    public void setMushroomItem(Item mushroomItem) {
        this.mushroomItem = mushroomItem;
    }

    public ResourceLocation getBlockLootTableName() {
        return this.blockLootTableSupplier.getName();
    }

    public boolean shouldGenerateBlockDrops() {
        return this.shouldGenerateDrops();
    }

    public LootTable.Builder createBlockDrops(HolderLookup.Provider registries) {
        if (this.getPrimitiveCapBlock().isPresent()) {
            return DTPLootTableHandler.createCapBlockDrops(this.primitiveCap.getBlock(), this.getMushroomItem(), -6, 2, registries);
        }
        return DTPLootTableHandler.createCapDrops(this.primitiveCap.getBlock(), this.getMushroomItem(), LootContextParamSets.BLOCK, registries);
    }

    public ResourceLocation getLootTableName() {
        return this.lootTableSupplier.getName();
    }

    public LootTable getLootTable(ReloadableServerRegistries.Holder lootTables, Species species) {
        return this.lootTableSupplier.get(lootTables, species);
    }

    public boolean shouldGenerateDrops() {
        return this.getPrimitiveCapBlock().isPresent();
    }

    public LootTable.Builder createDrops(HolderLookup.Provider registries) {
        return DTPLootTableHandler.createCapDrops(this.primitiveCap.getBlock(), this.getMushroomItem(), DTLootParameterSets.LEAVES, registries);
    }

    public List<ItemStack> getDrops(Level level, BlockPos pos, ItemStack tool, Species species) {
        if (level.isClientSide) {
            return Collections.emptyList();
        }
        return this.getLootTable(Objects.requireNonNull(level.getServer()).reloadableRegistries(), species).getRandomItems(this.createLootParams(level, pos, tool, species));
    }

    private LootParams createLootParams(Level level, BlockPos pos, ItemStack tool, Species species) {
        return new LootParams.Builder(LevelContext.getServerLevelOrThrow((LevelAccessor)level)).withParameter(LootContextParams.BLOCK_STATE, (Object)level.getBlockState(pos)).withParameter(DTLootContextParams.SPECIES, (Object)species).withParameter(DTLootContextParams.SEASONAL_SEED_DROP_FACTOR, (Object)Float.valueOf(species.seasonalSeedDropFactor(LevelContext.create((LevelAccessor)level), pos))).withParameter(LootContextParams.TOOL, (Object)tool).create(DTLootParameterSets.LEAVES);
    }

    public int getRadiusForConnection(BlockState state, BlockGetter blockAccess, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        if (from.getFamily() != this.family) {
            return 0;
        }
        return fromRadius;
    }

    public void generateStateData(DTDataProvider.BlockState provider) {
        ((Generator)this.capStateGenerator.get()).generate((DTDataProvider)provider, (Object)this);
        ((Generator)this.capCenterStateGenerator.get()).generate((DTDataProvider)provider, (Object)this);
    }

    public String getCapCenterAgeZeroModelName() {
        return "block/mushroom/" + this.centerBlockRegistryName.getPath() + "_age0";
    }

    public String getCapFaceModelName() {
        return "block/mushroom/" + this.blockRegistryName.getPath();
    }

    public String getCapInsideFaceModelName() {
        return "block/mushroom/" + this.blockRegistryName.getPath() + "_inside";
    }

    public ResourceLocation getCapCenterAgeZeroModelParent() {
        return this.getModelPath(CAP_CENTER_AGE_0_PARENT).orElse(ResourceLocation.parse((String)"block/cube_bottom_top"));
    }

    public ResourceLocation getFaceModelParent() {
        return this.getModelPath(FACE).orElse(ResourceLocation.parse((String)"block/template_single_face"));
    }

    public void setGenerateFaceModels(boolean generateFaceModels) {
        this.generateFaceModels = generateFaceModels;
    }

    public boolean shouldGenerateFaceModels() {
        return this.generateFaceModels;
    }

    public void addCapCenterAgeZeroTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation outsideTextureLocation, ResourceLocation insideTextureLocation) {
        ResourceLocation outLoc = this.getTexturePath(OUTSIDE_FACE).orElse(outsideTextureLocation);
        ResourceLocation inLoc = this.getTexturePath(INSIDE_FACE).orElse(insideTextureLocation);
        textureConsumer.accept("top", outLoc);
        textureConsumer.accept("bottom", inLoc);
        textureConsumer.accept("side", outLoc);
    }

    public void addCapFaceTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation textureLocation, boolean isInside) {
        ResourceLocation faceLoc = this.getTexturePath(isInside ? INSIDE_FACE : OUTSIDE_FACE).orElse(textureLocation);
        textureConsumer.accept("texture", faceLoc);
    }

    public void setTextureOverrides(Map<String, ResourceLocation> textureOverrides) {
        this.textureOverrides.putAll(textureOverrides);
    }

    public void setModelOverrides(Map<String, ResourceLocation> modelOverrides) {
        this.modelOverrides.putAll(modelOverrides);
    }

    public Optional<ResourceLocation> getTexturePath(String key) {
        return Optional.ofNullable(this.textureOverrides.getOrDefault(key, null));
    }

    public Optional<ResourceLocation> getModelPath(String key) {
        return Optional.ofNullable(this.modelOverrides.getOrDefault(key, null));
    }
}

