/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.block.mushroom;

import com.dtteam.dynamictrees.api.cell.Cell;
import com.dtteam.dynamictrees.api.cell.CellNull;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.treedata.TreePart;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictreesplus.block.mushroom.CapProperties;
import com.dtteam.dynamictreesplus.block.mushroom.UpdatesSurroundNeighbors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DynamicCapBlock
extends HugeMushroomBlock
implements TreePart,
UpdatesSurroundNeighbors {
    public static final IntegerProperty DISTANCE = IntegerProperty.create((String)"distance", (int)1, (int)8);
    public CapProperties properties = CapProperties.NULL;

    public DynamicCapBlock(CapProperties capProperties, BlockBehaviour.Properties properties) {
        this(properties);
        this.setProperties(capProperties);
        capProperties.setDynamicCapState(this.defaultBlockState(), false);
    }

    public DynamicCapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(1))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)UP, (Comparable)Boolean.valueOf(true))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{DISTANCE, UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public void setProperties(CapProperties properties) {
        this.properties = properties;
    }

    public CapProperties getProperties(BlockState blockState) {
        return this.properties;
    }

    public Cell getHydrationCell(BlockGetter level, BlockPos pos, BlockState state, Direction dir, LeavesProperties leavesProperties) {
        return CellNull.NULL_CELL;
    }

    public int probabilityForBlock(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from) {
        return from.getFamily() == this.getFamily(state, level, pos) ? 2 : 0;
    }

    public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return 0;
    }

    public int getRadius(BlockState state) {
        return 0;
    }

    public boolean shouldAnalyse(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public MapSignal analyse(BlockState state, LevelAccessor level, BlockPos pos, @Nullable Direction fromDir, MapSignal signal) {
        return signal;
    }

    public Family getFamily(BlockState state, BlockGetter level, BlockPos pos) {
        return this.properties.getFamily();
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getProperties(level.getBlockState(pos)).getFlammability();
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getProperties(level.getBlockState(pos)).getFireSpreadSpeed();
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getFlammability(state, level, pos, face) > 0 || face == Direction.UP;
    }

    public int branchSupport(BlockState state, BlockGetter level, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        return 0;
    }

    public TreePart.TreePartType getTreePartType() {
        return TreePart.TreePartType.OTHER;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return this.getProperties(state).getPrimitiveCapItemStack();
    }

    public static BlockState setDirectionValues(BlockState state, boolean[] directions) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)DOWN, (Comparable)Boolean.valueOf(directions[0]))).setValue((Property)UP, (Comparable)Boolean.valueOf(directions[1]))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(directions[2]))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(directions[3]))).setValue((Property)WEST, (Comparable)Boolean.valueOf(directions[4]))).setValue((Property)EAST, (Comparable)Boolean.valueOf(directions[5]));
    }

    public static boolean[] getDirectionValues(BlockState state) {
        if (state.getBlock() instanceof HugeMushroomBlock) {
            return new boolean[]{(Boolean)state.getValue((Property)DOWN), (Boolean)state.getValue((Property)UP), (Boolean)state.getValue((Property)NORTH), (Boolean)state.getValue((Property)SOUTH), (Boolean)state.getValue((Property)WEST), (Boolean)state.getValue((Property)EAST)};
        }
        return new boolean[6];
    }

    public GrowSignal growSignal(Level level, BlockPos pos, GrowSignal signal) {
        return signal;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (random.nextInt(50) == 0 && level.isEmptyBlock(pos.below())) {
            Vec3 vec = this.properties.sporeParticleSpeed(state, level, pos, random);
            level.addParticle(this.properties.sporeParticleType(state, level, pos, random), (double)pos.getX() + random.nextDouble(), (double)pos.getY() - 0.1, (double)pos.getZ() + random.nextDouble(), vec.x, vec.y, vec.z);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level blockgetter = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DOWN, (Comparable)Boolean.valueOf(!this.properties.isPartOfCap(blockgetter.getBlockState(blockpos.below()))))).setValue((Property)UP, (Comparable)Boolean.valueOf(!this.properties.isPartOfCap(blockgetter.getBlockState(blockpos.above()))))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(!this.properties.isPartOfCap(blockgetter.getBlockState(blockpos.north()))))).setValue((Property)EAST, (Comparable)Boolean.valueOf(!this.properties.isPartOfCap(blockgetter.getBlockState(blockpos.east()))))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(!this.properties.isPartOfCap(blockgetter.getBlockState(blockpos.south()))))).setValue((Property)WEST, (Comparable)Boolean.valueOf(!this.properties.isPartOfCap(blockgetter.getBlockState(blockpos.west()))));
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return this.properties.isPartOfCap(pFacingState) ? (BlockState)pState.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(pFacing), (Comparable)Boolean.valueOf(false)) : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean destroyed = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        this.updateNeighborsSurround(level, pos, DynamicCapBlock.class);
        return destroyed;
    }

    public void neighborChanged(BlockState pState, Level level, BlockPos pos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        level.scheduleTick(pos, pBlock, 0);
        super.neighborChanged(pState, level, pos, pBlock, pFromPos, pIsMoving);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.getBlockState(pos).getBlock() != this) {
            return;
        }
        int dist = (Integer)state.getValue((Property)DISTANCE);
        boolean supportFound = false;
        for (BlockPos offPos : BlockPos.withinManhattan((BlockPos)pos, (int)1, (int)1, (int)1)) {
            BlockState offsetState;
            if (offPos == pos || (!(offsetState = level.getBlockState(offPos)).hasProperty((Property)DISTANCE) || (Integer)offsetState.getValue((Property)DISTANCE) != dist - 1) && (dist != 1 || offsetState.getBlock() != this.properties.getDynamicCapCenterBlock().orElse(null))) continue;
            supportFound = true;
            break;
        }
        if (!supportFound) {
            level.destroyBlock(pos, true);
            this.updateNeighborsSurround((Level)level, pos, DynamicCapBlock.class);
            return;
        }
        super.tick(state, level, pos, random);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(level, state, pos, entity, fallDistance * 0.5f);
    }

    public void updateEntityAfterFallOn(BlockGetter level, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(level, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        if (vec3.y < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.setDeltaMovement(vec3.x, -vec3.y * (double)0.66f * d0, vec3.z);
        }
    }
}

