/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.block.mushroom;

import com.dtteam.dynamictrees.api.cell.Cell;
import com.dtteam.dynamictrees.api.cell.CellNull;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.treedata.TreePart;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.data.tags.DTBlockTags;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.systems.poissondisc.Vec2i;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictreesplus.block.mushroom.CapProperties;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapBlock;
import com.dtteam.dynamictreesplus.block.mushroom.UpdatesSurroundNeighbors;
import com.dtteam.dynamictreesplus.systems.mushroomlogic.MushroomCapDisc;
import com.dtteam.dynamictreesplus.systems.mushroomlogic.context.MushroomCapContext;
import com.dtteam.dynamictreesplus.tree.HugeMushroomSpecies;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DynamicCapCenterBlock
extends Block
implements TreePart,
UpdatesSurroundNeighbors {
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)8);
    public CapProperties properties = CapProperties.NULL;

    public DynamicCapCenterBlock(CapProperties capProperties, BlockBehaviour.Properties properties) {
        this(properties);
        this.setProperties(capProperties);
        capProperties.setDynamicCapState(this.defaultBlockState(), true);
    }

    public DynamicCapCenterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{AGE});
    }

    public void setProperties(CapProperties properties) {
        this.properties = properties;
    }

    public CapProperties getProperties(BlockState blockState) {
        return this.properties;
    }

    public Cell getHydrationCell(BlockGetter level, BlockPos pos, BlockState state, Direction dir, LeavesProperties leavesProperties) {
        return CellNull.NULL_CELL;
    }

    public int probabilityForBlock(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from) {
        return from.getFamily() == this.getFamily(state, level, pos) ? 2 : 0;
    }

    public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return this.properties.getRadiusForConnection(state, level, pos, from, side, fromRadius);
    }

    public int getRadius(BlockState state) {
        return 0;
    }

    public boolean shouldAnalyse(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public MapSignal analyse(BlockState state, LevelAccessor level, BlockPos pos, @Nullable Direction fromDir, MapSignal signal) {
        return signal;
    }

    public Family getFamily(BlockState state, BlockGetter level, BlockPos pos) {
        return this.properties.getFamily();
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getProperties(level.getBlockState(pos)).getFlammability();
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getProperties(level.getBlockState(pos)).getFireSpreadSpeed();
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getFlammability(state, level, pos, face) > 0 || face == Direction.UP;
    }

    public int branchSupport(BlockState state, BlockGetter level, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        return branch.getFamily() == this.getFamily(state, level, pos) ? BranchBlock.setSupport((int)0, (int)2) : 0;
    }

    public TreePart.TreePartType getTreePartType() {
        return TreePart.TreePartType.OTHER;
    }

    public BlockState getCapBlockStateForPlacement(LevelAccessor level, BlockPos pos, int age, BlockState cap, boolean worldGen) {
        if (cap.hasProperty((Property)AGE)) {
            return (BlockState)cap.setValue((Property)AGE, (Comparable)Integer.valueOf(age));
        }
        return cap;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return this.getProperties(state).getPrimitiveCapItemStack();
    }

    public static int getCapAge(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof DynamicCapCenterBlock) {
            return (Integer)state.getValue((Property)AGE);
        }
        return -1;
    }

    public GrowSignal growSignal(Level level, BlockPos pos, GrowSignal signal) {
        Species species = signal.getSpecies();
        if (!(species instanceof HugeMushroomSpecies)) {
            return signal;
        }
        HugeMushroomSpecies species2 = (HugeMushroomSpecies)species;
        if (signal.step()) {
            int age;
            BlockState thisState = level.getBlockState(pos);
            int n = age = thisState.hasProperty((Property)AGE) ? (Integer)thisState.getValue((Property)AGE) : 0;
            if (age != 0 && level.getRandom().nextFloat() < species2.getChanceToAge()) {
                this.tryGrowCap(level, this.properties, age, signal, pos, pos, true);
            } else {
                this.branchOut(level, pos, signal, age);
            }
        }
        return signal;
    }

    public GrowSignal branchOut(Level level, BlockPos pos, GrowSignal signal, int age) {
        Species species = signal.getSpecies();
        if (!(species instanceof HugeMushroomSpecies)) {
            return signal;
        }
        HugeMushroomSpecies species2 = (HugeMushroomSpecies)species;
        CapProperties capProperties = species2.getCapProperties();
        if (BranchBlock.isNextToBranch((Level)level, (BlockPos)pos, (Direction)signal.dir.getOpposite())) {
            signal.success = false;
            return signal;
        }
        boolean couldGrow = this.tryGrowCap(level, capProperties, age, signal, pos.relative(signal.dir), pos, false);
        if (couldGrow) {
            Family family = species2.getFamily();
            BlockState capCenter = level.getBlockState(pos.offset(signal.dir.getNormal()));
            int thickness = family.getPrimaryThickness() + (capCenter.hasProperty((Property)AGE) ? (Integer)capCenter.getValue((Property)AGE) : 0);
            family.getBranchForPlacement((LevelAccessor)level, (Species)species2, pos).ifPresent(branch -> branch.setRadius((LevelAccessor)level, pos, Math.min(thickness, family.getMaxBranchRadius()), null));
            signal.radius = Math.min(thickness + 1, family.getMaxBranchRadius());
        }
        signal.success = couldGrow;
        return signal;
    }

    public boolean tryGrowCap(Level level, CapProperties capProp, int currentAge, GrowSignal signal, BlockPos pos, BlockPos previousPos, boolean forceAge) {
        Species species = signal.getSpecies();
        if (!(species instanceof HugeMushroomSpecies)) {
            return false;
        }
        HugeMushroomSpecies species2 = (HugeMushroomSpecies)species;
        if (level.isEmptyBlock(pos)) {
            int age = currentAge;
            if (currentAge == 0) {
                age = 1;
            } else if (forceAge || level.getRandom().nextFloat() < species2.getChanceToAge()) {
                age = Math.min(age + 1, this.properties.getMaxAge(species2));
            }
            level.setBlock(pos, this.getCapBlockStateForPlacement((LevelAccessor)level, pos, age == 0 ? 1 : age, capProp.getDynamicCapState(true), false), 2);
            if (age != currentAge) {
                this.ageBranchUnderCap(level, pos, signal, currentAge);
            }
            if (!(signal.getSpecies() instanceof HugeMushroomSpecies)) {
                return false;
            }
            this.generateCap(age, level, (HugeMushroomSpecies)signal.getSpecies(), pos, previousPos, currentAge, signal.rootPos);
            return true;
        }
        TreePart treePart = TreeHelper.getTreePart((BlockState)level.getBlockState(pos));
        return treePart instanceof DynamicCapCenterBlock;
    }

    protected void ageBranchUnderCap(Level level, BlockPos pos, GrowSignal signal, int currentAge) {
        Species species = signal.getSpecies();
        Family family = species.getFamily();
        int thickness = Math.min(species.getFamily().getPrimaryThickness() + currentAge, species.getMaxBranchRadius());
        BlockPos branchPos = pos.offset(signal.dir.getOpposite().getNormal());
        family.getBranchForPlacement((LevelAccessor)level, signal.getSpecies(), branchPos).ifPresent(branch -> branch.setRadius((LevelAccessor)level, branchPos, thickness, null));
        signal.radius = Math.min(thickness + 1, species.getMaxBranchRadius());
    }

    protected void generateCap(int newAge, Level pLevel, HugeMushroomSpecies species, BlockPos newPos, BlockPos currentPos, int currentAge, BlockPos rootPos) {
        DynamicCapBlock capBlock = this.properties.getDynamicCapBlock().orElse(null);
        if (capBlock == null) {
            return;
        }
        if (currentPos != newPos || currentAge != newAge) {
            species.getMushroomShapeKit().clearMushroomCap(new MushroomCapContext((LevelAccessor)pLevel, currentPos, species, currentAge));
        }
        species.getMushroomShapeKit().generateMushroomCap(new MushroomCapContext((LevelAccessor)pLevel, newPos, species, newAge));
    }

    public void clearRing(LevelAccessor level, BlockPos pos, int radius) {
        List<Vec2i> ring = MushroomCapDisc.getPrecomputedRing(radius);
        for (Vec2i vec : ring) {
            BlockPos ringPos = new BlockPos(pos.getX() + vec.x, pos.getY(), pos.getZ() + vec.z);
            if (!this.properties.isPartOfCap(level.getBlockState(ringPos))) continue;
            level.setBlock(ringPos, Blocks.AIR.defaultBlockState(), 2);
        }
    }

    public boolean placeRing(LevelAccessor level, BlockPos pos, int radius, int step, boolean yMoved, boolean negFactor) {
        List<Vec2i> ring = MushroomCapDisc.getPrecomputedRing(radius);
        int placed = 0;
        int notPlaced = 0;
        for (Vec2i vec : ring) {
            BlockPos ringPos = new BlockPos(pos.getX() + vec.x, pos.getY(), pos.getZ() + vec.z);
            if (DynamicCapCenterBlock.canCapReplace(level.getBlockState(ringPos))) {
                level.setBlock(ringPos, this.getStateForAge(this.properties, step, new Vec2i(-vec.x, -vec.z), yMoved, negFactor, this.properties.isPartOfCap(level.getBlockState(ringPos.above()))), 2);
                ++placed;
                continue;
            }
            ++notPlaced;
        }
        return placed >= notPlaced;
    }

    public List<BlockPos> getRing(LevelAccessor level, BlockPos pos, int radius) {
        List<Vec2i> ring = MushroomCapDisc.getPrecomputedRing(radius);
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        for (Vec2i vec : ring) {
            BlockPos ringPos = new BlockPos(pos.getX() + vec.x, pos.getY(), pos.getZ() + vec.z);
            if (!this.properties.isPartOfCap(level.getBlockState(ringPos))) continue;
            positions.add(ringPos);
        }
        return positions;
    }

    public static boolean canCapReplace(BlockState state) {
        return state.canBeReplaced() || state.is(DTBlockTags.FOLIAGE) || state.is(BlockTags.LEAVES);
    }

    @Nonnull
    private BlockState getStateForAge(CapProperties properties, int age, Vec2i centerDirection, boolean yMoved, boolean negativeFactor, boolean topIsCap) {
        boolean[] dirs = new boolean[]{false, !topIsCap, true, true, true, true};
        if (yMoved || age == 1) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                float dot = dir.getNormal().getX() * centerDirection.x + dir.getNormal().getZ() * centerDirection.z;
                if (!(dot >= 0.0f)) continue;
                dirs[negativeFactor ? dir.getOpposite().ordinal() : dir.ordinal()] = false;
            }
        }
        return properties.getDynamicCapState(age, dirs);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean destroyed = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        this.updateNeighborsSurround(level, pos, DynamicCapBlock.class);
        return destroyed;
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(level, state, pos, entity, fallDistance * 0.5f);
    }

    public void updateEntityAfterFallOn(BlockGetter level, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(level, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        if (vec3.y < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.setDeltaMovement(vec3.x, -vec3.y * (double)0.66f * d0, vec3.z);
        }
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.is((Block)this) && (Integer)pState.getValue((Property)AGE) == 0) {
            return this.properties.getAgeZeroShape();
        }
        return super.getShape(pState, pLevel, pPos, pContext);
    }
}

