/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.block.mushroom;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.cell.Cell;
import com.dtteam.dynamictrees.api.cell.CellNull;
import com.dtteam.dynamictrees.api.network.BranchDestructionData;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.network.NodeInspector;
import com.dtteam.dynamictrees.api.voxmap.BlockPosBounds;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.branch.ThickBranchBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.systems.nodemapper.DestroyerNode;
import com.dtteam.dynamictrees.systems.nodemapper.NetVolumeNode;
import com.dtteam.dynamictrees.systems.nodemapper.SpeciesNode;
import com.dtteam.dynamictrees.systems.nodemapper.StateNode;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictreesplus.block.mushroom.CapProperties;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapBlock;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.dtteam.dynamictreesplus.data.DTPLootTableHandler;
import com.dtteam.dynamictreesplus.systems.mushroomlogic.context.MushroomCapContext;
import com.dtteam.dynamictreesplus.tree.HugeMushroomFamily;
import com.dtteam.dynamictreesplus.tree.HugeMushroomSpecies;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MushroomBranchBlock
extends ThickBranchBlock {
    public MushroomBranchBlock(ResourceLocation name, BlockBehaviour.Properties properties) {
        super(name, properties);
        this.setFlammability(0);
        this.setFireSpreadSpeed(0);
    }

    @NotNull
    public Cell getHydrationCell(@NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Direction dir, @NotNull LeavesProperties leavesProperties) {
        return CellNull.NULL_CELL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public GrowSignal growIntoAir(@NotNull Level level, @NotNull BlockPos pos, GrowSignal signal, int fromRadius) {
        Species species = signal.getSpecies();
        if (!(species instanceof HugeMushroomSpecies)) {
            return signal;
        }
        HugeMushroomSpecies species2 = (HugeMushroomSpecies)species;
        DynamicCapCenterBlock cap = species2.getCapCenterBlock().orElse(null);
        if (cap != null) {
            if (fromRadius != this.getFamily().getPrimaryThickness()) return cap.branchOut(level, pos, signal, 0);
            signal.success = cap.tryGrowCap(level, species2.getCapProperties(), 0, signal, pos, pos, false);
            return signal;
        } else {
            if (MushroomBranchBlock.isNextToBranch((Level)level, (BlockPos)pos, (Direction)signal.dir.getOpposite())) {
                signal.success = false;
                return signal;
            }
            this.setRadius((LevelAccessor)level, pos, this.getFamily().getPrimaryThickness(), null);
            signal.radius = this.getFamily().getSecondaryThickness();
            signal.success = true;
        }
        return signal;
    }

    public BranchDestructionData destroyBranchFromNode(Level level, BlockPos cutPos, Direction toolDir, boolean wholeTree, @Nullable LivingEntity entity) {
        BlockState blockState = level.getBlockState(cutPos);
        SpeciesNode speciesNode = new SpeciesNode();
        MapSignal signal = this.analyse(blockState, (LevelAccessor)level, cutPos, null, new MapSignal(new NodeInspector[]{speciesNode}));
        Species species = speciesNode.getSpecies();
        StateNode stateMapper = new StateNode(cutPos);
        this.analyse(blockState, (LevelAccessor)level, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(new NodeInspector[]{stateMapper}));
        NetVolumeNode volumeSum = new NetVolumeNode();
        DestroyerNode destroyer = new DestroyerNode(species).setPlayer(entity instanceof Player ? (Player)entity : null);
        destroyMode = DynamicTrees.DestroyMode.HARVEST;
        this.analyse(blockState, (LevelAccessor)level, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(new NodeInspector[]{volumeSum, destroyer}));
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
        List endPoints = destroyer.getEnds();
        HashMap<BlockPos, BlockState> destroyedLeaves = new HashMap<BlockPos, BlockState>();
        ArrayList<BranchBlock.ItemStackPos> leavesDropsList = new ArrayList<BranchBlock.ItemStackPos>();
        this.destroyMushroomCap(level, cutPos, species, entity == null ? ItemStack.EMPTY : entity.getMainHandItem(), endPoints, destroyedLeaves, leavesDropsList);
        endPoints = endPoints.stream().map(p -> p.subtract((Vec3i)cutPos)).collect(Collectors.toList());
        int trunkHeight = 1;
        BlockPos iter = new BlockPos(0, 1, 0);
        while (stateMapper.getBranchConnectionMap().containsKey(iter)) {
            ++trunkHeight;
            iter = iter.above();
        }
        Direction cutDir = signal.localRootDir;
        if (cutDir == null) {
            cutDir = Direction.DOWN;
        }
        Pair soilState = MushroomBranchBlock.getCachedSoilState((Level)level, (BlockPos)cutPos.offset(cutDir.getNormal()), (boolean)true);
        return new BranchDestructionData(species, stateMapper.getBranchConnectionMap(), destroyedLeaves, leavesDropsList, endPoints, volumeSum.getVolume(), cutPos, cutPos, cutDir, toolDir, trunkHeight, soilState);
    }

    public void destroyMushroomCap(@NotNull Level level, @NotNull BlockPos cutPos, @NotNull Species species, @NotNull ItemStack tool, @NotNull List<BlockPos> endPoints, @NotNull Map<BlockPos, BlockState> destroyedCapBlocks, @NotNull List<BranchBlock.ItemStackPos> drops) {
        if (!(species instanceof HugeMushroomSpecies)) {
            return;
        }
        HugeMushroomSpecies mushSpecies = (HugeMushroomSpecies)species;
        Family family = species.getFamily();
        if (!(family instanceof HugeMushroomFamily)) {
            return;
        }
        HugeMushroomFamily family2 = (HugeMushroomFamily)family;
        if (level.isClientSide || endPoints.isEmpty()) {
            return;
        }
        BlockPosBounds bounds = this.getFamily().expandLeavesBlockBounds(new BlockPosBounds(endPoints));
        SimpleVoxmap capMap = new SimpleVoxmap(bounds);
        for (BlockPos endPos : endPoints) {
            int age = DynamicCapCenterBlock.getCapAge(level, endPos.above());
            if (age < 0) continue;
            for (BlockPos findPos : mushSpecies.getMushroomShapeKit().getShapeCluster(new MushroomCapContext((LevelAccessor)level, endPos.above(), mushSpecies, age))) {
                BlockState findState = level.getBlockState(findPos);
                if (!family2.isCompatibleCap(mushSpecies, findState, level, findPos)) continue;
                capMap.setVoxel(findPos.getX(), findPos.getY(), findPos.getZ(), (byte)1);
            }
            capMap.setVoxel(endPos, (byte)0);
        }
        ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
        for (SimpleVoxmap.VoxmapCell cell : capMap.getAllNonZeroCells()) {
            BlockPos.MutableBlockPos pos = cell.getPos();
            BlockState state = level.getBlockState((BlockPos)pos);
            if (!family2.isCompatibleCap(mushSpecies, state, level, (BlockPos)pos)) continue;
            dropList.clear();
            CapProperties cap = this.getCapProperties(state);
            dropList.addAll(cap.getDrops(level, (BlockPos)pos, tool, species));
            BlockPos imPos = pos.immutable();
            BlockPos relPos = imPos.subtract((Vec3i)cutPos);
            level.setBlock(imPos, Blocks.AIR.defaultBlockState(), 3);
            destroyedCapBlocks.put(relPos, state);
            dropList.forEach(i -> drops.add(new BranchBlock.ItemStackPos(i, relPos)));
        }
    }

    private CapProperties getCapProperties(BlockState state) {
        if (state.getBlock() instanceof DynamicCapBlock) {
            return Optional.of((DynamicCapBlock)state.getBlock()).map(block -> block.getProperties(state)).orElse(CapProperties.NULL);
        }
        if (state.getBlock() instanceof DynamicCapCenterBlock) {
            return Optional.of((DynamicCapCenterBlock)state.getBlock()).map(block -> block.getProperties(state)).orElse(CapProperties.NULL);
        }
        return CapProperties.NULL;
    }

    public LootTable.Builder createBranchDrops(HolderLookup.Provider registries) {
        return DTPLootTableHandler.createMushroomBranchDrops((Block)this.getPrimitiveLog().get(), registries);
    }
}

