/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.data;

import com.dtteam.dynamictrees.event.DataGenerationStreamEvent;
import com.dtteam.dynamictrees.loot.DTLootParameterSets;
import com.dtteam.dynamictrees.loot.function.MultiplyByLogsCount;
import com.dtteam.dynamictreesplus.block.mushroom.CapProperties;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DTPLootTableHandler {
    protected static LootItemCondition.Builder hasSilkTouch(HolderLookup.Provider registries) {
        HolderLookup.RegistryLookup registrylookup = registries.lookupOrThrow(Registries.ENCHANTMENT);
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)registrylookup.getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1))))));
    }

    protected static Holder<Enchantment> getFortune(HolderLookup.Provider registries) {
        HolderLookup.RegistryLookup registrylookup = registries.lookupOrThrow(Registries.ENCHANTMENT);
        return registrylookup.getOrThrow(Enchantments.SILK_TOUCH);
    }

    @SubscribeEvent
    public static void onLootTableProviderGenerate(DataGenerationStreamEvent event) {
        CapProperties.REGISTRY.dataGenerationStream(event.getModId()).forEach(capProperties -> {
            DTPLootTableHandler.addCapBlockTable(capProperties, event.getFileHelper(), event.getMap(), event.getRegistries());
            DTPLootTableHandler.addCapTable(capProperties, event.getFileHelper(), event.getMap(), event.getRegistries());
        });
    }

    private static void addCapBlockTable(CapProperties capProperties, ExistingFileHelper existingFileHelper, Map<ResourceKey<LootTable>, LootTable.Builder> map, HolderLookup.Provider registries) {
        ResourceLocation capBlockTablePath;
        if (capProperties.shouldGenerateBlockDrops() && !existingFileHelper.exists(capBlockTablePath = capProperties.getBlockLootTableName(), PackType.SERVER_DATA)) {
            map.put((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)capBlockTablePath), capProperties.createBlockDrops(registries));
        }
    }

    private static void addCapTable(CapProperties capProperties, ExistingFileHelper existingFileHelper, Map<ResourceKey<LootTable>, LootTable.Builder> map, HolderLookup.Provider registries) {
        ResourceLocation capTablePath;
        if (capProperties.shouldGenerateDrops() && !existingFileHelper.exists(capTablePath = capProperties.getLootTableName(), PackType.SERVER_DATA)) {
            map.put((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)capTablePath), capProperties.createDrops(registries));
        }
    }

    public static LootTable.Builder createMushroomBranchDrops(Block primitiveLogBlock, HolderLookup.Provider registries) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)primitiveLogBlock).apply(MultiplyByLogsCount.multiplyByLogsCount()).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()).when(DTPLootTableHandler.hasSilkTouch(registries)))).setParamSet(DTLootParameterSets.BRANCHES);
    }

    public static LootTable.Builder createCapBlockDrops(Block primitiveCapBlock, Item primitiveSapling, int countMin, int countMax, HolderLookup.Provider registries) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.lootTableItem((ItemLike)primitiveCapBlock).when(DTPLootTableHandler.hasSilkTouch(registries)), LootItem.lootTableItem((ItemLike)primitiveSapling).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)countMin, (float)countMax), (boolean)false)).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.lowerBound((int)0))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay())}))).setParamSet(LootContextParamSets.BLOCK);
    }

    public static LootTable.Builder createCapDrops(Block primitiveCapBlock, Item primitiveSapling, LootContextParamSet parameterSet, HolderLookup.Provider registries) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.lootTableItem((ItemLike)primitiveCapBlock).when(DTPLootTableHandler.hasSilkTouch(registries)), LootItem.lootTableItem((ItemLike)primitiveSapling)})).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()).when(BonusLevelTableCondition.bonusLevelFlatChance(DTPLootTableHandler.getFortune(registries), (float[])new float[]{0.2f, 0.2333333f, 0.2666666f, 0.3f}))).setParamSet(parameterSet);
    }
}

