/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.model.baked;

import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.model.ModelHelper;
import com.dtteam.dynamictrees.model.modeldata.ModelConnections;
import com.dtteam.dynamictreesplus.block.CactusBranchBlock;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.NamedRenderTypeManager;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class CactusBranchBlockBakedModel
implements IDynamicBakedModel {
    private static final float SIXTEENTH = 0.0625f;
    private static final float SPIKE_OFFSET_1 = 1.0E-4f;
    private static final float SPIKE_OFFSET_2 = 2.0E-4f;
    private final BlockModel blockModel;
    private final TextureAtlasSprite barkTexture;
    private final BakedModel[][] sleeves = new BakedModel[6][3];
    private final BakedModel[][] cores = new BakedModel[3][3];
    private final BakedModel[] rings = new BakedModel[3];
    private final BakedModel[] coreSpikes = new BakedModel[3];
    private BakedModel sleeveTopSpikes;
    int[] radii = new int[]{4, 5, 7};

    public CactusBranchBlockBakedModel(ResourceLocation barkTextureLocation, ResourceLocation ringsTextureLocation, Function<Material, TextureAtlasSprite> spriteGetter) {
        this.blockModel = new BlockModel(null, new ArrayList(), new HashMap(), Boolean.valueOf(false), BlockModel.GuiLight.FRONT, ItemTransforms.NO_TRANSFORMS, new ArrayList());
        this.barkTexture = spriteGetter.apply(new Material(InventoryMenu.BLOCK_ATLAS, barkTextureLocation));
        this.initModels(spriteGetter.apply(new Material(InventoryMenu.BLOCK_ATLAS, ringsTextureLocation)));
    }

    public void initModels(TextureAtlasSprite ringsTexture) {
        for (int i = 0; i < 3; ++i) {
            int radius = this.radii[i];
            for (Direction dir : Direction.values()) {
                this.sleeves[dir.get3DDataValue()][i] = this.bakeSleeve(radius, dir, this.barkTexture, ringsTexture);
            }
            this.cores[0][i] = this.bakeCore(radius, Direction.Axis.Y, this.barkTexture);
            this.cores[1][i] = this.bakeCore(radius, Direction.Axis.Z, this.barkTexture);
            this.cores[2][i] = this.bakeCore(radius, Direction.Axis.X, this.barkTexture);
            this.rings[i] = this.bakeCore(radius, Direction.Axis.Y, ringsTexture);
            this.coreSpikes[i] = this.bakeCoreSpikes(radius, this.barkTexture);
            this.sleeveTopSpikes = this.bakeTopSleeveSpikes(this.barkTexture);
        }
    }

    private void putVertex(QuadBakingVertexConsumer builder, Vec3 normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b, Direction face) {
        builder.addVertex((float)x, (float)y, (float)z);
        builder.setNormal((float)normal.x, (float)normal.y, (float)normal.z);
        builder.setColor(r, g, b, 1.0f);
        builder.setUv(sprite.getU(u), sprite.getV(v));
        builder.setSprite(sprite);
        builder.setDirection(face);
    }

    private BakedQuad createQuad(Vec3 v1, float v1u, float v1v, Vec3 v2, float v2u, float v2v, Vec3 v3, float v3u, float v3v, Vec3 v4, float v4u, float v4v, TextureAtlasSprite sprite) {
        Vec3 normal = v3.subtract(v2).cross(v1.subtract(v2)).normalize();
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer();
        Direction face = Direction.getNearest((double)normal.x, (double)normal.y, (double)normal.z);
        this.putVertex(builder, normal, v1.x, v1.y, v1.z, v1u, v1v, sprite, 1.0f, 1.0f, 1.0f, face);
        this.putVertex(builder, normal, v2.x, v2.y, v2.z, v2u, v2v, sprite, 1.0f, 1.0f, 1.0f, face);
        this.putVertex(builder, normal, v3.x, v3.y, v3.z, v3u, v3v, sprite, 1.0f, 1.0f, 1.0f, face);
        this.putVertex(builder, normal, v4.x, v4.y, v4.z, v4u, v4v, sprite, 1.0f, 1.0f, 1.0f, face);
        return builder.bakeQuad();
    }

    public BakedModel bakeSleeve(int radius, Direction dir, TextureAtlasSprite bark, TextureAtlasSprite top) {
        boolean negative;
        int dradius = radius * 2;
        int halfSize = (16 - dradius) / 2;
        int halfSizeX = dir.getStepX() != 0 ? halfSize : dradius;
        int halfSizeY = dir.getStepY() != 0 ? halfSize : dradius;
        int halfSizeZ = dir.getStepZ() != 0 ? halfSize : dradius;
        int move = 16 - halfSize;
        int centerX = 16 + dir.getStepX() * move;
        int centerY = 16 + dir.getStepY() * move;
        int centerZ = 16 + dir.getStepZ() * move;
        Vector3f posFrom = new Vector3f((float)(centerX - halfSizeX) / 2.0f, (float)(centerY - halfSizeY) / 2.0f, (float)(centerZ - halfSizeZ) / 2.0f);
        Vector3f posTo = new Vector3f((float)(centerX + halfSizeX) / 2.0f, (float)(centerY + halfSizeY) / 2.0f, (float)(centerZ + halfSizeZ) / 2.0f);
        boolean bl = negative = dir.getAxisDirection() == Direction.AxisDirection.NEGATIVE;
        if (dir.getAxis() == Direction.Axis.Z) {
            negative = !negative;
        }
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            if (dir.getOpposite() == face) continue;
            BlockFaceUV uvface = null;
            if (dir == face) {
                if (radius == 4 || radius == 5 && dir == Direction.DOWN) {
                    uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, 0);
                }
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, negative ? (float)(16 - halfSize) : 0.0f, 8 + radius, negative ? 16.0f : (float)halfSize}, this.getFaceAngle(dir.getAxis(), face));
            }
            if (uvface == null) continue;
            mapFacesIn.put(face, new BlockElementFace(null, -1, null, uvface));
        }
        BlockElement part = new BlockElement(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.blockModel, ItemOverrides.EMPTY, false).particle(bark);
        for (Map.Entry e : part.faces.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelHelper.makeBakedQuad((BlockElement)part, (BlockElementFace)((BlockElementFace)e.getValue()), (TextureAtlasSprite)(dir == face ? top : bark), (Direction)face, (BlockModelRotation)BlockModelRotation.X0_Y0));
        }
        float minV = (float)(negative ? 16 - halfSize : 0) / 16.0f;
        float maxV = (float)(negative ? 16 : halfSize) / 16.0f;
        switch (dir.getAxis()) {
            case X: {
                builder.addCulledFace(Direction.NORTH, this.createQuad(this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f - 2.0E-4f), 1.0f, minV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f - 2.0E-4f), 0.875f, minV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f - 2.0E-4f), 0.875f, maxV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f - 2.0E-4f), 1.0f, maxV, bark));
                builder.addCulledFace(Direction.NORTH, this.createQuad(this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f - 2.0E-4f), 0.125f, minV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f - 2.0E-4f), 0.0f, minV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f - 2.0E-4f), 0.0f, maxV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f - 2.0E-4f), 0.125f, maxV, bark));
                builder.addCulledFace(Direction.SOUTH, this.createQuad(this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f + 2.0E-4f), 1.0f, maxV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f + 2.0E-4f), 0.875f, maxV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f + 2.0E-4f), 0.875f, minV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f + 2.0E-4f), 1.0f, minV, bark));
                builder.addCulledFace(Direction.SOUTH, this.createQuad(this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f + 0.0625f, posTo.z() / 16.0f + 2.0E-4f), 0.125f, maxV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 0.0625f, posTo.z() / 16.0f + 2.0E-4f), 0.0f, maxV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 0.0625f, posTo.z() / 16.0f + 2.0E-4f), 0.0f, minV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f + 0.0625f, posTo.z() / 16.0f + 2.0E-4f), 0.125f, minV, bark));
                builder.addCulledFace(Direction.DOWN, this.createQuad(this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 2.0E-4f, posTo.z() / 16.0f - 0.0625f), 0.875f, minV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 2.0E-4f, posTo.z() / 16.0f + 0.0625f), 1.0f, minV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 2.0E-4f, posTo.z() / 16.0f + 0.0625f), 1.0f, maxV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 2.0E-4f, posTo.z() / 16.0f - 0.0625f), 0.875f, maxV, bark));
                builder.addCulledFace(Direction.DOWN, this.createQuad(this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 2.0E-4f, posFrom.z() / 16.0f - 0.0625f), 0.0f, minV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 2.0E-4f, posFrom.z() / 16.0f + 0.0625f), 0.125f, minV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 2.0E-4f, posFrom.z() / 16.0f + 0.0625f), 0.125f, maxV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 2.0E-4f, posFrom.z() / 16.0f - 0.0625f), 0.0f, maxV, bark));
                builder.addCulledFace(Direction.UP, this.createQuad(this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 2.0E-4f, posTo.z() / 16.0f - 0.0625f), 0.875f, maxV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 2.0E-4f, posTo.z() / 16.0f + 0.0625f), 1.0f, maxV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 2.0E-4f, posTo.z() / 16.0f + 0.0625f), 1.0f, minV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 2.0E-4f, posTo.z() / 16.0f - 0.0625f), 0.875f, minV, bark));
                builder.addCulledFace(Direction.UP, this.createQuad(this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 2.0E-4f, posFrom.z() / 16.0f - 0.0625f), 0.125f, maxV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 2.0E-4f, posFrom.z() / 16.0f + 0.0625f), 0.0f, maxV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 2.0E-4f, posFrom.z() / 16.0f + 0.0625f), 0.0f, minV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 2.0E-4f, posFrom.z() / 16.0f - 0.0625f), 0.125f, minV, bark));
                break;
            }
            case Y: {
                builder.addCulledFace(Direction.WEST, this.createQuad(this.v(posFrom.x() / 16.0f - 1.0E-4f, posTo.y() / 16.0f, posTo.z() / 16.0f + 0.0625f), 1.0f, minV, this.v(posFrom.x() / 16.0f - 1.0E-4f, posTo.y() / 16.0f, posTo.z() / 16.0f - 0.0625f), 0.875f, minV, this.v(posFrom.x() / 16.0f - 1.0E-4f, posFrom.y() / 16.0f, posTo.z() / 16.0f - 0.0625f), 0.875f, maxV, this.v(posFrom.x() / 16.0f - 1.0E-4f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 0.0625f), 1.0f, maxV, bark));
                builder.addCulledFace(Direction.WEST, this.createQuad(this.v(posFrom.x() / 16.0f - 1.0E-4f, posTo.y() / 16.0f, posFrom.z() / 16.0f + 0.0625f), 0.125f, minV, this.v(posFrom.x() / 16.0f - 1.0E-4f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 0.0625f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 1.0E-4f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 0.0625f), 0.0f, maxV, this.v(posFrom.x() / 16.0f - 1.0E-4f, posFrom.y() / 16.0f, posFrom.z() / 16.0f + 0.0625f), 0.125f, maxV, bark));
                builder.addCulledFace(Direction.EAST, this.createQuad(this.v(posTo.x() / 16.0f + 1.0E-4f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 0.0625f), 1.0f, maxV, this.v(posTo.x() / 16.0f + 1.0E-4f, posFrom.y() / 16.0f, posTo.z() / 16.0f - 0.0625f), 0.875f, maxV, this.v(posTo.x() / 16.0f + 1.0E-4f, posTo.y() / 16.0f, posTo.z() / 16.0f - 0.0625f), 0.875f, minV, this.v(posTo.x() / 16.0f + 1.0E-4f, posTo.y() / 16.0f, posTo.z() / 16.0f + 0.0625f), 1.0f, minV, bark));
                builder.addCulledFace(Direction.EAST, this.createQuad(this.v(posTo.x() / 16.0f + 1.0E-4f, posFrom.y() / 16.0f, posFrom.z() / 16.0f + 0.0625f), 0.125f, maxV, this.v(posTo.x() / 16.0f + 1.0E-4f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 0.0625f), 0.0f, maxV, this.v(posTo.x() / 16.0f + 1.0E-4f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 0.0625f), 0.0f, minV, this.v(posTo.x() / 16.0f + 1.0E-4f, posTo.y() / 16.0f, posFrom.z() / 16.0f + 0.0625f), 0.125f, minV, bark));
                builder.addCulledFace(Direction.NORTH, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 1.0E-4f), 1.0f, maxV, this.v(posTo.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 1.0E-4f), 0.875f, maxV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 1.0E-4f), 0.875f, minV, this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 1.0E-4f), 1.0f, minV, bark));
                builder.addCulledFace(Direction.NORTH, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 1.0E-4f), 0.125f, maxV, this.v(posFrom.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 1.0E-4f), 0.0f, maxV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 1.0E-4f), 0.0f, minV, this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 1.0E-4f), 0.125f, minV, bark));
                builder.addCulledFace(Direction.SOUTH, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f, posTo.z() / 16.0f + 1.0E-4f), 1.0f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f, posTo.z() / 16.0f + 1.0E-4f), 0.875f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 1.0E-4f), 0.875f, maxV, this.v(posTo.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 1.0E-4f), 1.0f, maxV, bark));
                builder.addCulledFace(Direction.SOUTH, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f, posTo.z() / 16.0f + 1.0E-4f), 0.125f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f, posTo.z() / 16.0f + 1.0E-4f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 1.0E-4f), 0.0f, maxV, this.v(posFrom.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 1.0E-4f), 0.125f, maxV, bark));
                break;
            }
            case Z: {
                builder.addCulledFace(Direction.WEST, this.createQuad(this.v(posFrom.x() / 16.0f - 2.0E-4f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 1.0f, minV, this.v(posFrom.x() / 16.0f - 2.0E-4f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 0.875f, minV, this.v(posFrom.x() / 16.0f - 2.0E-4f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 0.875f, maxV, this.v(posFrom.x() / 16.0f - 2.0E-4f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 1.0f, maxV, bark));
                builder.addCulledFace(Direction.WEST, this.createQuad(this.v(posFrom.x() / 16.0f - 2.0E-4f, posFrom.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 0.125f, minV, this.v(posFrom.x() / 16.0f - 2.0E-4f, posFrom.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 2.0E-4f, posFrom.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posFrom.x() / 16.0f - 2.0E-4f, posFrom.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 0.125f, maxV, bark));
                builder.addCulledFace(Direction.EAST, this.createQuad(this.v(posTo.x() / 16.0f + 2.0E-4f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 1.0f, maxV, this.v(posTo.x() / 16.0f + 2.0E-4f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 0.875f, maxV, this.v(posTo.x() / 16.0f + 2.0E-4f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 0.875f, minV, this.v(posTo.x() / 16.0f + 2.0E-4f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 1.0f, minV, bark));
                builder.addCulledFace(Direction.EAST, this.createQuad(this.v(posTo.x() / 16.0f + 2.0E-4f, posFrom.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 0.125f, maxV, this.v(posTo.x() / 16.0f + 2.0E-4f, posFrom.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posTo.x() / 16.0f + 2.0E-4f, posFrom.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posTo.x() / 16.0f + 2.0E-4f, posFrom.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 0.125f, minV, bark));
                builder.addCulledFace(Direction.DOWN, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f - 1.0E-4f, posTo.z() / 16.0f), 1.0f, maxV, this.v(posTo.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f - 1.0E-4f, posTo.z() / 16.0f), 0.875f, maxV, this.v(posTo.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f - 1.0E-4f, posFrom.z() / 16.0f), 0.875f, minV, this.v(posTo.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f - 1.0E-4f, posFrom.z() / 16.0f), 1.0f, minV, bark));
                builder.addCulledFace(Direction.DOWN, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f - 1.0E-4f, posTo.z() / 16.0f), 0.125f, maxV, this.v(posFrom.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f - 1.0E-4f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posFrom.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f - 1.0E-4f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posFrom.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f - 1.0E-4f, posFrom.z() / 16.0f), 0.125f, minV, bark));
                builder.addCulledFace(Direction.UP, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posFrom.z() / 16.0f), 1.0f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posFrom.z() / 16.0f), 0.875f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posTo.z() / 16.0f), 0.875f, maxV, this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posTo.z() / 16.0f), 1.0f, maxV, bark));
                builder.addCulledFace(Direction.UP, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posFrom.z() / 16.0f), 0.125f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posTo.z() / 16.0f), 0.125f, maxV, bark));
            }
        }
        return builder.build();
    }

    public BakedModel bakeCore(int radius, Direction.Axis axis, TextureAtlasSprite icon) {
        Vector3f posFrom = new Vector3f((float)(8 - radius), (float)(8 - radius), (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)(8 + radius), (float)(8 + radius));
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            BlockFaceUV uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, this.getFaceAngle(axis, face));
            mapFacesIn.put(face, new BlockElementFace(null, -1, null, uvface));
        }
        BlockElement part = new BlockElement(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.blockModel, ItemOverrides.EMPTY, false).particle(icon);
        for (Map.Entry e : part.faces.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelHelper.makeBakedQuad((BlockElement)part, (BlockElementFace)((BlockElementFace)e.getValue()), (TextureAtlasSprite)icon, (Direction)face, (BlockModelRotation)BlockModelRotation.X0_Y0));
        }
        return builder.build();
    }

    public BakedModel bakeCoreSpikes(int radius, TextureAtlasSprite bark) {
        float minV = (float)(8 - radius) / 16.0f;
        float maxV = (float)(8 + radius) / 16.0f;
        Vector3f posFrom = new Vector3f((float)(8 - radius), (float)(8 - radius), (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)(8 + radius), (float)(8 + radius));
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.blockModel, ItemOverrides.EMPTY, false).particle(bark);
        builder.addCulledFace(Direction.UP, this.createQuad(this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f - 2.0E-4f), 1.0f, minV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f - 2.0E-4f), 0.875f, minV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f - 2.0E-4f), 0.875f, maxV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f - 2.0E-4f), 1.0f, maxV, bark));
        builder.addCulledFace(Direction.DOWN, this.createQuad(this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f - 2.0E-4f), 0.125f, minV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f - 2.0E-4f), 0.0f, minV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f - 2.0E-4f), 0.0f, maxV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f - 2.0E-4f), 0.125f, maxV, bark));
        builder.addCulledFace(Direction.UP, this.createQuad(this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f + 2.0E-4f), 1.0f, maxV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f + 2.0E-4f), 0.875f, maxV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f + 2.0E-4f), 0.875f, minV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f + 2.0E-4f), 1.0f, minV, bark));
        builder.addCulledFace(Direction.DOWN, this.createQuad(this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f + 0.0625f, posTo.z() / 16.0f + 2.0E-4f), 0.125f, maxV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 0.0625f, posTo.z() / 16.0f + 2.0E-4f), 0.0f, maxV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 0.0625f, posTo.z() / 16.0f + 2.0E-4f), 0.0f, minV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f + 0.0625f, posTo.z() / 16.0f + 2.0E-4f), 0.125f, minV, bark));
        builder.addCulledFace(Direction.SOUTH, this.createQuad(this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 2.0E-4f, posTo.z() / 16.0f - 0.0625f), 0.875f, minV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 2.0E-4f, posTo.z() / 16.0f + 0.0625f), 1.0f, minV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 2.0E-4f, posTo.z() / 16.0f + 0.0625f), 1.0f, maxV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 2.0E-4f, posTo.z() / 16.0f - 0.0625f), 0.875f, maxV, bark));
        builder.addCulledFace(Direction.NORTH, this.createQuad(this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 2.0E-4f, posFrom.z() / 16.0f - 0.0625f), 0.0f, minV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 2.0E-4f, posFrom.z() / 16.0f + 0.0625f), 0.125f, minV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 2.0E-4f, posFrom.z() / 16.0f + 0.0625f), 0.125f, maxV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 2.0E-4f, posFrom.z() / 16.0f - 0.0625f), 0.0f, maxV, bark));
        builder.addCulledFace(Direction.SOUTH, this.createQuad(this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 2.0E-4f, posTo.z() / 16.0f - 0.0625f), 0.875f, maxV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 2.0E-4f, posTo.z() / 16.0f + 0.0625f), 1.0f, maxV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 2.0E-4f, posTo.z() / 16.0f + 0.0625f), 1.0f, minV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 2.0E-4f, posTo.z() / 16.0f - 0.0625f), 0.875f, minV, bark));
        builder.addCulledFace(Direction.NORTH, this.createQuad(this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 2.0E-4f, posFrom.z() / 16.0f - 0.0625f), 0.0f, maxV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 2.0E-4f, posFrom.z() / 16.0f + 0.0625f), 0.125f, maxV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 2.0E-4f, posFrom.z() / 16.0f + 0.0625f), 0.125f, minV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 2.0E-4f, posFrom.z() / 16.0f - 0.0625f), 0.0f, minV, bark));
        builder.addCulledFace(Direction.SOUTH, this.createQuad(this.v(posFrom.x() / 16.0f - 1.0E-4f, posTo.y() / 16.0f, posTo.z() / 16.0f + 0.0625f), 1.0f, minV, this.v(posFrom.x() / 16.0f - 1.0E-4f, posTo.y() / 16.0f, posTo.z() / 16.0f - 0.0625f), 0.875f, minV, this.v(posFrom.x() / 16.0f - 1.0E-4f, posFrom.y() / 16.0f, posTo.z() / 16.0f - 0.0625f), 0.875f, maxV, this.v(posFrom.x() / 16.0f - 1.0E-4f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 0.0625f), 1.0f, maxV, bark));
        builder.addCulledFace(Direction.NORTH, this.createQuad(this.v(posFrom.x() / 16.0f - 1.0E-4f, posTo.y() / 16.0f, posFrom.z() / 16.0f + 0.0625f), 0.125f, minV, this.v(posFrom.x() / 16.0f - 1.0E-4f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 0.0625f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 1.0E-4f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 0.0625f), 0.0f, maxV, this.v(posFrom.x() / 16.0f - 1.0E-4f, posFrom.y() / 16.0f, posFrom.z() / 16.0f + 0.0625f), 0.125f, maxV, bark));
        builder.addCulledFace(Direction.SOUTH, this.createQuad(this.v(posTo.x() / 16.0f + 1.0E-4f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 0.0625f), 1.0f, maxV, this.v(posTo.x() / 16.0f + 1.0E-4f, posFrom.y() / 16.0f, posTo.z() / 16.0f - 0.0625f), 0.875f, maxV, this.v(posTo.x() / 16.0f + 1.0E-4f, posTo.y() / 16.0f, posTo.z() / 16.0f - 0.0625f), 0.875f, minV, this.v(posTo.x() / 16.0f + 1.0E-4f, posTo.y() / 16.0f, posTo.z() / 16.0f + 0.0625f), 1.0f, minV, bark));
        builder.addCulledFace(Direction.NORTH, this.createQuad(this.v(posTo.x() / 16.0f + 1.0E-4f, posFrom.y() / 16.0f, posFrom.z() / 16.0f + 0.0625f), 0.125f, maxV, this.v(posTo.x() / 16.0f + 1.0E-4f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 0.0625f), 0.0f, maxV, this.v(posTo.x() / 16.0f + 1.0E-4f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 0.0625f), 0.0f, minV, this.v(posTo.x() / 16.0f + 1.0E-4f, posTo.y() / 16.0f, posFrom.z() / 16.0f + 0.0625f), 0.125f, minV, bark));
        builder.addCulledFace(Direction.EAST, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 1.0E-4f), 1.0f, maxV, this.v(posTo.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 1.0E-4f), 0.875f, maxV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 1.0E-4f), 0.875f, minV, this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 1.0E-4f), 1.0f, minV, bark));
        builder.addCulledFace(Direction.WEST, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 1.0E-4f), 0.125f, maxV, this.v(posFrom.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 1.0E-4f), 0.0f, maxV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 1.0E-4f), 0.0f, minV, this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 1.0E-4f), 0.125f, minV, bark));
        builder.addCulledFace(Direction.EAST, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f, posTo.z() / 16.0f + 1.0E-4f), 1.0f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f, posTo.z() / 16.0f + 1.0E-4f), 0.875f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 1.0E-4f), 0.875f, maxV, this.v(posTo.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 1.0E-4f), 1.0f, maxV, bark));
        builder.addCulledFace(Direction.WEST, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f, posTo.z() / 16.0f + 1.0E-4f), 0.125f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f, posTo.z() / 16.0f + 1.0E-4f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 1.0E-4f), 0.0f, maxV, this.v(posFrom.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 1.0E-4f), 0.125f, maxV, bark));
        builder.addCulledFace(Direction.UP, this.createQuad(this.v(posFrom.x() / 16.0f - 2.0E-4f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 1.0f, minV, this.v(posFrom.x() / 16.0f - 2.0E-4f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 0.875f, minV, this.v(posFrom.x() / 16.0f - 2.0E-4f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 0.875f, maxV, this.v(posFrom.x() / 16.0f - 2.0E-4f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 1.0f, maxV, bark));
        builder.addCulledFace(Direction.DOWN, this.createQuad(this.v(posFrom.x() / 16.0f - 2.0E-4f, posFrom.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 0.125f, minV, this.v(posFrom.x() / 16.0f - 2.0E-4f, posFrom.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 2.0E-4f, posFrom.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posFrom.x() / 16.0f - 2.0E-4f, posFrom.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 0.125f, maxV, bark));
        builder.addCulledFace(Direction.UP, this.createQuad(this.v(posTo.x() / 16.0f + 2.0E-4f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 1.0f, maxV, this.v(posTo.x() / 16.0f + 2.0E-4f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 0.875f, maxV, this.v(posTo.x() / 16.0f + 2.0E-4f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 0.875f, minV, this.v(posTo.x() / 16.0f + 2.0E-4f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 1.0f, minV, bark));
        builder.addCulledFace(Direction.DOWN, this.createQuad(this.v(posTo.x() / 16.0f + 2.0E-4f, posFrom.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 0.125f, maxV, this.v(posTo.x() / 16.0f + 2.0E-4f, posFrom.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posTo.x() / 16.0f + 2.0E-4f, posFrom.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posTo.x() / 16.0f + 2.0E-4f, posFrom.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 0.125f, minV, bark));
        builder.addCulledFace(Direction.EAST, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f - 1.0E-4f, posTo.z() / 16.0f), 1.0f, maxV, this.v(posTo.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f - 1.0E-4f, posTo.z() / 16.0f), 0.875f, maxV, this.v(posTo.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f - 1.0E-4f, posFrom.z() / 16.0f), 0.875f, minV, this.v(posTo.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f - 1.0E-4f, posFrom.z() / 16.0f), 1.0f, minV, bark));
        builder.addCulledFace(Direction.WEST, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f - 1.0E-4f, posTo.z() / 16.0f), 0.125f, maxV, this.v(posFrom.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f - 1.0E-4f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posFrom.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f - 1.0E-4f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posFrom.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f - 1.0E-4f, posFrom.z() / 16.0f), 0.125f, minV, bark));
        builder.addCulledFace(Direction.EAST, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posFrom.z() / 16.0f), 1.0f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posFrom.z() / 16.0f), 0.875f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posTo.z() / 16.0f), 0.875f, maxV, this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posTo.z() / 16.0f), 1.0f, maxV, bark));
        builder.addCulledFace(Direction.WEST, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posFrom.z() / 16.0f), 0.125f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posTo.z() / 16.0f), 0.125f, maxV, bark));
        return builder.build();
    }

    public BakedModel bakeTopSleeveSpikes(TextureAtlasSprite bark) {
        float minV = 0.25f;
        float maxV = 0.75f;
        Vector3f posFrom = new Vector3f(4.0f, 16.0f, 4.0f);
        Vector3f posTo = new Vector3f(12.0f, 16.0f, 12.0f);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.blockModel, ItemOverrides.EMPTY, false).particle(bark);
        builder.addCulledFace(Direction.UP, this.createQuad(this.v(posTo, posTo, posFrom, 0.0f, 0.0625f, -2.0E-4f), 1.0f, minV, this.v(posTo, posTo, posFrom, 0.0f, -0.0625f, -2.0E-4f), 0.875f, minV, this.v(posFrom, posTo, posFrom, 0.0f, -0.0625f, -2.0E-4f), 0.875f, maxV, this.v(posFrom, posTo, posFrom, 0.0f, 0.0625f, -2.0E-4f), 1.0f, maxV, bark));
        builder.addCulledFace(Direction.UP, this.createQuad(this.v(posFrom, posTo, posTo, 0.0f, 0.0625f, 2.0E-4f), 1.0f, maxV, this.v(posFrom, posTo, posTo, 0.0f, -0.0625f, 2.0E-4f), 0.875f, maxV, this.v(posTo, posTo, posTo, 0.0f, -0.0625f, 2.0E-4f), 0.875f, minV, this.v(posTo, posTo, posTo, 0.0f, 0.0625f, 2.0E-4f), 1.0f, minV, bark));
        builder.addCulledFace(Direction.UP, this.createQuad(this.v(posFrom, posTo, posTo, 0.0f, 2.0E-4f, -0.0625f), 0.875f, maxV, this.v(posFrom, posTo, posTo, 0.0f, 2.0E-4f, 0.0625f), 1.0f, maxV, this.v(posTo, posTo, posTo, 0.0f, 2.0E-4f, 0.0625f), 1.0f, minV, this.v(posTo, posTo, posTo, 0.0f, 2.0E-4f, -0.0625f), 0.875f, minV, bark));
        builder.addCulledFace(Direction.UP, this.createQuad(this.v(posFrom, posTo, posFrom, 0.0f, 2.0E-4f, -0.0625f), 0.0f, maxV, this.v(posFrom, posTo, posFrom, 0.0f, 2.0E-4f, 0.0625f), 0.125f, maxV, this.v(posTo, posTo, posFrom, 0.0f, 2.0E-4f, 0.0625f), 0.125f, minV, this.v(posTo, posTo, posFrom, 0.0f, 2.0E-4f, -0.0625f), 0.0f, minV, bark));
        builder.addCulledFace(Direction.UP, this.createQuad(this.v(posFrom.x() / 16.0f - 2.0E-4f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 1.0f, minV, this.v(posFrom.x() / 16.0f - 2.0E-4f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 0.875f, minV, this.v(posFrom.x() / 16.0f - 2.0E-4f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 0.875f, maxV, this.v(posFrom.x() / 16.0f - 2.0E-4f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 1.0f, maxV, bark));
        builder.addCulledFace(Direction.UP, this.createQuad(this.v(posTo.x() / 16.0f + 2.0E-4f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 1.0f, maxV, this.v(posTo.x() / 16.0f + 2.0E-4f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 0.875f, maxV, this.v(posTo.x() / 16.0f + 2.0E-4f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 0.875f, minV, this.v(posTo.x() / 16.0f + 2.0E-4f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 1.0f, minV, bark));
        builder.addCulledFace(Direction.UP, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posFrom.z() / 16.0f), 1.0f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posFrom.z() / 16.0f), 0.875f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posTo.z() / 16.0f), 0.875f, maxV, this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posTo.z() / 16.0f), 1.0f, maxV, bark));
        builder.addCulledFace(Direction.UP, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posFrom.z() / 16.0f), 0.125f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 1.0E-4f, posTo.z() / 16.0f), 0.125f, maxV, bark));
        return builder.build();
    }

    public int getFaceAngle(Direction.Axis axis, Direction face) {
        if (axis == Direction.Axis.Y) {
            return 0;
        }
        if (axis == Direction.Axis.Z) {
            switch (face) {
                case UP: {
                    return 0;
                }
                case WEST: {
                    return 270;
                }
                case DOWN: {
                    return 180;
                }
            }
            return 90;
        }
        return face == Direction.NORTH ? 270 : 90;
    }

    private Vec3 v(Vector3f xVec, Vector3f yVec, Vector3f zVec, float xOffset, float yOffset, float zOffset) {
        return this.v(xVec.x() / 16.0f + xOffset, yVec.y() / 16.0f + yOffset, zVec.z() / 16.0f + zOffset);
    }

    private Vec3 v(float x, float y, float z) {
        return new Vec3((double)x, (double)y, (double)z);
    }

    private int getRadiusIndex(int radius) {
        for (int i = 0; i < this.radii.length; ++i) {
            if (radius != this.radii[i]) continue;
            return i;
        }
        return 0;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource random, @Nonnull ModelData extraData, @Nullable RenderType renderType) {
        if (side == null && state != null) {
            ArrayList<BakedQuad> quadsList = new ArrayList<BakedQuad>(12);
            int coreRadius = this.getRadius(state);
            int[] connections = new int[]{0, 0, 0, 0, 0, 0};
            Direction forceRingDir = null;
            ModelConnections connectionsData = (ModelConnections)extraData.get(ModelConnections.CONNECTIONS_PROPERTY);
            if (connectionsData != null) {
                connections = connectionsData.getAllRadii();
                forceRingDir = connectionsData.getRingOnly();
            }
            int numConnections = 0;
            for (int i : connections) {
                numConnections += i != 0 ? 1 : 0;
            }
            if (numConnections == 0 && forceRingDir != null) {
                quadsList.addAll(this.rings[this.getRadiusIndex(coreRadius)].getQuads(state, forceRingDir, random, extraData, renderType));
            } else {
                Direction sourceDir;
                boolean extraUpSleeve = false;
                if (coreRadius == this.radii[0] && numConnections == 1 && ((Direction)state.getValue(CactusBranchBlock.ORIGIN)).getAxis().isHorizontal()) {
                    connections[1] = this.radii[0];
                    extraUpSleeve = true;
                }
                if ((sourceDir = this.getSourceDir(coreRadius, connections)) == null) {
                    sourceDir = Direction.DOWN;
                }
                int coreDir = this.resolveCoreDir(sourceDir);
                Direction coreRingDir = numConnections == 1 ? sourceDir.getOpposite() : null;
                for (Direction face : Direction.values()) {
                    if (coreRadius != connections[face.get3DDataValue()]) {
                        if (coreRingDir == null || coreRingDir != face) {
                            quadsList.addAll(this.cores[coreDir][this.getRadiusIndex(coreRadius)].getQuads(state, face, random, extraData, renderType));
                        } else {
                            quadsList.addAll(this.rings[this.getRadiusIndex(coreRadius)].getQuads(state, face, random, extraData, renderType));
                        }
                    }
                    for (Direction dir : Direction.values()) {
                        if (coreRadius <= connections[dir.get3DDataValue()]) continue;
                        for (BakedQuad quad : this.coreSpikes[this.getRadiusIndex(coreRadius)].getQuads(state, dir, random, extraData, renderType)) {
                            if (coreRadius <= connections[quad.getDirection().get3DDataValue()]) continue;
                            quadsList.add(quad);
                        }
                    }
                    for (Direction connDir : Direction.values()) {
                        int idx = connDir.get3DDataValue();
                        int connRadius = connections[idx];
                        if (connRadius < this.radii[0] || (connDir != Direction.UP || connRadius != this.radii[0] || !extraUpSleeve) && face == connDir && connDir != Direction.DOWN) continue;
                        quadsList.addAll(this.sleeves[idx][this.getRadiusIndex(connRadius)].getQuads(state, face, random, extraData, renderType));
                    }
                }
                if (extraUpSleeve) {
                    quadsList.addAll(this.sleeveTopSpikes.getQuads(state, Direction.UP, random, extraData, renderType));
                }
            }
            return quadsList;
        }
        return Collections.emptyList();
    }

    public ModelData getModelData(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData extraData) {
        ModelConnections modelConnections;
        Block block = state.getBlock();
        if (block instanceof BranchBlock) {
            BranchBlock branchBlock = (BranchBlock)block;
            modelConnections = new ModelConnections(branchBlock.getConnectionData(level, pos, state)).setFamily(branchBlock.getFamily());
        } else {
            modelConnections = new ModelConnections();
        }
        return modelConnections.toModelData(extraData);
    }

    @Nullable
    protected Direction getSourceDir(int coreRadius, int[] connections) {
        int largestConnection = 0;
        Direction sourceDir = null;
        for (Direction dir : Direction.values()) {
            int connRadius = connections[dir.get3DDataValue()];
            if (connRadius <= largestConnection) continue;
            largestConnection = connRadius;
            sourceDir = dir;
        }
        if (largestConnection < coreRadius) {
            sourceDir = null;
        }
        return sourceDir;
    }

    protected int resolveCoreDir(Direction dir) {
        return dir.get3DDataValue() >> 1;
    }

    protected int getRadius(BlockState blockState) {
        return ((CactusBranchBlock)blockState.getBlock()).getRadius(blockState);
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public TextureAtlasSprite getParticleIcon(@Nullable ModelData extraData) {
        return this.getParticleIcon();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.barkTexture;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    @Nonnull
    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{this.getRenderType()});
    }

    public RenderType getRenderType() {
        ResourceLocation renderTypeHint = this.blockModel.customData.getRenderTypeHint();
        return renderTypeHint == null ? RenderType.cutoutMipped() : NamedRenderTypeManager.get((ResourceLocation)renderTypeHint).block();
    }
}

