/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.resources;

import com.dtteam.dynamictrees.deserialization.PropertyAppliers;
import com.dtteam.dynamictrees.event.ApplierRegistryEvent;
import com.dtteam.dynamictrees.event.JsonDeserializerRegistryEvent;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import com.dtteam.dynamictreesplus.block.mushroom.CapProperties;
import com.dtteam.dynamictreesplus.resources.DTPJsonDeserializers;
import com.dtteam.dynamictreesplus.systems.mushroomlogic.MushroomShapeConfiguration;
import com.dtteam.dynamictreesplus.systems.thicknesslogic.CactusThicknessLogic;
import com.dtteam.dynamictreesplus.tree.CactusSpecies;
import com.dtteam.dynamictreesplus.tree.HugeMushroomFamily;
import com.dtteam.dynamictreesplus.tree.HugeMushroomSpecies;
import com.google.gson.JsonElement;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="dynamictreesplus", bus=EventBusSubscriber.Bus.MOD)
public final class JsonRegistries {
    private static final Logger LOGGER = LogManager.getLogger();

    private static void logError(ResourceLocation name, String error, String registryName) {
        LOGGER.error("Error whilst loading type \"" + registryName + "\" with name \"" + String.valueOf(name) + "\": {}", (Object)error);
    }

    private static void logWarning(ResourceLocation name, String warning, String registryName) {
        LOGGER.warn("Warning whilst loading type \"" + registryName + "\" with name \"" + String.valueOf(name) + "\": {}", (Object)warning);
    }

    @SubscribeEvent
    public static void registerFamilyCommonAppliers(ApplierRegistryEvent.Common<Family, JsonElement> event) {
        JsonRegistries.registerMushroomCommonApplier((PropertyAppliers<Family, JsonElement>)event.getAppliers());
    }

    public static void registerMushroomCommonApplier(PropertyAppliers<Family, JsonElement> appliers) {
        appliers.register("common_cap", HugeMushroomFamily.class, ResourceLocation.class, (family, registryName) -> {
            ResourceLocation processedRegName = ResourceLocationUtils.parseDTLocation((ResourceLocation)registryName);
            CapProperties.REGISTRY.runOnNextLock(CapProperties.REGISTRY.generateIfValidRunnable(processedRegName, family::setCommonCap, () -> JsonRegistries.logWarning(family.getRegistryName(), "Could not set common cap for family with name \"" + String.valueOf(family) + "\" as cap \"" + String.valueOf(processedRegName) + "\" was not found.", Family.REGISTRY.getName())));
        });
    }

    @SubscribeEvent
    public static void registerSpeciesLoadAppliers(ApplierRegistryEvent.Load<Species, JsonElement> event) {
        JsonRegistries.registerCactusLoadApplier((PropertyAppliers<Species, JsonElement>)event.getAppliers());
    }

    @SubscribeEvent
    public static void registerSpeciesReloadAppliers(ApplierRegistryEvent.Reload<Species, JsonElement> event) {
        JsonRegistries.registerMushroomReloadApplier((PropertyAppliers<Species, JsonElement>)event.getAppliers());
        JsonRegistries.registerCactusReloadApplier((PropertyAppliers<Species, JsonElement>)event.getAppliers());
    }

    @SubscribeEvent
    public static void registerSpeciesDataAppliers(ApplierRegistryEvent.GatherData<Species, JsonElement> event) {
        JsonRegistries.registerCactusReloadApplier((PropertyAppliers<Species, JsonElement>)event.getAppliers());
    }

    public static void registerCactusLoadApplier(PropertyAppliers<Species, JsonElement> appliers) {
        appliers.register("is_seed_edible", CactusSpecies.class, Boolean.class, CactusSpecies::setSeedEdible);
    }

    public static void registerMushroomReloadApplier(PropertyAppliers<Species, JsonElement> appliers) {
        appliers.register("cap_properties", HugeMushroomSpecies.class, CapProperties.class, HugeMushroomSpecies::setCapProperties).register("mushroom_shape_kit", HugeMushroomSpecies.class, MushroomShapeConfiguration.class, HugeMushroomSpecies::setMushroomShapeConfiguration).register("accept_any_soil", HugeMushroomSpecies.class, Boolean.class, HugeMushroomSpecies::setAcceptAnySoil).register("max_light_for_planting", HugeMushroomSpecies.class, Integer.class, HugeMushroomSpecies::setMaxLightForPlanting);
    }

    public static void registerCactusReloadApplier(PropertyAppliers<Species, JsonElement> appliers) {
        appliers.register("cactus_thickness_logic", CactusSpecies.class, CactusThicknessLogic.class, CactusSpecies::setThicknessLogic);
    }

    @SubscribeEvent
    public static void registerJsonDeserializers(JsonDeserializerRegistryEvent event) {
        DTPJsonDeserializers.register();
    }
}

