/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.systems.featuregen;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.CoordUtils;
import com.dtteam.dynamictrees.worldgen.DynamicTreeGenerationContext;
import com.dtteam.dynamictreesplus.block.CactusBranchBlock;
import java.util.Arrays;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class CactusClonesGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Float> CHANCE_ON_GROW = ConfigurationProperty.floatProperty((String)"chance_on_grow");
    public static final ConfigurationProperty<CactusBranchBlock.CactusThickness> TRUNK_TYPE = ConfigurationProperty.property((String)"trunk_type", CactusBranchBlock.CactusThickness.class);

    public CactusClonesGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{CHANCE_ON_GROW, TRUNK_TYPE});
    }

    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(CHANCE_ON_GROW, (Object)Float.valueOf(0.3f))).with(TRUNK_TYPE, (Object)CactusBranchBlock.CactusThickness.BRANCH);
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        return this.tryToPlaceClones(context.levelContext(), context.pos(), context.species(), true);
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        return context.random().nextFloat() < ((Float)configuration.get(CHANCE_ON_GROW)).floatValue() && this.tryToPlaceClones(context.levelContext(), context.pos(), context.species(), false);
    }

    private boolean tryToPlaceClones(LevelContext levelContext, BlockPos rootPos, Species species, boolean worldgen) {
        LevelAccessor level = levelContext.accessor();
        if (level == null || this.areCactiAround(level, rootPos.above())) {
            return false;
        }
        int clones = 3 + level.getRandom().nextInt(5);
        LinkedList<CoordUtils.Surround> validDirs = new LinkedList<CoordUtils.Surround>(Arrays.asList(CoordUtils.Surround.values()));
        boolean clonePlaced = false;
        for (int i = 0; i < clones; ++i) {
            CoordUtils.Surround selectedDir = (CoordUtils.Surround)validDirs.get(level.getRandom().nextInt(validDirs.size()));
            if (this.placeCloneAtLocation(levelContext, rootPos.offset(selectedDir.getOffset()), species, worldgen)) {
                clonePlaced = true;
            }
            validDirs.remove(selectedDir);
        }
        return clonePlaced;
    }

    private boolean areCactiAround(LevelAccessor world, BlockPos rootPos) {
        for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
            for (int i = -1; i <= 1; ++i) {
                BlockPos offsetPos = rootPos.offset(dir.getOffset()).above(i);
                if (!(world.getBlockState(offsetPos).getBlock() instanceof BranchBlock)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean placeCloneAtLocation(LevelContext levelContext, BlockPos cloneRootPos, Species species, boolean worldgen) {
        LevelAccessor level = levelContext.accessor();
        ChunkPos chunkPos = new ChunkPos(cloneRootPos);
        if (!level.hasChunk(chunkPos.x, chunkPos.z)) {
            return false;
        }
        for (int i = 1; i >= -1; --i) {
            BlockPos offsetRootPos = cloneRootPos.above(i);
            if (!species.isAcceptableSoil(level.getBlockState(offsetRootPos))) continue;
            if (worldgen) {
                if (level instanceof WorldGenRegion) {
                    Holder biome = level.getBiome(offsetRootPos);
                    species.generate(new DynamicTreeGenerationContext(levelContext, species, offsetRootPos, offsetRootPos.mutable(), biome, CoordUtils.getRandomDir((RandomSource)level.getRandom()), 2, worldgen));
                }
            } else if (level instanceof Level) {
                species.transitionToTree((Level)level, offsetRootPos.above());
            }
            return true;
        }
        return false;
    }
}

