/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.systems.featuregen;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.network.NodeInspector;
import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.fruit.Fruit;
import com.dtteam.dynamictrees.systems.genfeature.FruitGenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.systems.nodemapper.FindEndsNode;
import com.dtteam.dynamictrees.systems.season.SeasonHelper;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.CoordUtils;
import com.dtteam.dynamictreesplus.block.CactusBranchBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class CactusFruitGenFeature
extends FruitGenFeature {
    public CactusFruitGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{FRUIT, QUANTITY, FRUITING_RADIUS, PLACE_CHANCE});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)new GenFeatureConfiguration((GenFeature)this).with(FRUIT, (Object)Fruit.NULL)).with(QUANTITY, (Object)2)).with(FRUITING_RADIUS, (Object)4)).with(PLACE_CHANCE, (Object)Float.valueOf(0.6f));
    }

    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        return species.hasFruit((Fruit)configuration.get(FRUIT));
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (!context.endPoints().isEmpty()) {
            int qty = (Integer)configuration.get(QUANTITY);
            qty = (int)((float)qty * context.fruitProductionFactor().floatValue());
            for (int i = 0; i < qty; ++i) {
                BlockPos endPoint = (BlockPos)context.endPoints().get(context.random().nextInt(context.endPoints().size()));
                this.placeDuringWorldGen(configuration, context.species(), context.level(), context.pos().above(), endPoint, context.isWorldGen(), context.seasonValue());
            }
            return true;
        }
        return false;
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (context.fertility() != 0) {
            return false;
        }
        LevelAccessor world = context.level();
        BlockState blockState = world.getBlockState(context.treePos());
        BranchBlock branch = TreeHelper.getBranch((BlockState)blockState);
        Fruit fruit = (Fruit)configuration.get(FRUIT);
        if (branch != null && branch.getRadius(blockState) >= (Integer)configuration.get(FRUITING_RADIUS) && context.natural()) {
            BlockPos rootPos = context.pos();
            float fruitingFactor = fruit.seasonalFruitProductionFactor(context.levelContext(), rootPos);
            if (fruitingFactor > fruit.getMinProductionFactor() && fruitingFactor > world.getRandom().nextFloat()) {
                FindEndsNode endFinder = new FindEndsNode();
                TreeHelper.startAnalysisFromRoot((LevelAccessor)world, (BlockPos)rootPos, (MapSignal)new MapSignal(new NodeInspector[]{endFinder}));
                List endPoints = endFinder.getEnds();
                int qty = (Integer)configuration.get(QUANTITY);
                if (!endPoints.isEmpty()) {
                    for (int i = 0; i < qty; ++i) {
                        BlockPos endPoint = (BlockPos)endPoints.get(world.getRandom().nextInt(endPoints.size()));
                        this.place(configuration, context.species(), world, rootPos.above(), endPoint, SeasonHelper.getSeasonValue((LevelContext)context.levelContext(), (BlockPos)rootPos));
                    }
                }
            }
        }
        return true;
    }

    protected boolean shouldPlace(GenFeatureConfiguration configuration, LevelAccessor world, BlockPos pos) {
        BlockState belowState = world.getBlockState(pos.below());
        return pos != BlockPos.ZERO && (CoordUtils.coordHashCode((BlockPos)pos, (int)0) & 6) == 0 && world.getRandom().nextFloat() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue() && world.getBlockState(pos).canBeReplaced() && (!(belowState.getBlock() instanceof CactusBranchBlock) || belowState.getValue(CactusBranchBlock.TRUNK_TYPE) == CactusBranchBlock.CactusThickness.BRANCH);
    }

    protected void place(GenFeatureConfiguration configuration, Species species, LevelAccessor world, BlockPos treePos, BlockPos branchPos, Float seasonValue) {
        BlockPos fruitPos = branchPos.above();
        if (this.shouldPlace(configuration, world, fruitPos)) {
            ((Fruit)configuration.get(FRUIT)).place(world, fruitPos, seasonValue);
        }
    }

    protected void placeDuringWorldGen(GenFeatureConfiguration configuration, Species species, LevelAccessor level, BlockPos treePos, BlockPos branchPos, boolean worldGen, Float seasonValue) {
        BlockPos fruitPos = branchPos.above();
        if (this.shouldPlaceDuringWorldGen(configuration, level, fruitPos)) {
            ((Fruit)configuration.get(FRUIT)).placeDuringWorldGen(level, fruitPos, seasonValue);
        }
    }
}

