/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.systems.growthlogic;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKitConfiguration;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionManipulationContext;
import com.dtteam.dynamictreesplus.block.CactusBranchBlock;
import com.dtteam.dynamictreesplus.systems.growthlogic.StraightLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public final class MegaCactusLogic
extends StraightLogic {
    private static final ConfigurationProperty<Integer> STOP_BRANCHING_HEIGHT = ConfigurationProperty.integer((String)"stop_branching_height");
    private static final ConfigurationProperty<Integer> MAX_HEIGHT = ConfigurationProperty.integer((String)"max_height");

    public MegaCactusLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        super.registerProperties();
        this.register(new ConfigurationProperty[]{STOP_BRANCHING_HEIGHT, MAX_HEIGHT});
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(STOP_BRANCHING_HEIGHT, (Object)5)).with(MAX_HEIGHT, (Object)7);
    }

    @Override
    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = context.probMap();
        GrowSignal signal = context.signal();
        Level level = context.level();
        BlockPos pos = context.pos();
        Direction originDir = signal.dir.getOpposite();
        int height = pos.getY() - signal.rootPos.getY();
        if (height >= (Integer)configuration.get(MAX_HEIGHT) && level.random.nextFloat() < 0.8f) {
            signal.energy = 0.0f;
            return new int[]{0, 0, 0, 0, 0, 0};
        }
        if (height > (Integer)configuration.get(STOP_BRANCHING_HEIGHT)) {
            return new int[]{0, 1, 0, 0, 0, 0};
        }
        probMap[0] = 0;
        probMap[1] = (int)((double)context.species().getUpProbability() + signal.rootPos.distSqr(new Vec3i(pos.getX(), signal.rootPos.getY(), pos.getZ())) * 0.8);
        probMap[5] = level.getBlockState(pos.above()).getBlock() instanceof CactusBranchBlock && signal.energy > 1.0f ? 3 : 0;
        probMap[4] = probMap[5];
        probMap[3] = probMap[5];
        probMap[2] = probMap[5];
        if (signal.dir != Direction.UP) {
            probMap[signal.dir.ordinal()] = 0;
        }
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }
}

