/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.tree;

import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictreesplus.DynamicTreesPlus;
import com.dtteam.dynamictreesplus.block.CactusBranchBlock;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;

public class CactusFamily
extends Family {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(CactusFamily::new);
    public static final String BRANCH_BOTTOM = "branch_bottom";

    public CactusFamily(ResourceLocation registryName) {
        super(registryName);
    }

    public BlockBehaviour.Properties getDefaultBranchProperties() {
        return super.getDefaultBranchProperties().sound(SoundType.WOOL).mapColor(MapColor.PLANT);
    }

    protected BranchBlock createBranchBlock(ResourceLocation name) {
        return new CactusBranchBlock(name, this.getProperties());
    }

    public int getPrimaryThickness() {
        return 5;
    }

    public int getSecondaryThickness() {
        return 4;
    }

    public ResourceLocation getBranchLoader() {
        return DynamicTreesPlus.CACTUS;
    }
}

