/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.tree;

import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.network.NodeInspector;
import com.dtteam.dynamictrees.api.registry.RegistryHandler;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.item.Seed;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKit;
import com.dtteam.dynamictrees.systems.nodemapper.FindEndsNode;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import com.dtteam.dynamictrees.worldgen.DynamicTreeGenerationContext;
import com.dtteam.dynamictrees.worldgen.JoCode;
import com.dtteam.dynamictreesplus.DynamicTreesPlus;
import com.dtteam.dynamictreesplus.block.CactusBranchBlock;
import com.dtteam.dynamictreesplus.init.DTPConfigs;
import com.dtteam.dynamictreesplus.init.DTPRegistries;
import com.dtteam.dynamictreesplus.items.FoodSeed;
import com.dtteam.dynamictreesplus.systems.thicknesslogic.CactusThicknessLogic;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;

public class CactusSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = CactusSpecies.createDefaultType(CactusSpecies::new);
    private CactusThicknessLogic thicknessLogic;
    private boolean isSeedEdible = false;

    public CactusSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
    }

    public Species setPreReloadDefaults() {
        return this.setSaplingShape(DTPRegistries.MEDIUM_CACTUS_SAPLING_SHAPE).setSaplingSound(SoundType.WOOL).setDefaultGrowingParameters().envFactor(Tags.Biomes.IS_SNOWY, 0.25f).envFactor(Tags.Biomes.IS_COLD, 0.5f).envFactor(Tags.Biomes.IS_SANDY, 1.05f).setGrowthLogicKit((GrowthLogicKit)DTPRegistries.STRAIGHT_LOGIC);
    }

    public Species setPostReloadDefaults() {
        if (this.thicknessLogic == null) {
            this.thicknessLogic = (CactusThicknessLogic)CactusThicknessLogic.REGISTRY.get(this.getRegistryName());
        }
        return super.setPostReloadDefaults();
    }

    public void setThicknessLogic(CactusThicknessLogic thicknessLogic) {
        this.thicknessLogic = thicknessLogic;
    }

    public CactusBranchBlock.CactusThickness thicknessAfterGrowthSignal(Level level, BlockPos pos, GrowSignal signal, CactusBranchBlock.CactusThickness currentThickness) {
        return this.thicknessLogic.thicknessAfterGrowthSignal(level, pos, signal, currentThickness);
    }

    public CactusBranchBlock.CactusThickness thicknessForBranchPlaced(LevelAccessor level, BlockPos pos, boolean isLast) {
        return this.thicknessLogic.thicknessForBranchPlaced(level, pos, isLast);
    }

    protected void setStandardSoils() {
        this.addAcceptableSoils(new String[]{"sand_like"});
    }

    public JoCode getJoCode(String joCodeString) {
        return new JoCodeCactus(joCodeString);
    }

    public boolean isBiomePerfect(Holder<Biome> biome) {
        return this.perfectBiomes.size() > 0 ? super.isBiomePerfect(biome) : biome.is(Tags.Biomes.IS_DRY) && biome.is(Tags.Biomes.IS_SANDY);
    }

    public boolean handleRot(LevelAccessor level, List<BlockPos> ends, BlockPos rootPos, BlockPos treePos, int fertility, boolean worldGen) {
        return false;
    }

    protected boolean transitionToTree(Level level, BlockPos pos, Family family) {
        this.placeRootyDirtBlock((LevelAccessor)level, pos.below(), 15);
        family.getBranch().ifPresent(branch -> level.setBlockAndUpdate(pos, (BlockState)branch.defaultBlockState().setValue(CactusBranchBlock.TRUNK_TYPE, (Comparable)((Object)this.thicknessForBranchPlaced((LevelAccessor)level, pos, false)))));
        return true;
    }

    public boolean canBoneMealTree() {
        return (Boolean)DTPConfigs.CAN_BONE_MEAL_CACTUS.get();
    }

    public ResourceLocation getSaplingSmartModelLocation() {
        return DynamicTreesPlus.location("block/smart_model/" + this.thicknessLogic.getRegistryName().getPath() + "_cactus");
    }

    public void addSaplingTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation leavesTextureLocation, ResourceLocation barkTextureLocation) {
        ResourceLocation sideLoc = this.getFamily().getTexturePath("branch").orElse(ResourceLocationUtils.suffix((ResourceLocation)barkTextureLocation, (String)"_side"));
        ResourceLocation topLoc = this.getFamily().getTexturePath("branch_top").orElse(ResourceLocationUtils.suffix((ResourceLocation)barkTextureLocation, (String)"_top"));
        ResourceLocation botLoc = this.getFamily().getTexturePath("branch_bottom").orElse(ResourceLocationUtils.suffix((ResourceLocation)barkTextureLocation, (String)"_bottom"));
        textureConsumer.accept("side", sideLoc);
        textureConsumer.accept("top", topLoc);
        textureConsumer.accept("bottom", botLoc);
    }

    public boolean shouldGenerateVoluntaryDrops() {
        return false;
    }

    public Species generateSeed() {
        return !this.shouldGenerateSeed() || this.seed != null ? this : this.setSeed(RegistryHandler.addItem((ResourceLocation)this.getSeedName(), this::createSeedItem));
    }

    public Seed createSeedItem() {
        return this.isSeedEdible ? new FoodSeed(this) : new Seed((Species)this);
    }

    public void setSeedEdible(boolean edible) {
        this.isSeedEdible = edible;
    }

    private static class JoCodeCactus
    extends JoCode {
        public JoCodeCactus(String code) {
            super(code);
        }

        public void generate(DynamicTreeGenerationContext context) {
            LevelAccessor level = context.level();
            BlockPos.MutableBlockPos rootPos = context.rootPos();
            BlockState initialDirtState = level.getBlockState((BlockPos)rootPos);
            context.species().placeRootyDirtBlock(level, (BlockPos)rootPos, 0);
            int radius = Mth.clamp((int)context.radius(), (int)2, (int)8);
            BlockPos treePos = rootPos.above();
            this.setFacing(context.facing());
            this.generateFork(level, context.species(), 0, (BlockPos)rootPos, false);
            BranchBlock branch = TreeHelper.getBranch((BlockState)level.getBlockState(treePos));
            if (branch != null) {
                FindEndsNode endFinder = new FindEndsNode();
                MapSignal signal = new MapSignal(new NodeInspector[]{endFinder});
                branch.analyse(level.getBlockState(treePos), level, treePos, Direction.DOWN, signal);
                List endPoints = endFinder.getEnds();
                PostGenerationContext pgContext = new PostGenerationContext(context, endPoints, initialDirtState);
                context.species().postGeneration(pgContext);
                Services.EVENT.postSpeciesPostGenerationEvent(pgContext);
            } else {
                level.setBlock((BlockPos)rootPos, initialDirtState, this.careful ? 3 : 2);
            }
        }

        public boolean setBlockForGeneration(LevelAccessor level, Species species, BlockPos pos, Direction dir, boolean careful, boolean isLast) {
            boolean replace;
            Optional branch = species.getFamily().getBranch();
            if (!(species instanceof CactusSpecies) || !branch.isPresent()) {
                return false;
            }
            BlockState defaultBranchState = ((BranchBlock)branch.get()).defaultBlockState();
            BlockState replaceState = level.getBlockState(pos);
            boolean bl = replace = replaceState.isAir() || replaceState.is(BlockTags.LEAVES) || replaceState.is(Blocks.GRASS_BLOCK) || replaceState.is(BlockTags.DIRT) || replaceState.is(BlockTags.LOGS) || replaceState.is(BlockTags.SAPLINGS) || replaceState.is(Blocks.VINE);
            if (replace && (!careful || this.isClearOfNearbyBranches(level, pos, dir.getOpposite()))) {
                CactusBranchBlock.CactusThickness trunk = ((CactusSpecies)species).thicknessForBranchPlaced(level, pos, isLast);
                return !level.setBlock(pos, (BlockState)((BlockState)defaultBranchState.setValue(CactusBranchBlock.TRUNK_TYPE, (Comparable)((Object)trunk))).setValue(CactusBranchBlock.ORIGIN, (Comparable)dir.getOpposite()), careful ? 3 : 2);
            }
            return true;
        }
    }
}

