/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.tree;

import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.api.voxmap.BlockPosBounds;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.data.tags.DTBlockTags;
import com.dtteam.dynamictrees.data.tags.DTItemTags;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictreesplus.block.mushroom.CapProperties;
import com.dtteam.dynamictreesplus.block.mushroom.MushroomBranchBlock;
import com.dtteam.dynamictreesplus.tree.HugeMushroomSpecies;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class HugeMushroomFamily
extends Family {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(HugeMushroomFamily::new);
    protected CapProperties commonCap = CapProperties.NULL;

    public HugeMushroomFamily(ResourceLocation name) {
        super(name);
    }

    public Family setPreReloadDefaults() {
        this.setPrimaryThickness(2);
        this.setSecondaryThickness(3);
        return this;
    }

    public CapProperties getCommonCap() {
        return this.commonCap;
    }

    public void setCommonCap(CapProperties properties) {
        this.commonCap = properties;
        properties.setFamily(this);
    }

    public List<TagKey<Block>> defaultBranchTags() {
        return Collections.singletonList(DTBlockTags.FUNGUS_BRANCHES);
    }

    public List<TagKey<Item>> defaultBranchItemTags() {
        return Collections.singletonList(DTItemTags.FUNGUS_BRANCHES);
    }

    public List<TagKey<Block>> defaultStrippedBranchTags() {
        return Collections.singletonList(DTBlockTags.STRIPPED_FUNGUS_BRANCHES);
    }

    public BlockPosBounds expandLeavesBlockBounds(BlockPosBounds bounds) {
        return bounds.expand(8);
    }

    public boolean isCompatibleCap(HugeMushroomSpecies species, BlockState state, Level level, BlockPos pos) {
        return species.getCapProperties().isPartOfCap(state);
    }

    protected BranchBlock createBranchBlock(ResourceLocation name) {
        MushroomBranchBlock branch = new MushroomBranchBlock(name, this.getProperties());
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }
}

