/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.worldgen.canceller;

import com.dtteam.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.dtteam.dynamictrees.api.worldgen.FeatureCanceller;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class CactusFeatureCanceller<T extends Block>
extends FeatureCanceller {
    private static final RandomSource PLACEHOLDER_RANDOM = RandomSource.create((long)0L);
    private final Class<T> cactusBlockClass;

    public CactusFeatureCanceller(ResourceLocation registryName, Class<T> cactusBlockClass) {
        super(registryName);
        this.cactusBlockClass = cactusBlockClass;
    }

    public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
        BlockColumnConfiguration blockColumnConfiguration;
        block7: {
            block6: {
                ResourceLocation featureResLoc = BuiltInRegistries.FEATURE.getKey((Object)configuredFeature.feature());
                if (featureResLoc == null) {
                    return false;
                }
                FeatureConfiguration featureConfig = configuredFeature.config();
                if (featureConfig instanceof RandomPatchConfiguration) {
                    RandomPatchConfiguration randomPatchConfiguration = (RandomPatchConfiguration)featureConfig;
                    PlacedFeature placedFeature = (PlacedFeature)randomPatchConfiguration.feature().value();
                    featureConfig = ((ConfiguredFeature)placedFeature.feature().value()).config();
                }
                if (!(featureConfig instanceof BlockColumnConfiguration)) break block6;
                blockColumnConfiguration = (BlockColumnConfiguration)featureConfig;
                if (featureCancellations.shouldCancelNamespace(featureResLoc.getNamespace())) break block7;
            }
            return false;
        }
        for (BlockColumnConfiguration.Layer layer : blockColumnConfiguration.layers()) {
            BlockStateProvider stateProvider = layer.state();
            if (!(stateProvider instanceof SimpleStateProvider) || !this.cactusBlockClass.isInstance(stateProvider.getState(PLACEHOLDER_RANDOM, BlockPos.ZERO).getBlock())) continue;
            return true;
        }
        return false;
    }
}

