/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictreesplus.worldgen.canceller;

import com.dtteam.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.dtteam.dynamictrees.api.worldgen.FeatureCanceller;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomBooleanFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;

public class MushroomFeatureCanceller<T extends FeatureConfiguration>
extends FeatureCanceller {
    private final Class<T> mushroomFeatureConfigClass;

    public MushroomFeatureCanceller(ResourceLocation registryName, Class<T> mushroomFeatureConfigClass) {
        super(registryName);
        this.mushroomFeatureConfigClass = mushroomFeatureConfigClass;
    }

    public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
        ResourceLocation featureRegistryName = BuiltInRegistries.FEATURE.getKey((Object)configuredFeature.feature());
        if (featureRegistryName == null) {
            return false;
        }
        FeatureConfiguration featureConfiguration = configuredFeature.config();
        if (featureConfiguration instanceof RandomFeatureConfiguration) {
            RandomFeatureConfiguration randomFeatureConfig = (RandomFeatureConfiguration)featureConfiguration;
            return this.randomFeatureContainsConfigClass(randomFeatureConfig.getFeatures()) && featureCancellations.shouldCancelNamespace(featureRegistryName.getNamespace());
        }
        featureConfiguration = configuredFeature.config();
        if (featureConfiguration instanceof RandomBooleanFeatureConfiguration) {
            RandomBooleanFeatureConfiguration randomBoolConfig = (RandomBooleanFeatureConfiguration)featureConfiguration;
            return this.randomFeatureContainsConfigClass(randomBoolConfig.getFeatures()) && featureCancellations.shouldCancelNamespace(featureRegistryName.getNamespace());
        }
        return this.mushroomFeatureConfigClass.isInstance(configuredFeature.config());
    }

    private boolean randomFeatureContainsConfigClass(Stream<ConfiguredFeature<?, ?>> randomFeatureConfig) {
        Stream<FeatureConfiguration> stream = randomFeatureConfig.map(ConfiguredFeature::config);
        return stream.anyMatch(this.mushroomFeatureConfigClass::isInstance);
    }
}

