/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.specter;

import com.cursee.specter.Constants;
import com.cursee.specter.SpecterClientForge;
import com.cursee.specter.SpecterCommon;
import com.cursee.specter.SpecterServer;
import com.cursee.specter.impl.common.entity.Specter;
import com.cursee.specter.impl.common.registry.ModEntities;
import com.cursee.specter.impl.common.registry.ModItems;
import com.cursee.specter.impl.forge.common.loot.ForgeLootModifiers;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;

@Mod(value="specter")
public class SpecterForge {
    public static IEventBus eventBus;

    public SpecterForge(FMLJavaModLoadingContext context) {
        eventBus = context.getModEventBus();
        SpecterForge.bind(Registries.f_256913_, ModItems::register);
        SpecterForge.bind(Registries.f_256939_, ModEntities::register);
        SpecterCommon.init();
        if (FMLLoader.getDist() == Dist.CLIENT) {
            new SpecterClientForge();
        }
        eventBus.addListener(event -> event.put(ModEntities.SPECTER, Specter.createAttributes().m_22265_()));
        MinecraftForge.EVENT_BUS.addListener(event -> SpecterServer.onServerStarting(event.getServer()));
        MinecraftForge.EVENT_BUS.addListener(event -> SpecterServer.onServerStarted(event.getServer()));
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Level patt2428$temp = event.getLevel();
            if (patt2428$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt2428$temp;
                SpecterServer.onEntityJoinServerLevel(event.getEntity(), serverLevel);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> SpecterServer.onServerStopping(event.getServer()));
        MinecraftForge.EVENT_BUS.addListener(event -> SpecterServer.onServerStopped(event.getServer()));
        ForgeLootModifiers.register(eventBus);
    }

    @Deprecated(forRemoval=true, since="1.21.1")
    public SpecterForge() {
        this(FMLJavaModLoadingContext.get());
        Constants.LOG.info("It is recommended that you update to the latest version of Forge for 1.20.1");
        Constants.LOG.info("See https://files.minecraftforge.net/net/minecraftforge/forge/index_1.20.1.html for new versions.");
    }

    public static <T> void bind(ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        eventBus.addListener(event -> {
            if (registry.equals((Object)event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }
}

