/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.specter.impl.client.model;

import com.cursee.specter.impl.common.entity.Specter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class SpecterModel
extends EntityModel<Specter> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart shell;
    private boolean shouldRenderShell = false;

    public SpecterModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.shell = root.m_171324_("shell");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.0f, -3.0f, 1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition cube_r1 = body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition shell = partdefinition.m_171599_("shell", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-4.0f, -6.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(@NotNull Specter specter, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.shouldRenderShell = specter.getOwner() != null && specter.m_20270_((Entity)specter.getOwner()) < 4.0f;
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int light, int overlay, float r, float g, float b, float a) {
        this.body.m_104306_(poseStack, vertexConsumer, light, overlay, r, g, b, a);
        if (this.shouldRenderShell) {
            this.shell.m_104306_(poseStack, vertexConsumer, light, overlay, r, g, b, a);
        }
    }
}

