/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.specter.impl.client.renderer.entity;

import com.cursee.specter.SpecterCommon;
import com.cursee.specter.impl.client.model.SpecterModel;
import com.cursee.specter.impl.common.entity.Specter;
import com.cursee.specter.impl.common.registry.ModEntities;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class SpecterRenderer
extends EntityRenderer<Specter>
implements RenderLayerParent<Specter, EntityModel<Specter>> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ModEntities.SPECTER_ID, "main");
    private static final ResourceLocation TEXTURE_LOCATION = SpecterCommon.identifier("textures/entity/specter.png");
    private final SpecterModel model;

    public SpecterRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SpecterModel(context.m_174023_(LAYER_LOCATION));
    }

    @NotNull
    public SpecterModel getModel() {
        return this.model;
    }

    @NotNull
    public ResourceLocation getTextureLocation(Specter specter) {
        return TEXTURE_LOCATION;
    }

    public boolean shouldRender(Specter livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public void render(Specter specter, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0625f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f - specter.m_5686_(1.0f)));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.getModel().setupAnim(specter, partialTick, 0.0f, -0.1f, 0.0f, 0.0f);
        float[] diffuseColors = specter.getDyeColor().m_41068_();
        this.getModel().m_7695_(poseStack, buffer.m_6299_(RenderType.m_110470_((ResourceLocation)this.getTextureLocation(specter))), packedLight, OverlayTexture.f_118083_, diffuseColors[0], diffuseColors[1], diffuseColors[2], 1.0f);
        poseStack.m_85849_();
        super.m_7392_((Entity)specter, entityYaw, partialTick, poseStack, buffer, packedLight);
    }
}

